package drr.standards.iosco.cde.base.quantity.functions;

import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.BeforeTradeForEvent;
import drr.regulation.common.functions.IsActionTypeTERM;
import drr.regulation.common.functions.TradeForEvent;
import java.util.Optional;
import javax.inject.Inject;


@ImplementedBy(GetTradeForQuantity.GetTradeForQuantityDefault.class)
public abstract class GetTradeForQuantity implements RosettaFunction {
	
	@Inject protected ModelObjectValidator objectValidator;
	
	// RosettaFunction dependencies
	//
	@Inject protected BeforeTradeForEvent beforeTradeForEvent;
	@Inject protected IsActionTypeTERM isActionTypeTERM;
	@Inject protected TradeForEvent tradeForEvent;

	/**
	* @param transactionReportInstruction 
	* @return trade 
	*/
	public Trade evaluate(TransactionReportInstruction transactionReportInstruction) {
		Trade.TradeBuilder tradeBuilder = doEvaluate(transactionReportInstruction);
		
		final Trade trade;
		if (tradeBuilder == null) {
			trade = null;
		} else {
			trade = tradeBuilder.build();
			objectValidator.validate(Trade.class, trade);
		}
		
		return trade;
	}

	protected abstract Trade.TradeBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction);

	public static class GetTradeForQuantityDefault extends GetTradeForQuantity {
		@Override
		protected Trade.TradeBuilder doEvaluate(TransactionReportInstruction transactionReportInstruction) {
			Trade.TradeBuilder trade = Trade.builder();
			return assignOutput(trade, transactionReportInstruction);
		}
		
		protected Trade.TradeBuilder assignOutput(Trade.TradeBuilder trade, TransactionReportInstruction transactionReportInstruction) {
			final Boolean _boolean = isActionTypeTERM.evaluate(transactionReportInstruction);
			if ((_boolean == null ? false : _boolean)) {
				trade = toBuilder(beforeTradeForEvent.evaluate(transactionReportInstruction));
			} else {
				trade = toBuilder(tradeForEvent.evaluate(transactionReportInstruction));
			}
			
			return Optional.ofNullable(trade)
				.map(o -> o.prune())
				.orElse(null);
		}
	}
}
