package drr.standards.iosco.cde.version1.payment.reports;

import cdm.event.common.ScheduledTransfer;
import cdm.event.common.Transfer;
import cdm.event.common.TransferExpression;
import cdm.event.common.TransferState;
import cdm.observable.asset.FeeTypeEnum;
import cdm.product.common.settlement.ScheduledTransferEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(OtherPaymentTypeRule.OtherPaymentTypeRuleDefault.class)
public abstract class OtherPaymentTypeRule implements ReportFunction<TransferState, String> {

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public String evaluate(TransferState input) {
		String output = doEvaluate(input);
		
		return output;
	}

	protected abstract String doEvaluate(TransferState input);

	public static class OtherPaymentTypeRuleDefault extends OtherPaymentTypeRule {
		@Override
		protected String doEvaluate(TransferState input) {
			String output = null;
			return assignOutput(output, input);
		}
		
		protected String assignOutput(String output, TransferState input) {
			final MapperS<TransferExpression> thenArg = MapperS.of(input)
				.mapSingleToItem(item -> item.<Transfer>map("getTransfer", transferState -> transferState.getTransfer()).<TransferExpression>map("getTransferExpression", transfer -> transfer.getTransferExpression()));
			output = thenArg
				.mapSingleToItem(item -> {
					if (areEqual(item.<FeeTypeEnum>map("getPriceTransfer", transferExpression -> transferExpression.getPriceTransfer()), MapperS.of(FeeTypeEnum.UPFRONT), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of("UFRO");
					}
					if (areEqual(item.<FeeTypeEnum>map("getPriceTransfer", transferExpression -> transferExpression.getPriceTransfer()), MapperS.of(FeeTypeEnum.TERMINATION), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of("UWIN");
					}
					if (areEqual(item.<ScheduledTransfer>map("getScheduledTransfer", transferExpression -> transferExpression.getScheduledTransfer()).<ScheduledTransferEnum>map("getTransferType", scheduledTransfer -> scheduledTransfer.getTransferType()), MapperS.of(ScheduledTransferEnum.PRINCIPAL_PAYMENT), CardinalityOperator.All).getOrDefault(false)) {
						return MapperS.of("PEXH");
					}
					return MapperS.<String>ofNull();
				}).get();
			
			return output;
		}
	}
}
