package drr.standards.iosco.cde.version3.basket.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.standards.iosco.cde.version2.basket.reports.SourceOfTheIdentifierOfTheBasketConstituentsRule;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;


@ImplementedBy(BasketConstituentIdentifierSourceRule.BasketConstituentIdentifierSourceRuleDefault.class)
public abstract class BasketConstituentIdentifierSourceRule implements ReportFunction<ReportableEvent, List<ProductIdTypeEnum>> {
	
	// RosettaFunction dependencies
	//
	@Inject protected SourceOfTheIdentifierOfTheBasketConstituentsRule sourceOfTheIdentifierOfTheBasketConstituentsRule;

	/**
	* @param input 
	* @return output 
	*/
	@Override
	public List<ProductIdTypeEnum> evaluate(ReportableEvent input) {
		List<ProductIdTypeEnum> output = doEvaluate(input);
		
		return output;
	}

	protected abstract List<ProductIdTypeEnum> doEvaluate(ReportableEvent input);

	public static class BasketConstituentIdentifierSourceRuleDefault extends BasketConstituentIdentifierSourceRule {
		@Override
		protected List<ProductIdTypeEnum> doEvaluate(ReportableEvent input) {
			List<ProductIdTypeEnum> output = new ArrayList<>();
			return assignOutput(output, input);
		}
		
		protected List<ProductIdTypeEnum> assignOutput(List<ProductIdTypeEnum> output, ReportableEvent input) {
			output = sourceOfTheIdentifierOfTheBasketConstituentsRule.evaluate(input);
			
			return output;
		}
	}
}
