package drr.standards.iosco.cde.version3.quantity.functions;

import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_AssetClass_ForeignExchange;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.PayoutLegWithAuxiliary;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FormatToNonNegativeShortFraction5DecimalNumber;
import drr.regulation.common.functions.FormatToShortFraction5DecimalNumber;
import drr.regulation.common.functions.PayoutLeg2;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.cde.base.quantity.functions.GetProductForQuantity;
import drr.standards.iosco.cde.base.quantity.functions.NotionalLeg;
import java.math.BigDecimal;
import javax.inject.Inject;

import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.*;

@ImplementedBy(NotionalAmountLeg2.NotionalAmountLeg2Default.class)
public abstract class NotionalAmountLeg2 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected EconomicTermsForProduct economicTermsForProduct;
	@Inject protected FormatToNonNegativeShortFraction5DecimalNumber formatToNonNegativeShortFraction5DecimalNumber;
	@Inject protected FormatToShortFraction5DecimalNumber formatToShortFraction5DecimalNumber;
	@Inject protected GetProductForQuantity getProductForQuantity;
	@Inject protected NotionalLeg notionalLeg;
	@Inject protected PayoutLeg2 payoutLeg2;
	@Inject protected ProductForEvent productForEvent;
	@Inject protected Qualify_AssetClass_ForeignExchange qualify_AssetClass_ForeignExchange;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return notionalAmountLeg2 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal notionalAmountLeg2 = doEvaluate(transactionReportInstruction, defaultValue);
		
		return notionalAmountLeg2;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class NotionalAmountLeg2Default extends NotionalAmountLeg2 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal notionalAmountLeg2 = null;
			return assignOutput(notionalAmountLeg2, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal notionalAmountLeg2, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			final MapperS<TradableProduct> thenArg0 = MapperS.of(getProductForQuantity.evaluate(transactionReportInstruction));
			final MapperS<PayoutLegWithAuxiliary> thenArg1 = thenArg0
				.mapSingleToItem(item -> MapperS.of(payoutLeg2.evaluate(item.<Product>map("getProduct", tradableProduct -> tradableProduct.getProduct()).get(), item.<TradeLot>mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get(), MapperS.of(transactionReportInstruction).<ReportableInformation>map("getReportableInformation", _transactionReportInstruction -> _transactionReportInstruction.getReportableInformation()).get())));
			notionalAmountLeg2 = thenArg1
				.mapSingleToItem(item -> {
					if (areEqual(MapperS.of(notionalLeg.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue()), MapperS.of(BigDecimal.valueOf(0)), CardinalityOperator.All).andNullSafe(ComparisonResult.ofNullSafe(MapperS.of(qualify_AssetClass_ForeignExchange.evaluate(economicTermsForProduct.evaluate(productForEvent.evaluate(transactionReportInstruction)))))).getOrDefault(false)) {
						return MapperS.of(defaultValue);
					}
					if (exists(item.<CommodityPayout>map("getCommodityPayout", payoutLegWithAuxiliary -> payoutLegWithAuxiliary.getCommodityPayout())).getOrDefault(false)) {
						return MapperS.of(formatToShortFraction5DecimalNumber.evaluate(MapperS.of(notionalLeg.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue()).get()));
					}
					return MapperS.of(formatToNonNegativeShortFraction5DecimalNumber.evaluate(MapperS.of(notionalLeg.evaluate(item.get())).<BigDecimal>map("getValue", measure -> measure.getValue()).get()));
				}).get();
			
			return notionalAmountLeg2;
		}
	}
}
