package drr.standards.iosco.cde.version3.quantity.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.RosettaFunction;
import drr.regulation.common.TransactionReportInstruction;
import java.math.BigDecimal;
import javax.inject.Inject;


@ImplementedBy(TotalNotionalQuantityLeg1.TotalNotionalQuantityLeg1Default.class)
public abstract class TotalNotionalQuantityLeg1 implements RosettaFunction {
	
	// RosettaFunction dependencies
	//
	@Inject protected drr.standards.iosco.cde.version2.quantity.functions.TotalNotionalQuantityLeg1 totalNotionalQuantityLeg1;

	/**
	* @param transactionReportInstruction 
	* @param defaultValue 
	* @return totalTotalNotionalQuantityLeg1 
	*/
	public BigDecimal evaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
		BigDecimal totalTotalNotionalQuantityLeg1 = doEvaluate(transactionReportInstruction, defaultValue);
		
		return totalTotalNotionalQuantityLeg1;
	}

	protected abstract BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue);

	public static class TotalNotionalQuantityLeg1Default extends TotalNotionalQuantityLeg1 {
		@Override
		protected BigDecimal doEvaluate(TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			BigDecimal totalTotalNotionalQuantityLeg1 = null;
			return assignOutput(totalTotalNotionalQuantityLeg1, transactionReportInstruction, defaultValue);
		}
		
		protected BigDecimal assignOutput(BigDecimal totalTotalNotionalQuantityLeg1, TransactionReportInstruction transactionReportInstruction, BigDecimal defaultValue) {
			totalTotalNotionalQuantityLeg1 = totalNotionalQuantityLeg1.evaluate(transactionReportInstruction, defaultValue);
			
			return totalTotalNotionalQuantityLeg1;
		}
	}
}
