package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import iso20022.auth030.esma.meta.CounterpartySpecificData36__2Meta;
import java.time.ZonedDateTime;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Data related specifically to counterparties.
 * @version ${project.version}
 */
@RosettaDataType(value="CounterpartySpecificData36__2", builder=CounterpartySpecificData36__2.CounterpartySpecificData36__2BuilderImpl.class, version="${project.version}")
@RuneDataType(value="CounterpartySpecificData36__2", model="iso20022", builder=CounterpartySpecificData36__2.CounterpartySpecificData36__2BuilderImpl.class, version="${project.version}")
public interface CounterpartySpecificData36__2 extends RosettaModelObject {

	CounterpartySpecificData36__2Meta metaData = new CounterpartySpecificData36__2Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Data specific to counterparties of the reported transaction/position.
	 */
	TradeCounterpartyReport20__1 getCtrPty();
	/**
	 * Indicates the date and time of the submission of the report to the trade repository.
	 */
	ZonedDateTime getRptgTmStmp();

	/*********************** Build Methods  ***********************/
	CounterpartySpecificData36__2 build();
	
	CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder toBuilder();
	
	static CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder builder() {
		return new CounterpartySpecificData36__2.CounterpartySpecificData36__2BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends CounterpartySpecificData36__2> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends CounterpartySpecificData36__2> getType() {
		return CounterpartySpecificData36__2.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__1.class, getCtrPty());
		processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
	}
	

	/*********************** Builder Interface  ***********************/
	interface CounterpartySpecificData36__2Builder extends CounterpartySpecificData36__2, RosettaModelObjectBuilder {
		TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder getOrCreateCtrPty();
		@Override
		TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder getCtrPty();
		CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder setCtrPty(TradeCounterpartyReport20__1 ctrPty);
		CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder setRptgTmStmp(ZonedDateTime rptgTmStmp);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processRosetta(path.newSubPath("ctrPty"), processor, TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder.class, getCtrPty());
			processor.processBasic(path.newSubPath("rptgTmStmp"), ZonedDateTime.class, getRptgTmStmp(), this);
		}
		

		CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder prune();
	}

	/*********************** Immutable Implementation of CounterpartySpecificData36__2  ***********************/
	class CounterpartySpecificData36__2Impl implements CounterpartySpecificData36__2 {
		private final TradeCounterpartyReport20__1 ctrPty;
		private final ZonedDateTime rptgTmStmp;
		
		protected CounterpartySpecificData36__2Impl(CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder builder) {
			this.ctrPty = ofNullable(builder.getCtrPty()).map(f->f.build()).orElse(null);
			this.rptgTmStmp = builder.getRptgTmStmp();
		}
		
		@Override
		@RosettaAttribute(value="ctrPty", isRequired=true)
		@RuneAttribute(value="ctrPty", isRequired=true)
		public TradeCounterpartyReport20__1 getCtrPty() {
			return ctrPty;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@Override
		public CounterpartySpecificData36__2 build() {
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder toBuilder() {
			CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder builder) {
			ofNullable(getCtrPty()).ifPresent(builder::setCtrPty);
			ofNullable(getRptgTmStmp()).ifPresent(builder::setRptgTmStmp);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__2 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__2 {" +
				"ctrPty=" + this.ctrPty + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}

	/*********************** Builder Implementation of CounterpartySpecificData36__2  ***********************/
	class CounterpartySpecificData36__2BuilderImpl implements CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder {
	
		protected TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder ctrPty;
		protected ZonedDateTime rptgTmStmp;
		
		@Override
		@RosettaAttribute(value="ctrPty", isRequired=true)
		@RuneAttribute(value="ctrPty", isRequired=true)
		public TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder getCtrPty() {
			return ctrPty;
		}
		
		@Override
		public TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder getOrCreateCtrPty() {
			TradeCounterpartyReport20__1.TradeCounterpartyReport20__1Builder result;
			if (ctrPty!=null) {
				result = ctrPty;
			}
			else {
				result = ctrPty = TradeCounterpartyReport20__1.builder();
			}
			
			return result;
		}
		
		@Override
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		public ZonedDateTime getRptgTmStmp() {
			return rptgTmStmp;
		}
		
		@RosettaAttribute(value="ctrPty", isRequired=true)
		@RuneAttribute(value="ctrPty", isRequired=true)
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder setCtrPty(TradeCounterpartyReport20__1 _ctrPty) {
			this.ctrPty = _ctrPty == null ? null : _ctrPty.toBuilder();
			return this;
		}
		
		@RosettaAttribute("rptgTmStmp")
		@RuneAttribute("rptgTmStmp")
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder setRptgTmStmp(ZonedDateTime _rptgTmStmp) {
			this.rptgTmStmp = _rptgTmStmp == null ? null : _rptgTmStmp;
			return this;
		}
		
		@Override
		public CounterpartySpecificData36__2 build() {
			return new CounterpartySpecificData36__2.CounterpartySpecificData36__2Impl(this);
		}
		
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder prune() {
			if (ctrPty!=null && !ctrPty.prune().hasData()) ctrPty = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getCtrPty()!=null && getCtrPty().hasData()) return true;
			if (getRptgTmStmp()!=null) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder o = (CounterpartySpecificData36__2.CounterpartySpecificData36__2Builder) other;
			
			merger.mergeRosetta(getCtrPty(), o.getCtrPty(), this::setCtrPty);
			
			merger.mergeBasic(getRptgTmStmp(), o.getRptgTmStmp(), this::setRptgTmStmp);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			CounterpartySpecificData36__2 _that = getType().cast(o);
		
			if (!Objects.equals(ctrPty, _that.getCtrPty())) return false;
			if (!Objects.equals(rptgTmStmp, _that.getRptgTmStmp())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (ctrPty != null ? ctrPty.hashCode() : 0);
			_result = 31 * _result + (rptgTmStmp != null ? rptgTmStmp.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "CounterpartySpecificData36__2Builder {" +
				"ctrPty=" + this.ctrPty + ", " +
				"rptgTmStmp=" + this.rptgTmStmp +
			'}';
		}
	}
}
