package iso20022.auth030.esma;

import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import iso20022.auth030.esma.meta.Schedule1Meta;
import java.util.Objects;

import static java.util.Optional.ofNullable;

/**
 * Indicates the unadjusted effective and end date of the schedule.
 * @version ${project.version}
 */
@RosettaDataType(value="Schedule1", builder=Schedule1.Schedule1BuilderImpl.class, version="${project.version}")
@RuneDataType(value="Schedule1", model="iso20022", builder=Schedule1.Schedule1BuilderImpl.class, version="${project.version}")
public interface Schedule1 extends RosettaModelObject {

	Schedule1Meta metaData = new Schedule1Meta();

	/*********************** Getter Methods  ***********************/
	/**
	 * Indicates the unadjusted date at which obligations under the  derivative transaction come into effect, as included in the confirmation.
	 */
	Date getUadjstdFctvDt();
	/**
	 * Indicates the end date agreed in the derivative transaction without adjustment.
	 */
	Date getUadjstdEndDt();
	/**
	 * Indicates the price per derivative excluding, where applicable: fees, taxes or commissions.
	 */
	SecuritiesTransactionPrice17Choice getPric();

	/*********************** Build Methods  ***********************/
	Schedule1 build();
	
	Schedule1.Schedule1Builder toBuilder();
	
	static Schedule1.Schedule1Builder builder() {
		return new Schedule1.Schedule1BuilderImpl();
	}

	/*********************** Utility Methods  ***********************/
	@Override
	default RosettaMetaData<? extends Schedule1> metaData() {
		return metaData;
	}
	
	@Override
	@RuneAttribute("@type")
	default Class<? extends Schedule1> getType() {
		return Schedule1.class;
	}
	
	@Override
	default void process(RosettaPath path, Processor processor) {
		processor.processBasic(path.newSubPath("uadjstdFctvDt"), Date.class, getUadjstdFctvDt(), this);
		processor.processBasic(path.newSubPath("uadjstdEndDt"), Date.class, getUadjstdEndDt(), this);
		processRosetta(path.newSubPath("pric"), processor, SecuritiesTransactionPrice17Choice.class, getPric());
	}
	

	/*********************** Builder Interface  ***********************/
	interface Schedule1Builder extends Schedule1, RosettaModelObjectBuilder {
		SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder getOrCreatePric();
		@Override
		SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder getPric();
		Schedule1.Schedule1Builder setUadjstdFctvDt(Date uadjstdFctvDt);
		Schedule1.Schedule1Builder setUadjstdEndDt(Date uadjstdEndDt);
		Schedule1.Schedule1Builder setPric(SecuritiesTransactionPrice17Choice pric);

		@Override
		default void process(RosettaPath path, BuilderProcessor processor) {
			processor.processBasic(path.newSubPath("uadjstdFctvDt"), Date.class, getUadjstdFctvDt(), this);
			processor.processBasic(path.newSubPath("uadjstdEndDt"), Date.class, getUadjstdEndDt(), this);
			processRosetta(path.newSubPath("pric"), processor, SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder.class, getPric());
		}
		

		Schedule1.Schedule1Builder prune();
	}

	/*********************** Immutable Implementation of Schedule1  ***********************/
	class Schedule1Impl implements Schedule1 {
		private final Date uadjstdFctvDt;
		private final Date uadjstdEndDt;
		private final SecuritiesTransactionPrice17Choice pric;
		
		protected Schedule1Impl(Schedule1.Schedule1Builder builder) {
			this.uadjstdFctvDt = builder.getUadjstdFctvDt();
			this.uadjstdEndDt = builder.getUadjstdEndDt();
			this.pric = ofNullable(builder.getPric()).map(f->f.build()).orElse(null);
		}
		
		@Override
		@RosettaAttribute(value="uadjstdFctvDt", isRequired=true)
		@RuneAttribute(value="uadjstdFctvDt", isRequired=true)
		public Date getUadjstdFctvDt() {
			return uadjstdFctvDt;
		}
		
		@Override
		@RosettaAttribute("uadjstdEndDt")
		@RuneAttribute("uadjstdEndDt")
		public Date getUadjstdEndDt() {
			return uadjstdEndDt;
		}
		
		@Override
		@RosettaAttribute(value="pric", isRequired=true)
		@RuneAttribute(value="pric", isRequired=true)
		public SecuritiesTransactionPrice17Choice getPric() {
			return pric;
		}
		
		@Override
		public Schedule1 build() {
			return this;
		}
		
		@Override
		public Schedule1.Schedule1Builder toBuilder() {
			Schedule1.Schedule1Builder builder = builder();
			setBuilderFields(builder);
			return builder;
		}
		
		protected void setBuilderFields(Schedule1.Schedule1Builder builder) {
			ofNullable(getUadjstdFctvDt()).ifPresent(builder::setUadjstdFctvDt);
			ofNullable(getUadjstdEndDt()).ifPresent(builder::setUadjstdEndDt);
			ofNullable(getPric()).ifPresent(builder::setPric);
		}

		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			Schedule1 _that = getType().cast(o);
		
			if (!Objects.equals(uadjstdFctvDt, _that.getUadjstdFctvDt())) return false;
			if (!Objects.equals(uadjstdEndDt, _that.getUadjstdEndDt())) return false;
			if (!Objects.equals(pric, _that.getPric())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uadjstdFctvDt != null ? uadjstdFctvDt.hashCode() : 0);
			_result = 31 * _result + (uadjstdEndDt != null ? uadjstdEndDt.hashCode() : 0);
			_result = 31 * _result + (pric != null ? pric.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "Schedule1 {" +
				"uadjstdFctvDt=" + this.uadjstdFctvDt + ", " +
				"uadjstdEndDt=" + this.uadjstdEndDt + ", " +
				"pric=" + this.pric +
			'}';
		}
	}

	/*********************** Builder Implementation of Schedule1  ***********************/
	class Schedule1BuilderImpl implements Schedule1.Schedule1Builder {
	
		protected Date uadjstdFctvDt;
		protected Date uadjstdEndDt;
		protected SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder pric;
		
		@Override
		@RosettaAttribute(value="uadjstdFctvDt", isRequired=true)
		@RuneAttribute(value="uadjstdFctvDt", isRequired=true)
		public Date getUadjstdFctvDt() {
			return uadjstdFctvDt;
		}
		
		@Override
		@RosettaAttribute("uadjstdEndDt")
		@RuneAttribute("uadjstdEndDt")
		public Date getUadjstdEndDt() {
			return uadjstdEndDt;
		}
		
		@Override
		@RosettaAttribute(value="pric", isRequired=true)
		@RuneAttribute(value="pric", isRequired=true)
		public SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder getPric() {
			return pric;
		}
		
		@Override
		public SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder getOrCreatePric() {
			SecuritiesTransactionPrice17Choice.SecuritiesTransactionPrice17ChoiceBuilder result;
			if (pric!=null) {
				result = pric;
			}
			else {
				result = pric = SecuritiesTransactionPrice17Choice.builder();
			}
			
			return result;
		}
		
		@RosettaAttribute(value="uadjstdFctvDt", isRequired=true)
		@RuneAttribute(value="uadjstdFctvDt", isRequired=true)
		@Override
		public Schedule1.Schedule1Builder setUadjstdFctvDt(Date _uadjstdFctvDt) {
			this.uadjstdFctvDt = _uadjstdFctvDt == null ? null : _uadjstdFctvDt;
			return this;
		}
		
		@RosettaAttribute("uadjstdEndDt")
		@RuneAttribute("uadjstdEndDt")
		@Override
		public Schedule1.Schedule1Builder setUadjstdEndDt(Date _uadjstdEndDt) {
			this.uadjstdEndDt = _uadjstdEndDt == null ? null : _uadjstdEndDt;
			return this;
		}
		
		@RosettaAttribute(value="pric", isRequired=true)
		@RuneAttribute(value="pric", isRequired=true)
		@Override
		public Schedule1.Schedule1Builder setPric(SecuritiesTransactionPrice17Choice _pric) {
			this.pric = _pric == null ? null : _pric.toBuilder();
			return this;
		}
		
		@Override
		public Schedule1 build() {
			return new Schedule1.Schedule1Impl(this);
		}
		
		@Override
		public Schedule1.Schedule1Builder toBuilder() {
			return this;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public Schedule1.Schedule1Builder prune() {
			if (pric!=null && !pric.prune().hasData()) pric = null;
			return this;
		}
		
		@Override
		public boolean hasData() {
			if (getUadjstdFctvDt()!=null) return true;
			if (getUadjstdEndDt()!=null) return true;
			if (getPric()!=null && getPric().hasData()) return true;
			return false;
		}
	
		@SuppressWarnings("unchecked")
		@Override
		public Schedule1.Schedule1Builder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
			Schedule1.Schedule1Builder o = (Schedule1.Schedule1Builder) other;
			
			merger.mergeRosetta(getPric(), o.getPric(), this::setPric);
			
			merger.mergeBasic(getUadjstdFctvDt(), o.getUadjstdFctvDt(), this::setUadjstdFctvDt);
			merger.mergeBasic(getUadjstdEndDt(), o.getUadjstdEndDt(), this::setUadjstdEndDt);
			return this;
		}
	
		@Override
		public boolean equals(Object o) {
			if (this == o) return true;
			if (o == null || !(o instanceof RosettaModelObject) || !getType().equals(((RosettaModelObject)o).getType())) return false;
		
			Schedule1 _that = getType().cast(o);
		
			if (!Objects.equals(uadjstdFctvDt, _that.getUadjstdFctvDt())) return false;
			if (!Objects.equals(uadjstdEndDt, _that.getUadjstdEndDt())) return false;
			if (!Objects.equals(pric, _that.getPric())) return false;
			return true;
		}
		
		@Override
		public int hashCode() {
			int _result = 0;
			_result = 31 * _result + (uadjstdFctvDt != null ? uadjstdFctvDt.hashCode() : 0);
			_result = 31 * _result + (uadjstdEndDt != null ? uadjstdEndDt.hashCode() : 0);
			_result = 31 * _result + (pric != null ? pric.hashCode() : 0);
			return _result;
		}
		
		@Override
		public String toString() {
			return "Schedule1Builder {" +
				"uadjstdFctvDt=" + this.uadjstdFctvDt + ", " +
				"uadjstdEndDt=" + this.uadjstdEndDt + ", " +
				"pric=" + this.pric +
			'}';
		}
	}
}
