package iso20022.auth030.hkma.dtcc.validation;

import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import iso20022.auth030.hkma.dtcc.DateAndDateTime2Choice__1;
import iso20022.auth030.hkma.dtcc.DerivativeEvent6__3;
import iso20022.auth030.hkma.dtcc.EventIdentifier1Choice__1;
import java.util.List;

import static com.google.common.base.Strings.isNullOrEmpty;
import static com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe.checkCardinality;
import static com.rosetta.model.lib.validation.ValidationResult.failure;
import static com.rosetta.model.lib.validation.ValidationResult.success;
import static java.util.stream.Collectors.toList;

public class DerivativeEvent6__3Validator implements Validator<DerivativeEvent6__3> {

	private List<ComparisonResult> getComparisonResults(DerivativeEvent6__3 o) {
		return Lists.<ComparisonResult>newArrayList(
				checkCardinality("id", (EventIdentifier1Choice__1) o.getId() != null ? 1 : 0, 0, 1), 
				checkCardinality("tmStmp", (DateAndDateTime2Choice__1) o.getTmStmp() != null ? 1 : 0, 1, 1)
			);
	}

	@Override
	public List<ValidationResult<?>> getValidationResults(RosettaPath path, DerivativeEvent6__3 o) {
		return getComparisonResults(o)
			.stream()
			.map(res -> {
				if (!isNullOrEmpty(res.getError())) {
					return failure("DerivativeEvent6__3", ValidationResult.ValidationType.CARDINALITY, "DerivativeEvent6__3", path, "", res.getError());
				}
				return success("DerivativeEvent6__3", ValidationResult.ValidationType.CARDINALITY, "DerivativeEvent6__3", path, "");
			})
			.collect(toList());
	}

}
