/*
 * Decompiled with CFR 0.152.
 */
package com.regnosys.rosetta.interpreter;

import com.regnosys.rosetta.interpreter.RosettaBooleanValue;
import com.regnosys.rosetta.interpreter.RosettaDateTimeValue;
import com.regnosys.rosetta.interpreter.RosettaDateValue;
import com.regnosys.rosetta.interpreter.RosettaInterpreterTypeException;
import com.regnosys.rosetta.interpreter.RosettaNumberValue;
import com.regnosys.rosetta.interpreter.RosettaStringValue;
import com.regnosys.rosetta.interpreter.RosettaTimeValue;
import com.regnosys.rosetta.interpreter.RosettaValue;
import com.regnosys.rosetta.interpreter.RosettaZonedDateTimeValue;
import com.regnosys.rosetta.types.RAliasType;
import com.regnosys.rosetta.types.RChoiceType;
import com.regnosys.rosetta.types.RDataType;
import com.regnosys.rosetta.types.REnumType;
import com.regnosys.rosetta.types.RType;
import com.regnosys.rosetta.types.builtin.RBasicType;
import com.regnosys.rosetta.types.builtin.RBuiltinTypeService;
import com.regnosys.rosetta.types.builtin.RDateTimeType;
import com.regnosys.rosetta.types.builtin.RDateType;
import com.regnosys.rosetta.types.builtin.RNumberType;
import com.regnosys.rosetta.types.builtin.RStringType;
import com.regnosys.rosetta.types.builtin.RZonedDateTimeType;
import com.regnosys.rosetta.utils.RosettaTypeSwitch;
import com.rosetta.model.lib.RosettaNumber;
import jakarta.inject.Inject;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZonedDateTime;
import java.util.List;
import java.util.stream.Collectors;

public class RosettaValueFactory
extends RosettaTypeSwitch<RosettaValue, List<?>> {
    @Inject
    public RosettaValueFactory(RBuiltinTypeService builtins) {
        super(builtins);
    }

    private <T> List<T> castList(List<?> list, Class<T> clazz) {
        if (list.stream().anyMatch(i -> !clazz.isInstance(i))) {
            throw new RosettaInterpreterTypeException(String.valueOf(list) + " is not of type " + String.valueOf(clazz));
        }
        return list.stream().map(i -> clazz.cast(i)).collect(Collectors.toList());
    }

    public RosettaValue createOfType(RType type, List<?> items) {
        return (RosettaValue)this.doSwitch(type, items);
    }

    public RosettaValue createOfType(RType type, Object item) {
        return this.createOfType(type, List.of(item));
    }

    @Override
    protected RosettaValue caseDataType(RDataType type, List<?> context) {
        throw new UnsupportedOperationException("Data type is unsupported");
    }

    @Override
    protected RosettaValue caseChoiceType(RChoiceType type, List<?> context) {
        throw new UnsupportedOperationException("Choice type is unsupported");
    }

    @Override
    protected RosettaValue caseEnumType(REnumType type, List<?> context) {
        throw new UnsupportedOperationException("Enum type is unsupported");
    }

    @Override
    protected RosettaValue caseAliasType(RAliasType type, List<?> context) {
        return this.createOfType(type.getRefersTo(), context);
    }

    @Override
    protected RosettaValue caseNumberType(RNumberType type, List<?> context) {
        return new RosettaNumberValue(this.castList(context, RosettaNumber.class), type.getScale().map(s -> RosettaNumber.valueOf((BigDecimal)s)).orElse(RosettaNumber.ONE));
    }

    @Override
    protected RosettaValue caseStringType(RStringType type, List<?> context) {
        return new RosettaStringValue(this.castList(context, String.class));
    }

    @Override
    protected RosettaValue caseBooleanType(RBasicType type, List<?> context) {
        return new RosettaBooleanValue(this.castList(context, Boolean.class));
    }

    @Override
    protected RosettaValue caseTimeType(RBasicType type, List<?> context) {
        return new RosettaTimeValue(this.castList(context, LocalTime.class));
    }

    @Override
    protected RosettaValue caseNothingType(RBasicType type, List<?> context) {
        if (!context.isEmpty()) {
            throw new RosettaInterpreterTypeException("Cannot create a non-empty Rosetta value of type " + String.valueOf(type));
        }
        return RosettaValue.empty();
    }

    @Override
    protected RosettaValue caseAnyType(RBasicType type, List<?> context) {
        throw new UnsupportedOperationException("Cannot create a value of type " + String.valueOf(type));
    }

    @Override
    protected RosettaValue caseDateType(RDateType type, List<?> context) {
        return new RosettaDateValue(this.castList(context, LocalDate.class));
    }

    @Override
    protected RosettaValue caseDateTimeType(RDateTimeType type, List<?> context) {
        return new RosettaDateTimeValue(this.castList(context, LocalDateTime.class));
    }

    @Override
    protected RosettaValue caseZonedDateTimeType(RZonedDateTimeType type, List<?> context) {
        return new RosettaZonedDateTimeValue(this.castList(context, ZonedDateTime.class));
    }
}

