/*
 * Decompiled with CFR 0.152.
 */
package org.finos.rune.mapper.introspector;

import com.fasterxml.jackson.databind.introspect.AnnotatedMethod;
import com.rosetta.model.lib.annotations.RuneAttribute;

public class RuneBeanUtil {
    public static String getPropertyName(AnnotatedMethod method) {
        RuneAttribute attribute = (RuneAttribute)method.getAnnotation(RuneAttribute.class);
        if (attribute != null && !attribute.value().isEmpty()) {
            return attribute.value();
        }
        String methodName = method.getName();
        String rawPropertyName = RuneBeanUtil.getSubstringIfPrefixMatches(methodName, "get");
        if (rawPropertyName == null) {
            rawPropertyName = RuneBeanUtil.getSubstringIfPrefixMatches(methodName, "set");
        }
        if (rawPropertyName == null) {
            rawPropertyName = RuneBeanUtil.getSubstringIfPrefixMatches(methodName, "is");
        }
        if (rawPropertyName == null) {
            rawPropertyName = RuneBeanUtil.getSubstringIfPrefixMatches(methodName, "add");
        }
        return RuneBeanUtil.toLowerCamelCase(rawPropertyName);
    }

    public static String toLowerCamelCase(String string) {
        if (string == null) {
            return null;
        }
        if (string.isEmpty()) {
            return string;
        }
        if (string.length() > 1 && Character.isUpperCase(string.charAt(1)) && Character.isUpperCase(string.charAt(0))) {
            return string;
        }
        char[] chars = string.toCharArray();
        chars[0] = Character.toLowerCase(chars[0]);
        return new String(chars);
    }

    private static String getSubstringIfPrefixMatches(String wholeString, String prefix) {
        return wholeString.startsWith(prefix) ? wholeString.substring(prefix.length()) : null;
    }
}

