/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.ReferenceData;
import com.opengamma.strata.basics.date.BusinessDayAdjustment;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Map;
import java.util.NoSuchElementException;
import org.joda.beans.Bean;
import org.joda.beans.BeanBuilder;
import org.joda.beans.ImmutableBean;
import org.joda.beans.JodaBeanUtils;
import org.joda.beans.MetaBean;
import org.joda.beans.MetaProperty;
import org.joda.beans.gen.BeanDefinition;
import org.joda.beans.gen.PropertyDefinition;
import org.joda.beans.impl.direct.DirectMetaBean;
import org.joda.beans.impl.direct.DirectMetaProperty;
import org.joda.beans.impl.direct.DirectMetaPropertyMap;
import org.joda.beans.impl.direct.DirectPrivateBeanBuilder;

@BeanDefinition(builderScope="private")
public final class AdjustableDate
implements ImmutableBean,
Serializable {
    @PropertyDefinition(validate="notNull")
    private final LocalDate unadjusted;
    @PropertyDefinition(validate="notNull")
    private final BusinessDayAdjustment adjustment;
    private static final long serialVersionUID = 1L;

    public static AdjustableDate of(LocalDate date) {
        return new AdjustableDate(date, BusinessDayAdjustment.NONE);
    }

    public static AdjustableDate of(LocalDate unadjusted, BusinessDayAdjustment adjustment) {
        return new AdjustableDate(unadjusted, adjustment);
    }

    public LocalDate adjusted(ReferenceData refData) {
        return this.adjustment.adjust(this.unadjusted, refData);
    }

    public String toString() {
        if (this.adjustment.equals(BusinessDayAdjustment.NONE)) {
            return this.unadjusted.toString();
        }
        return new StringBuilder(64).append(this.unadjusted).append(" adjusted by ").append(this.adjustment).toString();
    }

    public static Meta meta() {
        return Meta.INSTANCE;
    }

    private AdjustableDate(LocalDate unadjusted, BusinessDayAdjustment adjustment) {
        JodaBeanUtils.notNull((Object)unadjusted, (String)"unadjusted");
        JodaBeanUtils.notNull((Object)adjustment, (String)"adjustment");
        this.unadjusted = unadjusted;
        this.adjustment = adjustment;
    }

    public Meta metaBean() {
        return Meta.INSTANCE;
    }

    public LocalDate getUnadjusted() {
        return this.unadjusted;
    }

    public BusinessDayAdjustment getAdjustment() {
        return this.adjustment;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj != null && obj.getClass() == this.getClass()) {
            AdjustableDate other = (AdjustableDate)obj;
            return JodaBeanUtils.equal((Object)this.unadjusted, (Object)other.unadjusted) && JodaBeanUtils.equal((Object)this.adjustment, (Object)other.adjustment);
        }
        return false;
    }

    public int hashCode() {
        int hash = this.getClass().hashCode();
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.unadjusted);
        hash = hash * 31 + JodaBeanUtils.hashCode((Object)this.adjustment);
        return hash;
    }

    static {
        MetaBean.register((MetaBean)Meta.INSTANCE);
    }

    private static final class Builder
    extends DirectPrivateBeanBuilder<AdjustableDate> {
        private LocalDate unadjusted;
        private BusinessDayAdjustment adjustment;

        private Builder() {
        }

        public Object get(String propertyName) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return this.unadjusted;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            throw new NoSuchElementException("Unknown property: " + propertyName);
        }

        public Builder set(String propertyName, Object newValue) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    this.unadjusted = (LocalDate)newValue;
                    break;
                }
                case 1977085293: {
                    this.adjustment = (BusinessDayAdjustment)newValue;
                    break;
                }
                default: {
                    throw new NoSuchElementException("Unknown property: " + propertyName);
                }
            }
            return this;
        }

        public AdjustableDate build() {
            return new AdjustableDate(this.unadjusted, this.adjustment);
        }

        public String toString() {
            StringBuilder buf = new StringBuilder(96);
            buf.append("AdjustableDate.Builder{");
            buf.append("unadjusted").append('=').append(JodaBeanUtils.toString((Object)this.unadjusted)).append(',').append(' ');
            buf.append("adjustment").append('=').append(JodaBeanUtils.toString((Object)this.adjustment));
            buf.append('}');
            return buf.toString();
        }
    }

    public static final class Meta
    extends DirectMetaBean {
        static final Meta INSTANCE = new Meta();
        private final MetaProperty<LocalDate> unadjusted = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"unadjusted", AdjustableDate.class, LocalDate.class);
        private final MetaProperty<BusinessDayAdjustment> adjustment = DirectMetaProperty.ofImmutable((MetaBean)this, (String)"adjustment", AdjustableDate.class, BusinessDayAdjustment.class);
        private final Map<String, MetaProperty<?>> metaPropertyMap$ = new DirectMetaPropertyMap((DirectMetaBean)this, null, new String[]{"unadjusted", "adjustment"});

        private Meta() {
        }

        protected MetaProperty<?> metaPropertyGet(String propertyName) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return this.unadjusted;
                }
                case 1977085293: {
                    return this.adjustment;
                }
            }
            return super.metaPropertyGet(propertyName);
        }

        public BeanBuilder<? extends AdjustableDate> builder() {
            return new Builder();
        }

        public Class<? extends AdjustableDate> beanType() {
            return AdjustableDate.class;
        }

        public Map<String, MetaProperty<?>> metaPropertyMap() {
            return this.metaPropertyMap$;
        }

        public MetaProperty<LocalDate> unadjusted() {
            return this.unadjusted;
        }

        public MetaProperty<BusinessDayAdjustment> adjustment() {
            return this.adjustment;
        }

        protected Object propertyGet(Bean bean, String propertyName, boolean quiet) {
            switch (propertyName.hashCode()) {
                case 482476551: {
                    return ((AdjustableDate)bean).getUnadjusted();
                }
                case 1977085293: {
                    return ((AdjustableDate)bean).getAdjustment();
                }
            }
            return super.propertyGet(bean, propertyName, quiet);
        }

        protected void propertySet(Bean bean, String propertyName, Object newValue, boolean quiet) {
            this.metaProperty(propertyName);
            if (quiet) {
                return;
            }
            throw new UnsupportedOperationException("Property cannot be written: " + propertyName);
        }
    }
}

