/*
 * Decompiled with CFR 0.152.
 */
package com.opengamma.strata.basics.date;

import com.opengamma.strata.basics.date.HolidayCalendar;
import com.opengamma.strata.basics.date.HolidayCalendarId;
import com.opengamma.strata.basics.date.HolidayCalendarIds;
import com.opengamma.strata.basics.date.ImmutableHolidayCalendar;
import java.time.DayOfWeek;
import java.time.LocalDate;
import java.time.MonthDay;
import java.time.temporal.TemporalAdjusters;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

final class GlobalHolidayCalendars {
    public static final HolidayCalendar GBLO = GlobalHolidayCalendars.generateLondon();
    public static final HolidayCalendar FRPA = GlobalHolidayCalendars.generateParis();
    public static final HolidayCalendar DEFR = GlobalHolidayCalendars.generateFrankfurt();
    public static final HolidayCalendar CHZU = GlobalHolidayCalendars.generateZurich();
    public static final HolidayCalendar EUTA = GlobalHolidayCalendars.generateEuropeanTarget();
    public static final HolidayCalendar USGS = GlobalHolidayCalendars.generateUsGovtSecurities();
    public static final HolidayCalendar USNY = GlobalHolidayCalendars.generateUsNewYork();
    public static final HolidayCalendar NYFD = GlobalHolidayCalendars.generateNewYorkFed();
    public static final HolidayCalendar NYSE = GlobalHolidayCalendars.generateNewYorkStockExchange();
    public static final HolidayCalendar JPTO = GlobalHolidayCalendars.generateTokyo();
    public static final HolidayCalendar AUSY = GlobalHolidayCalendars.generateSydney();
    public static final HolidayCalendar BRBD = GlobalHolidayCalendars.generateBrazil();
    public static final HolidayCalendar CAMO = GlobalHolidayCalendars.generateMontreal();
    public static final HolidayCalendar CATO = GlobalHolidayCalendars.generateToronto();
    public static final HolidayCalendar CZPR = GlobalHolidayCalendars.generatePrague();
    public static final HolidayCalendar DKCO = GlobalHolidayCalendars.generateCopenhagen();
    public static final HolidayCalendar HUBU = GlobalHolidayCalendars.generateBudapest();
    public static final HolidayCalendar MXMC = GlobalHolidayCalendars.generateMexicoCity();
    public static final HolidayCalendar NOOS = GlobalHolidayCalendars.generateOslo();
    public static final HolidayCalendar NZAU = GlobalHolidayCalendars.generateAuckland();
    public static final HolidayCalendar NZWE = GlobalHolidayCalendars.generateWellington();
    public static final HolidayCalendar NZBD = GlobalHolidayCalendars.generateNewZealand();
    public static final HolidayCalendar PLWA = GlobalHolidayCalendars.generateWarsaw();
    public static final HolidayCalendar SEST = GlobalHolidayCalendars.generateStockholm();
    public static final HolidayCalendar ZAJO = GlobalHolidayCalendars.generateJohannesburg();

    private GlobalHolidayCalendars() {
    }

    static ImmutableHolidayCalendar generateLondon() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            if (year >= 1974) {
                holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.first(year, 1)));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            if (year == 1995) {
                holidays.add(GlobalHolidayCalendars.date(1995, 5, 8));
            } else if (year >= 1978) {
                holidays.add(GlobalHolidayCalendars.first(year, 5).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)));
            }
            if (year == 2002) {
                holidays.add(GlobalHolidayCalendars.date(2002, 6, 3));
                holidays.add(GlobalHolidayCalendars.date(2002, 6, 4));
            } else if (year == 2012) {
                holidays.add(GlobalHolidayCalendars.date(2012, 6, 4));
                holidays.add(GlobalHolidayCalendars.date(2012, 6, 5));
            } else if (year == 1967 || year == 1970) {
                holidays.add(GlobalHolidayCalendars.first(year, 5).with(TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY)));
            } else if (year < 1971) {
                holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            } else {
                holidays.add(GlobalHolidayCalendars.first(year, 5).with(TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY)));
            }
            if (year < 1965) {
                holidays.add(GlobalHolidayCalendars.first(year, 8).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)));
            } else if (year < 1971) {
                holidays.add(GlobalHolidayCalendars.first(year, 8).with(TemporalAdjusters.lastInMonth(DayOfWeek.SATURDAY)).plusDays(2L));
            } else {
                holidays.add(GlobalHolidayCalendars.first(year, 8).with(TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY)));
            }
            holidays.add(GlobalHolidayCalendars.christmasBumpedSatSun(year));
            holidays.add(GlobalHolidayCalendars.boxingDayBumpedSatSun(year));
        }
        holidays.add(GlobalHolidayCalendars.date(2011, 4, 29));
        holidays.add(GlobalHolidayCalendars.date(1999, 12, 31));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.GBLO, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateParis() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 8));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            if (year <= 2004 || year >= 2008) {
                holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 7, 14));
            holidays.add(GlobalHolidayCalendars.date(year, 8, 15));
            holidays.add(GlobalHolidayCalendars.date(year, 11, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 11, 11));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
        }
        holidays.add(GlobalHolidayCalendars.date(1999, 12, 31));
        GlobalHolidayCalendars.applyBridging(holidays);
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.FRPA, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateFrankfurt() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(60L));
            if (year >= 2000) {
                holidays.add(GlobalHolidayCalendars.date(year, 10, 3));
            }
            if (year <= 1994) {
                holidays.add(GlobalHolidayCalendars.date(year, 12, 25).with(TemporalAdjusters.previous(DayOfWeek.SUNDAY)).minusWeeks(6L).minusDays(4L));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 31));
        }
        holidays.add(GlobalHolidayCalendars.date(2017, 10, 31));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.DEFR, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateZurich() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 1, 2));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            holidays.add(GlobalHolidayCalendars.date(year, 8, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
        }
        holidays.add(GlobalHolidayCalendars.date(1999, 12, 31));
        holidays.add(GlobalHolidayCalendars.date(2000, 1, 3));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.CHZU, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateEuropeanTarget() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1997; year <= 2099; ++year) {
            if (year >= 2000) {
                holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
                holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
                holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
                holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
                holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
                holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            } else {
                holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
                holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            }
            if (year != 1999 && year != 2001) continue;
            holidays.add(GlobalHolidayCalendars.date(year, 12, 31));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.EUTA, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    private static void usCommon(List<LocalDate> holidays, int year, boolean bumpBack, boolean columbusVeteran, int mlkStartYear) {
        holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 1, 1)));
        if (year >= mlkStartYear) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1).with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)));
        }
        if (year < 1971) {
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 2, 22)));
        } else {
            holidays.add(GlobalHolidayCalendars.date(year, 2, 1).with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)));
        }
        if (year < 1971) {
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 30)));
        } else {
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1).with(TemporalAdjusters.lastInMonth(DayOfWeek.MONDAY)));
        }
        holidays.add(GlobalHolidayCalendars.date(year, 9, 1).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)));
        if (columbusVeteran) {
            if (year < 1971) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 10, 12)));
            } else {
                holidays.add(GlobalHolidayCalendars.date(year, 10, 1).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            }
        }
        if (columbusVeteran) {
            if (year >= 1971 && year < 1978) {
                holidays.add(GlobalHolidayCalendars.date(year, 10, 1).with(TemporalAdjusters.dayOfWeekInMonth(4, DayOfWeek.MONDAY)));
            } else {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 11, 11)));
            }
        }
        holidays.add(GlobalHolidayCalendars.date(year, 11, 1).with(TemporalAdjusters.dayOfWeekInMonth(4, DayOfWeek.THURSDAY)));
        if (bumpBack) {
            holidays.add(GlobalHolidayCalendars.bumpToFriOrMon(GlobalHolidayCalendars.date(year, 7, 4)));
            holidays.add(GlobalHolidayCalendars.bumpToFriOrMon(GlobalHolidayCalendars.date(year, 12, 25)));
        } else {
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 7, 4)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 12, 25)));
        }
    }

    static ImmutableHolidayCalendar generateUsGovtSecurities() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.usCommon(holidays, year, true, true, 1986);
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            if (year != 2012) continue;
            holidays.add(GlobalHolidayCalendars.date(year, 10, 30));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.USGS, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateUsNewYork() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.usCommon(holidays, year, false, true, 1986);
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.USNY, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateNewYorkFed() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.usCommon(holidays, year, false, true, 1986);
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.NYFD, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateNewYorkStockExchange() {
        int i;
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.usCommon(holidays, year, true, false, 1998);
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
        }
        for (i = 1950; i <= 1953; ++i) {
            holidays.add(GlobalHolidayCalendars.date(i, 2, 12));
            holidays.add(GlobalHolidayCalendars.date(i, 10, 12));
            holidays.add(GlobalHolidayCalendars.date(i, 11, 11));
        }
        for (i = 1950; i <= 1968; ++i) {
            holidays.add(GlobalHolidayCalendars.date(i, 11, 1).with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY)).plusDays(1L));
        }
        holidays.add(GlobalHolidayCalendars.date(1972, 11, 7));
        holidays.add(GlobalHolidayCalendars.date(1976, 11, 2));
        holidays.add(GlobalHolidayCalendars.date(1980, 11, 4));
        holidays.add(GlobalHolidayCalendars.date(1955, 12, 24));
        holidays.add(GlobalHolidayCalendars.date(1956, 12, 24));
        holidays.add(GlobalHolidayCalendars.date(1958, 12, 26));
        holidays.add(GlobalHolidayCalendars.date(1961, 5, 29));
        holidays.add(GlobalHolidayCalendars.date(1963, 11, 25));
        holidays.add(GlobalHolidayCalendars.date(1965, 12, 24));
        holidays.add(GlobalHolidayCalendars.date(1968, 2, 12));
        holidays.add(GlobalHolidayCalendars.date(1968, 4, 9));
        holidays.add(GlobalHolidayCalendars.date(1968, 6, 12));
        holidays.add(GlobalHolidayCalendars.date(1968, 6, 19));
        holidays.add(GlobalHolidayCalendars.date(1968, 6, 26));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 3));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 5));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 10));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 17));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 24));
        holidays.add(GlobalHolidayCalendars.date(1968, 7, 31));
        holidays.add(GlobalHolidayCalendars.date(1968, 8, 7));
        holidays.add(GlobalHolidayCalendars.date(1968, 8, 13));
        holidays.add(GlobalHolidayCalendars.date(1968, 8, 21));
        holidays.add(GlobalHolidayCalendars.date(1968, 8, 28));
        holidays.add(GlobalHolidayCalendars.date(1968, 9, 4));
        holidays.add(GlobalHolidayCalendars.date(1968, 9, 11));
        holidays.add(GlobalHolidayCalendars.date(1968, 9, 18));
        holidays.add(GlobalHolidayCalendars.date(1968, 9, 25));
        holidays.add(GlobalHolidayCalendars.date(1968, 10, 2));
        holidays.add(GlobalHolidayCalendars.date(1968, 10, 9));
        holidays.add(GlobalHolidayCalendars.date(1968, 10, 16));
        holidays.add(GlobalHolidayCalendars.date(1968, 10, 23));
        holidays.add(GlobalHolidayCalendars.date(1968, 10, 30));
        holidays.add(GlobalHolidayCalendars.date(1968, 11, 6));
        holidays.add(GlobalHolidayCalendars.date(1968, 11, 13));
        holidays.add(GlobalHolidayCalendars.date(1968, 11, 20));
        holidays.add(GlobalHolidayCalendars.date(1968, 11, 27));
        holidays.add(GlobalHolidayCalendars.date(1968, 12, 4));
        holidays.add(GlobalHolidayCalendars.date(1968, 12, 11));
        holidays.add(GlobalHolidayCalendars.date(1968, 12, 18));
        holidays.add(GlobalHolidayCalendars.date(1968, 12, 25));
        holidays.add(GlobalHolidayCalendars.date(1968, 12, 31));
        holidays.add(GlobalHolidayCalendars.date(1969, 2, 10));
        holidays.add(GlobalHolidayCalendars.date(1969, 3, 31));
        holidays.add(GlobalHolidayCalendars.date(1969, 7, 21));
        holidays.add(GlobalHolidayCalendars.date(1972, 12, 28));
        holidays.add(GlobalHolidayCalendars.date(1973, 1, 25));
        holidays.add(GlobalHolidayCalendars.date(1977, 7, 14));
        holidays.add(GlobalHolidayCalendars.date(1985, 9, 27));
        holidays.add(GlobalHolidayCalendars.date(1994, 4, 27));
        holidays.add(GlobalHolidayCalendars.date(2001, 9, 11));
        holidays.add(GlobalHolidayCalendars.date(2001, 9, 12));
        holidays.add(GlobalHolidayCalendars.date(2001, 9, 13));
        holidays.add(GlobalHolidayCalendars.date(2001, 9, 14));
        holidays.add(GlobalHolidayCalendars.date(2004, 6, 11));
        holidays.add(GlobalHolidayCalendars.date(2007, 1, 2));
        holidays.add(GlobalHolidayCalendars.date(2012, 10, 30));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.NYSE, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateTokyo() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 1, 2));
            holidays.add(GlobalHolidayCalendars.date(year, 1, 3));
            if (year >= 2000) {
                holidays.add(GlobalHolidayCalendars.date(year, 1, 1).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            } else {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 1, 15)));
            }
            if (year >= 1967) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 2, 11)));
            }
            if (year == 2000 || year == 2001 || year == 2004 || year == 2005 || year == 2008 || year == 2009 || year == 2012 || year == 2013 || year == 2016 || year == 2017 || year == 2020 || year == 2021 || year == 2024 || year == 2025 || year == 2026 || year == 2028 || year == 2029 || year == 2030) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 3, 20)));
            } else {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 3, 21)));
            }
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 4, 29)));
            if (year >= 1985) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 3)));
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 4)));
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 5)));
                if (year >= 2007 && (GlobalHolidayCalendars.date(year, 5, 3).getDayOfWeek() == DayOfWeek.SUNDAY || GlobalHolidayCalendars.date(year, 5, 4).getDayOfWeek() == DayOfWeek.SUNDAY)) {
                    holidays.add(GlobalHolidayCalendars.date(year, 5, 6));
                }
            } else {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 3)));
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 5)));
            }
            if (year >= 2003) {
                holidays.add(GlobalHolidayCalendars.date(year, 7, 1).with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)));
            } else if (year >= 1996) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 7, 20)));
            }
            if (year >= 2016) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 8, 11)));
            }
            if (year >= 2003) {
                holidays.add(GlobalHolidayCalendars.date(year, 9, 1).with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)));
            } else if (year >= 1966) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 9, 15)));
            }
            if (year == 2012 || year == 2016 || year == 2020 || year == 2024 || year == 2028) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 9, 22)));
            } else {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 9, 23)));
            }
            GlobalHolidayCalendars.citizensDay(holidays, GlobalHolidayCalendars.date(year, 9, 20), GlobalHolidayCalendars.date(year, 9, 22));
            GlobalHolidayCalendars.citizensDay(holidays, GlobalHolidayCalendars.date(year, 9, 21), GlobalHolidayCalendars.date(year, 9, 23));
            if (year >= 2000) {
                holidays.add(GlobalHolidayCalendars.date(year, 10, 1).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            } else if (year >= 1966) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 10, 10)));
            }
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 11, 3)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 11, 23)));
            if (year >= 1990) {
                holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 12, 23)));
            }
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 12, 31)));
        }
        holidays.add(GlobalHolidayCalendars.date(1959, 4, 10));
        holidays.add(GlobalHolidayCalendars.date(1989, 2, 24));
        holidays.add(GlobalHolidayCalendars.date(1990, 11, 12));
        holidays.add(GlobalHolidayCalendars.date(1993, 6, 9));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarIds.JPTO, holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    private static void citizensDay(List<LocalDate> holidays, LocalDate date1, LocalDate date2) {
        if (holidays.contains(date1) && holidays.contains(date2) && (date1.getDayOfWeek() == DayOfWeek.MONDAY || date1.getDayOfWeek() == DayOfWeek.TUESDAY || date1.getDayOfWeek() == DayOfWeek.WEDNESDAY)) {
            holidays.add(date1.plusDays(1L));
        }
    }

    static ImmutableHolidayCalendar generateMontreal() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 1, 1)));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 25).with(TemporalAdjusters.previous(DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 6, 24)));
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 7, 1)));
            holidays.add(GlobalHolidayCalendars.first(year, 9).with(TemporalAdjusters.dayOfWeekInMonth(1, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 10).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.christmasBumpedSatSun(year));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("CAMO"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateToronto() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 1, 1)));
            if (year >= 2008) {
                holidays.add(GlobalHolidayCalendars.first(year, 2).with(TemporalAdjusters.dayOfWeekInMonth(3, DayOfWeek.MONDAY)));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 25).with(TemporalAdjusters.previous(DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 7, 1)));
            holidays.add(GlobalHolidayCalendars.first(year, 8).with(TemporalAdjusters.dayOfWeekInMonth(1, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 9).with(TemporalAdjusters.dayOfWeekInMonth(1, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 10).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 11, 11)));
            holidays.add(GlobalHolidayCalendars.christmasBumpedSatSun(year));
            holidays.add(GlobalHolidayCalendars.boxingDayBumpedSatSun(year));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("CATO"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateCopenhagen() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(3L));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(26L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(40L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            holidays.add(GlobalHolidayCalendars.date(year, 6, 5));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 31));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("DKCO"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateOslo() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(3L));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 17));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 31));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("NOOS"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateAuckland() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.newZealand(holidays, year);
            holidays.add(GlobalHolidayCalendars.date(year, 1, 29).minusDays(3L).with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY)));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("NZAU"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateWellington() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.newZealand(holidays, year);
            holidays.add(GlobalHolidayCalendars.date(year, 1, 22).minusDays(3L).with(TemporalAdjusters.nextOrSame(DayOfWeek.MONDAY)));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("NZWE"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateNewZealand() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.newZealand(holidays, year);
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("NZBD"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    private static void newZealand(List<LocalDate> holidays, int year) {
        LocalDate newYear = GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 1, 1));
        holidays.add(newYear);
        holidays.add(GlobalHolidayCalendars.bumpToMon(newYear.plusDays(1L)));
        if (year >= 2014) {
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 2, 6)));
        } else {
            holidays.add(GlobalHolidayCalendars.date(year, 2, 6));
        }
        holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
        holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
        if (year >= 2014) {
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 4, 25)));
        } else {
            holidays.add(GlobalHolidayCalendars.date(year, 4, 25));
        }
        holidays.add(GlobalHolidayCalendars.first(year, 6).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)));
        holidays.add(GlobalHolidayCalendars.first(year, 10).with(TemporalAdjusters.dayOfWeekInMonth(4, DayOfWeek.MONDAY)));
        holidays.add(GlobalHolidayCalendars.christmasBumpedSatSun(year));
        holidays.add(GlobalHolidayCalendars.boxingDayBumpedSatSun(year));
    }

    static ImmutableHolidayCalendar generateWarsaw() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            if (year < 1961 || year >= 2011) {
                holidays.add(GlobalHolidayCalendars.date(year, 1, 6));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            if (year >= 1990) {
                holidays.add(GlobalHolidayCalendars.date(year, 5, 3));
            }
            if (year < 1990) {
                holidays.add(GlobalHolidayCalendars.date(year, 7, 22));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(60L));
            if (year < 1961 || year >= 1989) {
                holidays.add(GlobalHolidayCalendars.date(year, 8, 15));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 11, 1));
            if (year >= 1990) {
                holidays.add(GlobalHolidayCalendars.date(year, 11, 11));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            LocalDate nyeve = GlobalHolidayCalendars.date(year, 12, 31);
            if (nyeve.getDayOfWeek() != DayOfWeek.MONDAY && nyeve.getDayOfWeek() != DayOfWeek.THURSDAY && nyeve.getDayOfWeek() != DayOfWeek.FRIDAY) continue;
            holidays.add(nyeve);
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("PLWA"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateStockholm() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 1, 6));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(39L));
            holidays.add(GlobalHolidayCalendars.date(year, 6, 19).with(TemporalAdjusters.nextOrSame(DayOfWeek.FRIDAY)));
            if (year > 2005) {
                holidays.add(GlobalHolidayCalendars.date(year, 6, 6));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 31));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("SEST"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateSydney() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 1, 1)));
            holidays.add(GlobalHolidayCalendars.bumpToMon(GlobalHolidayCalendars.date(year, 1, 26)));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 4, 25));
            holidays.add(GlobalHolidayCalendars.first(year, 6).with(TemporalAdjusters.dayOfWeekInMonth(2, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 8).with(TemporalAdjusters.dayOfWeekInMonth(1, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 10).with(TemporalAdjusters.dayOfWeekInMonth(1, DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.christmasBumpedSatSun(year));
            holidays.add(GlobalHolidayCalendars.boxingDayBumpedSatSun(year));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("AUSY"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateJohannesburg() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 1, 1)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 3, 21)));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 4, 27)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 5, 1)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 6, 16)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 8, 9)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 9, 24)));
            holidays.add(GlobalHolidayCalendars.bumpSunToMon(GlobalHolidayCalendars.date(year, 12, 16)));
            holidays.add(GlobalHolidayCalendars.christmasBumpedSun(year));
            holidays.add(GlobalHolidayCalendars.boxingDayBumpedSun(year));
        }
        holidays.add(GlobalHolidayCalendars.date(2016, 8, 3));
        holidays.add(GlobalHolidayCalendars.date(2014, 5, 7));
        holidays.add(GlobalHolidayCalendars.date(2011, 5, 18));
        holidays.add(GlobalHolidayCalendars.date(2009, 4, 22));
        holidays.add(GlobalHolidayCalendars.date(2008, 5, 2));
        holidays.add(GlobalHolidayCalendars.date(2006, 3, 1));
        holidays.add(GlobalHolidayCalendars.date(2004, 4, 14));
        holidays.add(GlobalHolidayCalendars.date(1999, 12, 31));
        holidays.add(GlobalHolidayCalendars.date(2000, 1, 1));
        holidays.add(GlobalHolidayCalendars.date(2000, 1, 2));
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("ZAJO"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateBudapest() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        HashSet<LocalDate> workDays = new HashSet<LocalDate>(500);
        for (int year = 1950; year <= 2099; ++year) {
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 1, 1), -1, 1, holidays, workDays);
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 3, 15), -2, 1, holidays, workDays);
            if (year >= 2017) {
                holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 5, 1), 0, 1, holidays, workDays);
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(50L));
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 8, 20), 0, -2, holidays, workDays);
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 10, 23), 0, -1, holidays, workDays);
            GlobalHolidayCalendars.addDateWithHungarianBridging(GlobalHolidayCalendars.date(year, 11, 1), -3, 1, holidays, workDays);
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
            if (GlobalHolidayCalendars.date(year, 12, 25).getDayOfWeek() == DayOfWeek.TUESDAY) {
                holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
                workDays.add(GlobalHolidayCalendars.date(year, 12, 15));
                continue;
            }
            if (GlobalHolidayCalendars.date(year, 12, 25).getDayOfWeek() == DayOfWeek.WEDNESDAY) {
                holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
                holidays.add(GlobalHolidayCalendars.date(year, 12, 27));
                workDays.add(GlobalHolidayCalendars.date(year, 12, 7));
                workDays.add(GlobalHolidayCalendars.date(year, 12, 21));
                continue;
            }
            if (GlobalHolidayCalendars.date(year, 12, 25).getDayOfWeek() == DayOfWeek.THURSDAY) {
                holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
                continue;
            }
            if (GlobalHolidayCalendars.date(year, 12, 25).getDayOfWeek() != DayOfWeek.FRIDAY) continue;
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            workDays.add(GlobalHolidayCalendars.date(year, 12, 12));
        }
        GlobalHolidayCalendars.addHungarianSaturdays(holidays, workDays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("HUBU"), holidays, DayOfWeek.SUNDAY, DayOfWeek.SUNDAY);
    }

    private static void addDateWithHungarianBridging(LocalDate date, int relativeWeeksTue, int relativeWeeksThu, List<LocalDate> holidays, Set<LocalDate> workDays) {
        DayOfWeek dow = date.getDayOfWeek();
        switch (dow) {
            case MONDAY: 
            case WEDNESDAY: 
            case FRIDAY: {
                holidays.add(date);
                return;
            }
            case TUESDAY: {
                holidays.add(date.minusDays(1L));
                holidays.add(date);
                workDays.add(date.plusDays(4L).plusWeeks(relativeWeeksTue));
                return;
            }
            case THURSDAY: {
                holidays.add(date.plusDays(1L));
                holidays.add(date);
                workDays.add(date.plusDays(2L).plusWeeks(relativeWeeksThu));
                return;
            }
            case SATURDAY: 
            case SUNDAY: {
                return;
            }
        }
    }

    private static void addHungarianSaturdays(List<LocalDate> holidays, Set<LocalDate> workDays) {
        GlobalHolidayCalendars.removeSatSun(holidays);
        LocalDate endDate = LocalDate.of(2099, 12, 31);
        LocalDate date = LocalDate.of(1950, 1, 7);
        while (date.isBefore(endDate)) {
            if (!workDays.contains(date)) {
                holidays.add(date);
            }
            date = date.plusDays(7L);
        }
    }

    static ImmutableHolidayCalendar generateMexicoCity() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.first(year, 2).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)));
            holidays.add(GlobalHolidayCalendars.first(year, 3).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)).plusWeeks(2L));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(3L));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 9, 16));
            holidays.add(GlobalHolidayCalendars.date(year, 11, 2));
            holidays.add(GlobalHolidayCalendars.first(year, 11).with(TemporalAdjusters.firstInMonth(DayOfWeek.MONDAY)).plusWeeks(2L));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 12));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("MXMC"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generateBrazil() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(48L));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(47L));
            holidays.add(GlobalHolidayCalendars.date(year, 4, 21));
            holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(60L));
            holidays.add(GlobalHolidayCalendars.date(year, 9, 7));
            if (year >= 1980) {
                holidays.add(GlobalHolidayCalendars.date(year, 10, 12));
            }
            holidays.add(GlobalHolidayCalendars.date(year, 11, 2));
            holidays.add(GlobalHolidayCalendars.date(year, 11, 15));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("BRBD"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    static ImmutableHolidayCalendar generatePrague() {
        ArrayList<LocalDate> holidays = new ArrayList<LocalDate>(2000);
        for (int year = 1950; year <= 2099; ++year) {
            holidays.add(GlobalHolidayCalendars.date(year, 1, 1));
            if (year > 2015) {
                holidays.add(GlobalHolidayCalendars.easter(year).minusDays(2L));
            }
            holidays.add(GlobalHolidayCalendars.easter(year).plusDays(1L));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 1));
            holidays.add(GlobalHolidayCalendars.date(year, 5, 8));
            holidays.add(GlobalHolidayCalendars.date(year, 7, 5));
            holidays.add(GlobalHolidayCalendars.date(year, 7, 6));
            holidays.add(GlobalHolidayCalendars.date(year, 9, 28));
            holidays.add(GlobalHolidayCalendars.date(year, 10, 28));
            holidays.add(GlobalHolidayCalendars.date(year, 11, 17));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 24));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 25));
            holidays.add(GlobalHolidayCalendars.date(year, 12, 26));
        }
        GlobalHolidayCalendars.removeSatSun(holidays);
        return ImmutableHolidayCalendar.of(HolidayCalendarId.of("CZPR"), holidays, DayOfWeek.SATURDAY, DayOfWeek.SUNDAY);
    }

    private static LocalDate date(int year, int month, int day) {
        return LocalDate.of(year, month, day);
    }

    private static LocalDate bumpToMon(LocalDate date) {
        if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
            return date.plusDays(2L);
        }
        if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return date.plusDays(1L);
        }
        return date;
    }

    private static LocalDate bumpSunToMon(LocalDate date) {
        if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return date.plusDays(1L);
        }
        return date;
    }

    private static LocalDate bumpToFriOrMon(LocalDate date) {
        if (date.getDayOfWeek() == DayOfWeek.SATURDAY) {
            return date.minusDays(1L);
        }
        if (date.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return date.plusDays(1L);
        }
        return date;
    }

    private static LocalDate christmasBumpedSatSun(int year) {
        LocalDate base = LocalDate.of(year, 12, 25);
        if (base.getDayOfWeek() == DayOfWeek.SATURDAY || base.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return LocalDate.of(year, 12, 27);
        }
        return base;
    }

    private static LocalDate christmasBumpedSun(int year) {
        LocalDate base = LocalDate.of(year, 12, 25);
        if (base.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return LocalDate.of(year, 12, 26);
        }
        return base;
    }

    private static LocalDate boxingDayBumpedSatSun(int year) {
        LocalDate base = LocalDate.of(year, 12, 26);
        if (base.getDayOfWeek() == DayOfWeek.SATURDAY || base.getDayOfWeek() == DayOfWeek.SUNDAY) {
            return LocalDate.of(year, 12, 28);
        }
        return base;
    }

    private static LocalDate boxingDayBumpedSun(int year) {
        LocalDate base = LocalDate.of(year, 12, 26);
        if (base.getDayOfWeek() == DayOfWeek.MONDAY) {
            return LocalDate.of(year, 12, 27);
        }
        return base;
    }

    private static LocalDate first(int year, int month) {
        return LocalDate.of(year, month, 1);
    }

    private static void removeSatSun(List<LocalDate> holidays) {
        holidays.removeIf(date -> date.getDayOfWeek() == DayOfWeek.SATURDAY || date.getDayOfWeek() == DayOfWeek.SUNDAY);
    }

    private static void applyBridging(List<LocalDate> holidays) {
        Set additional1 = holidays.stream().filter(date -> date.getDayOfWeek() == DayOfWeek.TUESDAY && !MonthDay.from(date).equals(MonthDay.of(1, 1))).map(date -> date.minusDays(1L)).collect(Collectors.toSet());
        Set additional2 = holidays.stream().filter(date -> date.getDayOfWeek() == DayOfWeek.THURSDAY && !MonthDay.from(date).equals(MonthDay.of(12, 26))).map(date -> date.plusDays(1L)).collect(Collectors.toSet());
        holidays.addAll(additional1);
        holidays.addAll(additional2);
    }

    static LocalDate easter(int year) {
        int a = year % 19;
        int b = year / 100;
        int c = year % 100;
        int d = b / 4;
        int e = b % 4;
        int f = (b + 8) / 25;
        int g = (b - f + 1) / 3;
        int h = (19 * a + b - d - g + 15) % 30;
        int i = c / 4;
        int k = c % 4;
        int l = (32 + 2 * e + 2 * i - h - k) % 7;
        int m = (a + 11 * h + 22 * l) / 451;
        int month = (h + l - 7 * m + 114) / 31;
        int day = (h + l - 7 * m + 114) % 31 + 1;
        return LocalDate.of(year, month, day);
    }
}

