/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.CollateralTaxonomy;
import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CollateralTaxonomyUkEligibleCollateralTaxonomy")
@ImplementedBy(value=Default.class)
public interface CollateralTaxonomyUkEligibleCollateralTaxonomy
extends Validator<CollateralTaxonomy> {
    public static final String NAME = "CollateralTaxonomyUkEligibleCollateralTaxonomy";
    public static final String DEFINITION = "if taxonomySource = TaxonomySourceEnum -> UK_EMIR_EligibleCollateralAssetClass then taxonomyValue -> uk_EMIR_EligibleCollateral exists";

    public static class NoOp
    implements CollateralTaxonomyUkEligibleCollateralTaxonomy {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CollateralTaxonomyUkEligibleCollateralTaxonomy {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CollateralTaxonomy collateralTaxonomy) {
            ComparisonResult result = this.executeDataRule(collateralTaxonomy);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CollateralTaxonomyUkEligibleCollateralTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyUkEligibleCollateralTaxonomy.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CollateralTaxonomyUkEligibleCollateralTaxonomy.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CollateralTaxonomy", (RosettaPath)path, (String)CollateralTaxonomyUkEligibleCollateralTaxonomy.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CollateralTaxonomy collateralTaxonomy) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomySource", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomySource()), (Mapper)MapperS.of((Object)((Object)TaxonomySourceEnum.UK_EMIR_ELIGIBLE_COLLATERAL_ASSET_CLASS)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)collateralTaxonomy).map("getTaxonomyValue", _collateralTaxonomy -> _collateralTaxonomy.getTaxonomyValue()).mapC("getUk_EMIR_EligibleCollateral", collateralTaxonomyValue -> collateralTaxonomyValue.getUk_EMIR_EligibleCollateral()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

