/*
 * Decompiled with CFR 0.152.
 */
package cdm.base.staticdata.asset.common.validation.datarule;

import cdm.base.staticdata.asset.common.ProductTaxonomy;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ProductTaxonomyTaxonomySource")
@ImplementedBy(value=Default.class)
public interface ProductTaxonomyTaxonomySource
extends Validator<ProductTaxonomy> {
    public static final String NAME = "ProductTaxonomyTaxonomySource";
    public static final String DEFINITION = "if source exists then (value exists or productQualifier exists)";

    public static class NoOp
    implements ProductTaxonomyTaxonomySource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductTaxonomy productTaxonomy) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ProductTaxonomyTaxonomySource {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ProductTaxonomy productTaxonomy) {
            ComparisonResult result = this.executeDataRule(productTaxonomy);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ProductTaxonomyTaxonomySource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductTaxonomy", (RosettaPath)path, (String)ProductTaxonomyTaxonomySource.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ProductTaxonomyTaxonomySource.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ProductTaxonomy", (RosettaPath)path, (String)ProductTaxonomyTaxonomySource.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ProductTaxonomy productTaxonomy) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getSource", _productTaxonomy -> _productTaxonomy.getSource())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getValue", _productTaxonomy -> _productTaxonomy.getValue())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)productTaxonomy).map("getProductQualifier", _productTaxonomy -> _productTaxonomy.getProductQualifier())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

