/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.base.staticdata.party.Party;
import cdm.base.staticdata.party.PartyRole;
import cdm.event.common.AffirmationStatusEnum;
import cdm.event.common.Lineage;
import cdm.event.common.meta.AffirmationMeta;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.util.ListEquals;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="Affirmation", builder=AffirmationBuilderImpl.class, version="5.31.0")
@RuneDataType(value="Affirmation", model="cdm", builder=AffirmationBuilderImpl.class, version="5.31.0")
public interface Affirmation
extends RosettaModelObject {
    public static final AffirmationMeta metaData = new AffirmationMeta();

    public List<? extends Identifier> getIdentifier();

    public List<? extends Party> getParty();

    public List<? extends PartyRole> getPartyRole();

    public Lineage getLineage();

    public AffirmationStatusEnum getStatus();

    public Affirmation build();

    public AffirmationBuilder toBuilder();

    public static AffirmationBuilder builder() {
        return new AffirmationBuilderImpl();
    }

    default public RosettaMetaData<? extends Affirmation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends Affirmation> getType() {
        return Affirmation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("identifier"), processor, Identifier.class, this.getIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("party"), processor, Party.class, this.getParty(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.class, this.getPartyRole(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lineage"), processor, Lineage.class, this.getLineage(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("status"), AffirmationStatusEnum.class, (Object)this.getStatus(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class AffirmationBuilderImpl
    implements AffirmationBuilder {
        protected List<Identifier.IdentifierBuilder> identifier = new ArrayList<Identifier.IdentifierBuilder>();
        protected List<Party.PartyBuilder> party = new ArrayList<Party.PartyBuilder>();
        protected List<PartyRole.PartyRoleBuilder> partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
        protected Lineage.LineageBuilder lineage;
        protected AffirmationStatusEnum status;

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public List<? extends Identifier.IdentifierBuilder> getIdentifier() {
            return this.identifier;
        }

        @Override
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int index) {
            if (this.identifier == null) {
                this.identifier = new ArrayList<Identifier.IdentifierBuilder>();
            }
            return (Identifier.IdentifierBuilder)this.getIndex(this.identifier, index, () -> {
                Identifier.IdentifierBuilder newIdentifier = Identifier.builder();
                return newIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party.PartyBuilder> getParty() {
            return this.party;
        }

        @Override
        public Party.PartyBuilder getOrCreateParty(int index) {
            if (this.party == null) {
                this.party = new ArrayList<Party.PartyBuilder>();
            }
            return (Party.PartyBuilder)this.getIndex(this.party, index, () -> {
                Party.PartyBuilder newParty = Party.builder();
                return newParty;
            });
        }

        @Override
        @RosettaAttribute(value="partyRole", isRequired=true)
        @RuneAttribute(value="partyRole", isRequired=true)
        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole() {
            return this.partyRole;
        }

        @Override
        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int index) {
            if (this.partyRole == null) {
                this.partyRole = new ArrayList<PartyRole.PartyRoleBuilder>();
            }
            return (PartyRole.PartyRoleBuilder)this.getIndex(this.partyRole, index, () -> {
                PartyRole.PartyRoleBuilder newPartyRole = PartyRole.builder();
                return newPartyRole;
            });
        }

        @Override
        @RosettaAttribute(value="lineage")
        @RuneAttribute(value="lineage")
        public Lineage.LineageBuilder getLineage() {
            return this.lineage;
        }

        @Override
        public Lineage.LineageBuilder getOrCreateLineage() {
            Lineage.LineageBuilder result = this.lineage != null ? this.lineage : (this.lineage = Lineage.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public AffirmationStatusEnum getStatus() {
            return this.status;
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public AffirmationBuilder addIdentifier(Identifier _identifier) {
            if (_identifier != null) {
                this.identifier.add(_identifier.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addIdentifier(Identifier _identifier, int idx) {
            this.getIndex(this.identifier, idx, () -> _identifier.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addIdentifier(List<? extends Identifier> identifiers) {
            if (identifiers != null) {
                for (Identifier identifier : identifiers) {
                    this.identifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="identifier")
        public AffirmationBuilder setIdentifier(List<? extends Identifier> identifiers) {
            this.identifier = identifiers == null ? new ArrayList<Identifier.IdentifierBuilder>() : (List)identifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public AffirmationBuilder addParty(Party _party) {
            if (_party != null) {
                this.party.add(_party.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addParty(Party _party, int idx) {
            this.getIndex(this.party, idx, () -> _party.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addParty(List<? extends Party> partys) {
            if (partys != null) {
                for (Party party : partys) {
                    this.party.add(party.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="party")
        public AffirmationBuilder setParty(List<? extends Party> partys) {
            this.party = partys == null ? new ArrayList<Party.PartyBuilder>() : (List)partys.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="partyRole", isRequired=true)
        @RuneAttribute(value="partyRole", isRequired=true)
        public AffirmationBuilder addPartyRole(PartyRole _partyRole) {
            if (_partyRole != null) {
                this.partyRole.add(_partyRole.toBuilder());
            }
            return this;
        }

        @Override
        public AffirmationBuilder addPartyRole(PartyRole _partyRole, int idx) {
            this.getIndex(this.partyRole, idx, () -> _partyRole.toBuilder());
            return this;
        }

        @Override
        public AffirmationBuilder addPartyRole(List<? extends PartyRole> partyRoles) {
            if (partyRoles != null) {
                for (PartyRole partyRole : partyRoles) {
                    this.partyRole.add(partyRole.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="partyRole")
        public AffirmationBuilder setPartyRole(List<? extends PartyRole> partyRoles) {
            this.partyRole = partyRoles == null ? new ArrayList<PartyRole.PartyRoleBuilder>() : (List)partyRoles.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="lineage")
        @RuneAttribute(value="lineage")
        public AffirmationBuilder setLineage(Lineage _lineage) {
            this.lineage = _lineage == null ? null : _lineage.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public AffirmationBuilder setStatus(AffirmationStatusEnum _status) {
            this.status = _status == null ? null : _status;
            return this;
        }

        @Override
        public Affirmation build() {
            return new AffirmationImpl(this);
        }

        @Override
        public AffirmationBuilder toBuilder() {
            return this;
        }

        @Override
        public AffirmationBuilder prune() {
            this.identifier = this.identifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.party = this.party.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            this.partyRole = this.partyRole.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lineage != null && !this.lineage.prune().hasData()) {
                this.lineage = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getIdentifier() != null && this.getIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getParty() != null && this.getParty().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getPartyRole() != null && this.getPartyRole().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getLineage() != null && this.getLineage().hasData()) {
                return true;
            }
            return this.getStatus() != null;
        }

        public AffirmationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            AffirmationBuilder o = (AffirmationBuilder)other;
            merger.mergeRosetta(this.getIdentifier(), o.getIdentifier(), this::getOrCreateIdentifier);
            merger.mergeRosetta(this.getParty(), o.getParty(), this::getOrCreateParty);
            merger.mergeRosetta(this.getPartyRole(), o.getPartyRole(), this::getOrCreatePartyRole);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLineage(), (RosettaModelObjectBuilder)o.getLineage(), this::setLineage);
            merger.mergeBasic((Object)this.getStatus(), (Object)o.getStatus(), this::setStatus, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Affirmation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            return Objects.equals((Object)this.status, (Object)_that.getStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "AffirmationBuilder {identifier=" + this.identifier + ", party=" + this.party + ", partyRole=" + this.partyRole + ", lineage=" + this.lineage + ", status=" + (Object)((Object)this.status) + '}';
        }
    }

    public static interface AffirmationBuilder
    extends Affirmation,
    RosettaModelObjectBuilder {
        public Identifier.IdentifierBuilder getOrCreateIdentifier(int var1);

        public List<? extends Identifier.IdentifierBuilder> getIdentifier();

        public Party.PartyBuilder getOrCreateParty(int var1);

        public List<? extends Party.PartyBuilder> getParty();

        public PartyRole.PartyRoleBuilder getOrCreatePartyRole(int var1);

        public List<? extends PartyRole.PartyRoleBuilder> getPartyRole();

        public Lineage.LineageBuilder getOrCreateLineage();

        @Override
        public Lineage.LineageBuilder getLineage();

        public AffirmationBuilder addIdentifier(Identifier var1);

        public AffirmationBuilder addIdentifier(Identifier var1, int var2);

        public AffirmationBuilder addIdentifier(List<? extends Identifier> var1);

        public AffirmationBuilder setIdentifier(List<? extends Identifier> var1);

        public AffirmationBuilder addParty(Party var1);

        public AffirmationBuilder addParty(Party var1, int var2);

        public AffirmationBuilder addParty(List<? extends Party> var1);

        public AffirmationBuilder setParty(List<? extends Party> var1);

        public AffirmationBuilder addPartyRole(PartyRole var1);

        public AffirmationBuilder addPartyRole(PartyRole var1, int var2);

        public AffirmationBuilder addPartyRole(List<? extends PartyRole> var1);

        public AffirmationBuilder setPartyRole(List<? extends PartyRole> var1);

        public AffirmationBuilder setLineage(Lineage var1);

        public AffirmationBuilder setStatus(AffirmationStatusEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("identifier"), processor, Identifier.IdentifierBuilder.class, this.getIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("party"), processor, Party.PartyBuilder.class, this.getParty(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("partyRole"), processor, PartyRole.PartyRoleBuilder.class, this.getPartyRole(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lineage"), processor, Lineage.LineageBuilder.class, this.getLineage(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("status"), AffirmationStatusEnum.class, (Object)this.getStatus(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public AffirmationBuilder prune();
    }

    public static class AffirmationImpl
    implements Affirmation {
        private final List<? extends Identifier> identifier;
        private final List<? extends Party> party;
        private final List<? extends PartyRole> partyRole;
        private final Lineage lineage;
        private final AffirmationStatusEnum status;

        protected AffirmationImpl(AffirmationBuilder builder) {
            this.identifier = Optional.ofNullable(builder.getIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.party = Optional.ofNullable(builder.getParty()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.partyRole = Optional.ofNullable(builder.getPartyRole()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.lineage = Optional.ofNullable(builder.getLineage()).map(f -> f.build()).orElse(null);
            this.status = builder.getStatus();
        }

        @Override
        @RosettaAttribute(value="identifier", isRequired=true)
        @RuneAttribute(value="identifier", isRequired=true)
        public List<? extends Identifier> getIdentifier() {
            return this.identifier;
        }

        @Override
        @RosettaAttribute(value="party", isRequired=true)
        @RuneAttribute(value="party", isRequired=true)
        public List<? extends Party> getParty() {
            return this.party;
        }

        @Override
        @RosettaAttribute(value="partyRole", isRequired=true)
        @RuneAttribute(value="partyRole", isRequired=true)
        public List<? extends PartyRole> getPartyRole() {
            return this.partyRole;
        }

        @Override
        @RosettaAttribute(value="lineage")
        @RuneAttribute(value="lineage")
        public Lineage getLineage() {
            return this.lineage;
        }

        @Override
        @RosettaAttribute(value="status", isRequired=true)
        @RuneAttribute(value="status", isRequired=true)
        public AffirmationStatusEnum getStatus() {
            return this.status;
        }

        @Override
        public Affirmation build() {
            return this;
        }

        @Override
        public AffirmationBuilder toBuilder() {
            AffirmationBuilder builder = Affirmation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(AffirmationBuilder builder) {
            Optional.ofNullable(this.getIdentifier()).ifPresent(builder::setIdentifier);
            Optional.ofNullable(this.getParty()).ifPresent(builder::setParty);
            Optional.ofNullable(this.getPartyRole()).ifPresent(builder::setPartyRole);
            Optional.ofNullable(this.getLineage()).ifPresent(builder::setLineage);
            Optional.ofNullable(this.getStatus()).ifPresent(builder::setStatus);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            Affirmation _that = this.getType().cast(o);
            if (!ListEquals.listEquals(this.identifier, _that.getIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.party, _that.getParty())) {
                return false;
            }
            if (!ListEquals.listEquals(this.partyRole, _that.getPartyRole())) {
                return false;
            }
            if (!Objects.equals(this.lineage, _that.getLineage())) {
                return false;
            }
            return Objects.equals((Object)this.status, (Object)_that.getStatus());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.identifier != null ? this.identifier.hashCode() : 0);
            _result = 31 * _result + (this.party != null ? this.party.hashCode() : 0);
            _result = 31 * _result + (this.partyRole != null ? this.partyRole.hashCode() : 0);
            _result = 31 * _result + (this.lineage != null ? this.lineage.hashCode() : 0);
            _result = 31 * _result + (this.status != null ? ((Object)((Object)this.status)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "Affirmation {identifier=" + this.identifier + ", party=" + this.party + ", partyRole=" + this.partyRole + ", lineage=" + this.lineage + ", status=" + (Object)((Object)this.status) + '}';
        }
    }
}

