/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.functions;

import cdm.event.common.Transfer;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=FilterCashTransfersDefault.class)
public abstract class FilterCashTransfers
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public List<? extends Transfer> evaluate(List<? extends Transfer> transfers) {
        List cashTransfers;
        List<Transfer.TransferBuilder> cashTransfersBuilder = this.doEvaluate(transfers);
        if (cashTransfersBuilder == null) {
            cashTransfers = null;
        } else {
            cashTransfers = cashTransfersBuilder.stream().map(Transfer::build).collect(Collectors.toList());
            this.objectValidator.validate(Transfer.class, cashTransfers);
        }
        return cashTransfers;
    }

    protected abstract List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> var1);

    public static class FilterCashTransfersDefault
    extends FilterCashTransfers {
        @Override
        protected List<Transfer.TransferBuilder> doEvaluate(List<? extends Transfer> transfers) {
            if (transfers == null) {
                transfers = Collections.emptyList();
            }
            ArrayList<Transfer.TransferBuilder> cashTransfers = new ArrayList<Transfer.TransferBuilder>();
            return this.assignOutput(cashTransfers, transfers);
        }

        protected List<Transfer.TransferBuilder> assignOutput(List<Transfer.TransferBuilder> cashTransfers, List<? extends Transfer> transfers) {
            cashTransfers.addAll(this.toBuilder(MapperC.of(transfers).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.exists((Mapper)item.map("getQuantity", transfer -> transfer.getQuantity()).map("getUnit", nonNegativeQuantity -> nonNegativeQuantity.getUnit()).map("getCurrency", unitType -> unitType.getCurrency())).get()).getMulti()));
            return Optional.ofNullable(cashTransfers).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

