/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.common.validation.datarule;

import cdm.base.staticdata.party.AncillaryRoleEnum;
import cdm.event.common.Trade;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="TradeDisruptionEventsDeterminingParty")
@ImplementedBy(value=Default.class)
public interface TradeDisruptionEventsDeterminingParty
extends Validator<Trade> {
    public static final String NAME = "TradeDisruptionEventsDeterminingParty";
    public static final String DEFINITION = "if contractDetails -> documentation -> agreementTerms -> agreement -> transactionAdditionalTerms -> equityAdditionalTerms -> extraordinaryEvents -> additionalDisruptionEvents -> determiningParty exists then tradableProduct -> ancillaryParty -> role contains AncillaryRoleEnum -> DisruptionEventsDeterminingParty and if tradableProduct -> ancillaryParty -> role contains AncillaryRoleEnum -> DisruptionEventsDeterminingParty then contractDetails -> documentation -> agreementTerms -> agreement -> transactionAdditionalTerms -> equityAdditionalTerms -> extraordinaryEvents -> additionalDisruptionEvents -> determiningParty exists";

    public static class NoOp
    implements TradeDisruptionEventsDeterminingParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements TradeDisruptionEventsDeterminingParty {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Trade trade) {
            ComparisonResult result = this.executeDataRule(trade);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)TradeDisruptionEventsDeterminingParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDisruptionEventsDeterminingParty.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)TradeDisruptionEventsDeterminingParty.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Trade", (RosettaPath)path, (String)TradeDisruptionEventsDeterminingParty.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Trade trade) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getAgreementTerms", legalAgreement -> legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getTransactionAdditionalTerms", agreement -> agreement.getTransactionAdditionalTerms()).map("getEquityAdditionalTerms", transactionAdditionalTerms -> transactionAdditionalTerms.getEquityAdditionalTerms()).map("getExtraordinaryEvents", equityAdditionalTerms -> equityAdditionalTerms.getExtraordinaryEvents()).map("getAdditionalDisruptionEvents", extraordinaryEvents -> extraordinaryEvents.getAdditionalDisruptionEvents()).map("getDeterminingParty", additionalDisruptionEvents -> additionalDisruptionEvents.getDeterminingParty())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ComparisonResult ifThenElseResult = ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getAncillaryParty", tradableProduct -> tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.DISRUPTION_EVENTS_DETERMINING_PARTY))).getOrDefault(Boolean.valueOf(false)) != false ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)trade).map("getContractDetails", _trade -> _trade.getContractDetails()).mapC("getDocumentation", contractDetails -> contractDetails.getDocumentation()).map("getAgreementTerms", legalAgreement -> legalAgreement.getAgreementTerms()).map("getAgreement", agreementTerms -> agreementTerms.getAgreement()).map("getTransactionAdditionalTerms", agreement -> agreement.getTransactionAdditionalTerms()).map("getEquityAdditionalTerms", transactionAdditionalTerms -> transactionAdditionalTerms.getEquityAdditionalTerms()).map("getExtraordinaryEvents", equityAdditionalTerms -> equityAdditionalTerms.getExtraordinaryEvents()).map("getAdditionalDisruptionEvents", extraordinaryEvents -> extraordinaryEvents.getAdditionalDisruptionEvents()).map("getDeterminingParty", additionalDisruptionEvents -> additionalDisruptionEvents.getDeterminingParty())) : ComparisonResult.ofEmpty();
                    return ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getAncillaryParty", tradableProduct -> tradableProduct.getAncillaryParty()).map("getRole", ancillaryParty -> ancillaryParty.getRole()), (Mapper)MapperS.of((Object)((Object)AncillaryRoleEnum.DISRUPTION_EVENTS_DETERMINING_PARTY))).andNullSafe(ifThenElseResult);
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

