/*
 * Decompiled with CFR 0.152.
 */
package cdm.event.position.validation.datarule;

import cdm.event.position.PortfolioState;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PortfolioStateInitialisation")
@ImplementedBy(value=Default.class)
public interface PortfolioStateInitialisation
extends Validator<PortfolioState> {
    public static final String NAME = "PortfolioStateInitialisation";
    public static final String DEFINITION = "if lineage -> portfolioStateReference is absent then positions is absent and lineage -> eventReference is absent";

    public static class NoOp
    implements PortfolioStateInitialisation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PortfolioState portfolioState) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PortfolioStateInitialisation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, PortfolioState portfolioState) {
            ComparisonResult result = this.executeDataRule(portfolioState);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PortfolioStateInitialisation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateInitialisation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PortfolioStateInitialisation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"PortfolioState", (RosettaPath)path, (String)PortfolioStateInitialisation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(PortfolioState portfolioState) {
            try {
                if (ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)portfolioState).map("getLineage", _portfolioState -> _portfolioState.getLineage()).mapC("getPortfolioStateReference", lineage -> lineage.getPortfolioStateReference())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)portfolioState).mapC("getPositions", _portfolioState -> _portfolioState.getPositions())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)portfolioState).map("getLineage", _portfolioState -> _portfolioState.getLineage()).mapC("getEventReference", lineage -> lineage.getEventReference())));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

