/*
 * Decompiled with CFR 0.152.
 */
package cdm.legaldocumentation.common.validation.datarule;

import cdm.legaldocumentation.common.AgreementName;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="AgreementNameMasterConfirmation")
@ImplementedBy(value=Default.class)
public interface AgreementNameMasterConfirmation
extends Validator<AgreementName> {
    public static final String NAME = "AgreementNameMasterConfirmation";
    public static final String DEFINITION = "if masterConfirmationAnnexType exists then masterConfirmationType exists";

    public static class NoOp
    implements AgreementNameMasterConfirmation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AgreementName agreementName) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements AgreementNameMasterConfirmation {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, AgreementName agreementName) {
            ComparisonResult result = this.executeDataRule(agreementName);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)AgreementNameMasterConfirmation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AgreementName", (RosettaPath)path, (String)AgreementNameMasterConfirmation.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)AgreementNameMasterConfirmation.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"AgreementName", (RosettaPath)path, (String)AgreementNameMasterConfirmation.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(AgreementName agreementName) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)agreementName).map("getMasterConfirmationAnnexType", _agreementName -> _agreementName.getMasterConfirmationAnnexType())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)agreementName).map("getMasterConfirmationType", _agreementName -> _agreementName.getMasterConfirmationType()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

