/*
 * Decompiled with CFR 0.152.
 */
package cdm.observable.asset.calculatedrate.functions;

import cdm.base.math.ArithmeticOperationEnum;
import cdm.base.math.functions.VectorScalarOperation;
import cdm.observable.asset.calculatedrate.FloatingRateCalculationParameters;
import cdm.observable.asset.calculatedrate.ObservationParameters;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.inject.Inject;

@ImplementedBy(value=ProcessObservationsDefault.class)
public abstract class ProcessObservations
implements RosettaFunction {
    @Inject
    protected VectorScalarOperation vectorScalarOperation;

    public List<BigDecimal> evaluate(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
        List<BigDecimal> processedObservations = this.doEvaluate(calculationParameters, rawObservations);
        return processedObservations;
    }

    protected abstract List<BigDecimal> doEvaluate(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract MapperS<? extends ObservationParameters> params(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract MapperS<BigDecimal> cap(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract MapperS<BigDecimal> floor(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract MapperC<BigDecimal> cappedObservations(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    protected abstract MapperC<BigDecimal> flooredObservations(FloatingRateCalculationParameters var1, List<BigDecimal> var2);

    public static class ProcessObservationsDefault
    extends ProcessObservations {
        @Override
        protected List<BigDecimal> doEvaluate(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            if (rawObservations == null) {
                rawObservations = Collections.emptyList();
            }
            ArrayList<BigDecimal> processedObservations = new ArrayList<BigDecimal>();
            return this.assignOutput(processedObservations, calculationParameters, rawObservations);
        }

        protected List<BigDecimal> assignOutput(List<BigDecimal> processedObservations, FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            processedObservations.addAll(this.flooredObservations(calculationParameters, rawObservations).getMulti());
            return processedObservations;
        }

        @Override
        protected MapperS<? extends ObservationParameters> params(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            return MapperS.of((Object)calculationParameters).map("getObservationParameters", floatingRateCalculationParameters -> floatingRateCalculationParameters.getObservationParameters());
        }

        @Override
        protected MapperS<BigDecimal> cap(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            if (ExpressionOperatorsNullSafe.exists(this.params(calculationParameters, rawObservations)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.params(calculationParameters, rawObservations).map("getObservationCapRate", observationParameters -> observationParameters.getObservationCapRate());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperS<BigDecimal> floor(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            if (ExpressionOperatorsNullSafe.exists(this.params(calculationParameters, rawObservations)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return this.params(calculationParameters, rawObservations).map("getObservationFloorRate", observationParameters -> observationParameters.getObservationFloorRate());
            }
            return MapperS.ofNull();
        }

        @Override
        protected MapperC<BigDecimal> cappedObservations(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            if (ExpressionOperatorsNullSafe.exists(this.cap(calculationParameters, rawObservations)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperC.of(this.vectorScalarOperation.evaluate(ArithmeticOperationEnum.MIN, rawObservations, (BigDecimal)this.cap(calculationParameters, rawObservations).get()));
            }
            return MapperC.of(rawObservations);
        }

        @Override
        protected MapperC<BigDecimal> flooredObservations(FloatingRateCalculationParameters calculationParameters, List<BigDecimal> rawObservations) {
            if (ExpressionOperatorsNullSafe.exists(this.floor(calculationParameters, rawObservations)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                return MapperC.of(this.vectorScalarOperation.evaluate(ArithmeticOperationEnum.MAX, this.cappedObservations(calculationParameters, rawObservations).getMulti(), (BigDecimal)this.floor(calculationParameters, rawObservations).get()));
            }
            return this.cappedObservations(calculationParameters, rawObservations);
        }
    }
}

