/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.MapperMaths;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import java.math.BigDecimal;

@ImplementedBy(value=DividendCashSettlementAmountDefault.class)
public abstract class DividendCashSettlementAmount
implements RosettaFunction {
    public BigDecimal evaluate(BigDecimal numberOfSecurities, BigDecimal declaredDividend) {
        BigDecimal dividendCashSettlementAmount = this.doEvaluate(numberOfSecurities, declaredDividend);
        return dividendCashSettlementAmount;
    }

    protected abstract BigDecimal doEvaluate(BigDecimal var1, BigDecimal var2);

    public static class DividendCashSettlementAmountDefault
    extends DividendCashSettlementAmount {
        @Override
        protected BigDecimal doEvaluate(BigDecimal numberOfSecurities, BigDecimal declaredDividend) {
            BigDecimal dividendCashSettlementAmount = null;
            return this.assignOutput(dividendCashSettlementAmount, numberOfSecurities, declaredDividend);
        }

        protected BigDecimal assignOutput(BigDecimal dividendCashSettlementAmount, BigDecimal numberOfSecurities, BigDecimal declaredDividend) {
            dividendCashSettlementAmount = (BigDecimal)MapperMaths.multiply((Mapper)MapperS.of((Object)declaredDividend), (Mapper)MapperS.of((Object)numberOfSecurities)).get();
            return dividendCashSettlementAmount;
        }
    }
}

