/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.asset.validation.datarule;

import cdm.product.asset.CreditDefaultPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CreditDefaultPayoutQuantity")
@ImplementedBy(value=Default.class)
public interface CreditDefaultPayoutQuantity
extends Validator<CreditDefaultPayout> {
    public static final String NAME = "CreditDefaultPayoutQuantity";
    public static final String DEFINITION = "priceQuantity exists";

    public static class NoOp
    implements CreditDefaultPayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditDefaultPayout creditDefaultPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CreditDefaultPayoutQuantity {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CreditDefaultPayout creditDefaultPayout) {
            ComparisonResult result = this.executeDataRule(creditDefaultPayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CreditDefaultPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditDefaultPayout", (RosettaPath)path, (String)CreditDefaultPayoutQuantity.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CreditDefaultPayoutQuantity.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CreditDefaultPayout", (RosettaPath)path, (String)CreditDefaultPayoutQuantity.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CreditDefaultPayout creditDefaultPayout) {
            try {
                return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)creditDefaultPayout).map("getPriceQuantity", _creditDefaultPayout -> _creditDefaultPayout.getPriceQuantity()));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

