/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.ForwardPayout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="ForwardPayoutSettlementDate")
@ImplementedBy(value=Default.class)
public interface ForwardPayoutSettlementDate
extends Validator<ForwardPayout> {
    public static final String NAME = "ForwardPayoutSettlementDate";
    public static final String DEFINITION = "if underlier -> foreignExchange exists then (settlementTerms -> settlementDate -> valueDate exists and underlier -> foreignExchange -> exchangedCurrency1 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate is absent and underlier -> foreignExchange -> exchangedCurrency2 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate is absent) or (settlementTerms -> settlementDate -> valueDate is absent and underlier -> foreignExchange -> exchangedCurrency1 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate exists and underlier -> foreignExchange -> exchangedCurrency2 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate exists and underlier -> foreignExchange -> exchangedCurrency1 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate = underlier -> foreignExchange -> exchangedCurrency2 -> settlementTerms -> settlementDate -> adjustableOrRelativeDate)";

    public static class NoOp
    implements ForwardPayoutSettlementDate {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ForwardPayout forwardPayout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements ForwardPayoutSettlementDate {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, ForwardPayout forwardPayout) {
            ComparisonResult result = this.executeDataRule(forwardPayout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)ForwardPayoutSettlementDate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutSettlementDate.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)ForwardPayoutSettlementDate.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"ForwardPayout", (RosettaPath)path, (String)ForwardPayoutSettlementDate.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(ForwardPayout forwardPayout) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)forwardPayout).map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).orNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)forwardPayout).map("getSettlementTerms", _forwardPayout -> _forwardPayout.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getValueDate", settlementDate -> settlementDate.getValueDate())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()))).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency1", foreignExchange -> foreignExchange.getExchangedCurrency1()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()), (Mapper)MapperS.of((Object)forwardPayout).map("getUnderlier", _forwardPayout -> _forwardPayout.getUnderlier()).map("getForeignExchange", product -> product.getForeignExchange()).map("getExchangedCurrency2", foreignExchange -> foreignExchange.getExchangedCurrency2()).map("getSettlementTerms", cashflow -> cashflow.getSettlementTerms()).map("getSettlementDate", settlementTerms -> settlementTerms.getSettlementDate()).map("getAdjustableOrRelativeDate", settlementDate -> settlementDate.getAdjustableOrRelativeDate()), (CardinalityOperator)CardinalityOperator.All)));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

