/*
 * Decompiled with CFR 0.152.
 */
package cdm.product.template.validation.datarule;

import cdm.product.template.Payout;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="PayoutNotionalResetInterestRatePayoutExists")
@ImplementedBy(value=Default.class)
public interface PayoutNotionalResetInterestRatePayoutExists
extends Validator<Payout> {
    public static final String NAME = "PayoutNotionalResetInterestRatePayoutExists";
    public static final String DEFINITION = "if performancePayout -> priceQuantity -> reset contains True then interestRatePayout exists";

    public static class NoOp
    implements PayoutNotionalResetInterestRatePayoutExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements PayoutNotionalResetInterestRatePayoutExists {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, Payout payout) {
            ComparisonResult result = this.executeDataRule(payout);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)PayoutNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetInterestRatePayoutExists.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)PayoutNotionalResetInterestRatePayoutExists.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"Payout", (RosettaPath)path, (String)PayoutNotionalResetInterestRatePayoutExists.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(Payout payout) {
            try {
                if (ExpressionOperatorsNullSafe.contains((Mapper)MapperS.of((Object)payout).mapC("getPerformancePayout", _payout -> _payout.getPerformancePayout()).map("getPriceQuantity", performancePayout -> performancePayout.getPriceQuantity()).map("getReset", resolvablePriceQuantity -> resolvablePriceQuantity.getReset()), (Mapper)MapperS.of((Object)true)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)payout).mapC("getInterestRatePayout", _payout -> _payout.getInterestRatePayout()));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

