/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.asic.rewrite.trade.functions;

import cdm.base.math.functions.Abs;
import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.projection.iso20022.asic.rewrite.trade.functions.Create_OptionBarrierLevel1Choice__1;
import drr.regulation.asic.rewrite.trade.ASICTransactionReport;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.CommonContractType;
import drr.regulation.common.util.functions.StringLength;
import drr.regulation.common.util.functions.SubString;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd13DecimalAmount;
import iso20022.auth030.asic.ActiveOrHistoricCurrencyAnd5DecimalAmount;
import iso20022.auth030.asic.AmountAndDirection106__1;
import iso20022.auth030.asic.OptionOrSwaption11__1;
import iso20022.auth030.asic.SecuritiesTransactionPrice17Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetOptnDefault.class)
public abstract class GetOptn
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected Abs abs;
    @Inject
    protected Create_OptionBarrierLevel1Choice__1 create_OptionBarrierLevel1Choice__1;
    @Inject
    protected StringLength stringLength;
    @Inject
    protected SubString subString;

    public OptionOrSwaption11__1 evaluate(ASICTransactionReport drrReport) {
        OptionOrSwaption11__1 optn;
        OptionOrSwaption11__1.OptionOrSwaption11__1Builder optnBuilder = this.doEvaluate(drrReport);
        if (optnBuilder == null) {
            optn = null;
        } else {
            optn = optnBuilder.build();
            this.objectValidator.validate(OptionOrSwaption11__1.class, (RosettaModelObject)optn);
        }
        return optn;
    }

    protected abstract OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(ASICTransactionReport var1);

    public static class GetOptnDefault
    extends GetOptn {
        @Override
        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder doEvaluate(ASICTransactionReport drrReport) {
            OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn = OptionOrSwaption11__1.builder();
            return this.assignOutput(optn, drrReport);
        }

        protected OptionOrSwaption11__1.OptionOrSwaption11__1Builder assignOutput(OptionOrSwaption11__1.OptionOrSwaption11__1Builder optn, ASICTransactionReport drrReport) {
            String ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumCurrency())).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getOptionPremiumCurrency", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumAmount()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? (String)MapperS.of((Object)drrReport).map("getLeg1", aSICTransactionReport -> aSICTransactionReport.getLeg1()).map("getSettlementCurrency", commonLeg -> commonLeg.getSettlementCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get() : null);
            optn = (OptionOrSwaption11__1.OptionOrSwaption11__1Builder)this.toBuilder((RosettaModelObject)OptionOrSwaption11__1.builder().setStrkPric((SecuritiesTransactionPrice17Choice__1)MapperS.of((Object)drrReport).mapSingleToItem(item -> {
                String ifThenElseResult0 = null;
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", aSICTransactionReport -> aSICTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.OPTN)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getContractType", aSICTransactionReport -> aSICTransactionReport.getContractType()), (Mapper)MapperS.of((Object)((Object)CommonContractType.SWPT)), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getAssetClass", aSICTransactionReport -> aSICTransactionReport.getAssetClass()), (Mapper)MapperS.of((Object)((Object)CommonAssetClass.INTR)), (CardinalityOperator)CardinalityOperator.All), (Mapper)MapperS.of((Object)false), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult0 = ExpressionOperatorsNullSafe.greaterThan((Mapper)MapperS.of((Object)this.stringLength.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", aSICTransactionReport -> aSICTransactionReport.getStrikePriceCurrency()).get())), (Mapper)MapperS.of((Object)3), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? this.subString.evaluate((String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", aSICTransactionReport -> aSICTransactionReport.getStrikePriceCurrency()).get(), 5, 3) : (String)MapperS.of((Object)drrReport).map("getStrikePriceCurrency", aSICTransactionReport -> aSICTransactionReport.getStrikePriceCurrency()).get();
                }
                Boolean ifThenElseResult1 = null;
                if (ExpressionOperatorsNullSafe.lessThan((Mapper)item.map("getStrikePrice", aSICTransactionReport -> aSICTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()), (Mapper)MapperS.of((Object)BigDecimal.valueOf(0L)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    ifThenElseResult1 = false;
                }
                return MapperS.of((Object)SecuritiesTransactionPrice17Choice__1.builder().setMntryVal(AmountAndDirection106__1.builder().setAmt(ActiveOrHistoricCurrencyAnd13DecimalAmount.builder().setValue(this.abs.evaluate((BigDecimal)item.map("getStrikePrice", aSICTransactionReport -> aSICTransactionReport.getStrikePrice()).map("getMonetary", priceFormat -> priceFormat.getMonetary()).get())).setCcy(ifThenElseResult0).build()).setSgn(ifThenElseResult1).build()).setDcml((BigDecimal)item.map("getStrikePrice", aSICTransactionReport -> aSICTransactionReport.getStrikePrice()).map("getDecimal", priceFormat -> priceFormat.getDecimal()).get()).build());
            }).get()).setCallAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getCallAmount", aSICTransactionReport -> aSICTransactionReport.getCallAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getCallCurrency", aSICTransactionReport -> aSICTransactionReport.getCallCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPutAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getPutAmount", aSICTransactionReport -> aSICTransactionReport.getPutAmount()).get()).setCcy((String)MapperS.of((Object)drrReport).map("getPutCurrency", aSICTransactionReport -> aSICTransactionReport.getPutCurrency()).map("to-string", ISOCurrencyCodeEnum::toDisplayString).get()).build()).setPrmAmt(ActiveOrHistoricCurrencyAnd5DecimalAmount.builder().setValue((BigDecimal)MapperS.of((Object)drrReport).map("getOptionPremiumAmount", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumAmount()).get()).setCcy(ifThenElseResult).build()).setPrmPmtDt((Date)MapperS.of((Object)drrReport).map("getOptionPremiumPaymentDate", aSICTransactionReport -> aSICTransactionReport.getOptionPremiumPaymentDate()).get()).setMtrtyDtOfUndrlyg((Date)MapperS.of((Object)drrReport).map("getMaturityDateOfTheUnderlying", aSICTransactionReport -> aSICTransactionReport.getMaturityDateOfTheUnderlying()).get()).setBrrrLvls(this.create_OptionBarrierLevel1Choice__1.evaluate(drrReport)).build());
            return Optional.ofNullable(optn).map(o -> o.prune()).orElse(null);
        }
    }
}

