/*
 * Decompiled with CFR 0.152.
 */
package drr.projection.iso20022.hkma.rewrite.trade.dtcc.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReferenceEntityFormatEnum;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import iso20022.auth030.hkma.dtcc.CreditDerivative4__1;
import iso20022.auth030.hkma.dtcc.DebtInstrumentSeniorityType2Code;
import iso20022.auth030.hkma.dtcc.DerivativePartyIdentification1Choice;
import iso20022.auth030.hkma.dtcc.Tranche3;
import iso20022.auth030.hkma.dtcc.TrancheIndicator3Choice__1;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetCdtDefault.class)
public abstract class GetCdt
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public CreditDerivative4__1 evaluate(HKMATransactionReport drrReport) {
        CreditDerivative4__1 cdt;
        CreditDerivative4__1.CreditDerivative4__1Builder cdtBuilder = this.doEvaluate(drrReport);
        if (cdtBuilder == null) {
            cdt = null;
        } else {
            cdt = cdtBuilder.build();
            this.objectValidator.validate(CreditDerivative4__1.class, (RosettaModelObject)cdt);
        }
        return cdt;
    }

    protected abstract CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(HKMATransactionReport var1);

    public static class GetCdtDefault
    extends GetCdt {
        @Override
        protected CreditDerivative4__1.CreditDerivative4__1Builder doEvaluate(HKMATransactionReport drrReport) {
            CreditDerivative4__1.CreditDerivative4__1Builder cdt = CreditDerivative4__1.builder();
            return this.assignOutput(cdt, drrReport);
        }

        protected CreditDerivative4__1.CreditDerivative4__1Builder assignOutput(CreditDerivative4__1.CreditDerivative4__1Builder cdt, HKMATransactionReport drrReport) {
            String ifThenElseResult0 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getReferenceEntityFormat", hKMATransactionReport -> hKMATransactionReport.getReferenceEntityFormat()), (Mapper)MapperS.of((Object)((Object)ReferenceEntityFormatEnum.COUNTRY)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult0 = (String)MapperS.of((Object)drrReport).map("getReferenceEntity", hKMATransactionReport -> hKMATransactionReport.getReferenceEntity()).get();
            }
            String ifThenElseResult1 = null;
            if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)drrReport).map("getReferenceEntityFormat", hKMATransactionReport -> hKMATransactionReport.getReferenceEntityFormat()), (Mapper)MapperS.of((Object)((Object)ReferenceEntityFormatEnum.LEI)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                ifThenElseResult1 = (String)MapperS.of((Object)drrReport).map("getReferenceEntity", hKMATransactionReport -> hKMATransactionReport.getReferenceEntity()).get();
            }
            cdt = (CreditDerivative4__1.CreditDerivative4__1Builder)this.toBuilder((RosettaModelObject)CreditDerivative4__1.builder().setIndxFctr((BigDecimal)MapperS.of((Object)drrReport).map("getIndexFactor", hKMATransactionReport -> hKMATransactionReport.getIndexFactor()).get()).setTrch(TrancheIndicator3Choice__1.builder().setTrnchd(Tranche3.builder().setAttchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexAttachmentPoint", hKMATransactionReport -> hKMATransactionReport.getCdSIndexAttachmentPoint()).get()).setDtchmntPt((BigDecimal)MapperS.of((Object)drrReport).map("getCdSIndexDetachmentPoint", hKMATransactionReport -> hKMATransactionReport.getCdSIndexDetachmentPoint()).get()).build()).build()).setSnrty((DebtInstrumentSeniorityType2Code)MapperS.of((Object)drrReport).map("getSeniority", hKMATransactionReport -> hKMATransactionReport.getSeniority()).checkedMap("to-enum", e -> DebtInstrumentSeniorityType2Code.valueOf((String)e.name()), IllegalArgumentException.class).get()).setRefPty(DerivativePartyIdentification1Choice.builder().setCtry(ifThenElseResult0).setCtrySubDvsn(null).setLei(ifThenElseResult1).build()).setSrs((Integer)MapperS.of((Object)drrReport).map("getSeries", hKMATransactionReport -> hKMATransactionReport.getSeries()).get()).setVrsn((Integer)MapperS.of((Object)drrReport).map("getSeriesVersion", hKMATransactionReport -> hKMATransactionReport.getSeriesVersion()).get()).build());
            return Optional.ofNullable(cdt).map(o -> o.prune()).orElse(null);
        }
    }
}

