/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.asic.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.asic.rewrite.trade.functions.IsAllowableActionForASIC;
import drr.regulation.asic.rewrite.trade.reports.PackageTransactionPriceNotationRule;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetPackageInformation;
import drr.standards.iosco.cde.base.price.PriceFormat;
import drr.standards.iosco.cde.base.price.functions.PriceFormatFromNotation;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceNoFormatRule;
import drr.standards.iosco.cde.version3.price.reports.PackageTransactionPriceNotationEnumRule;
import java.math.BigDecimal;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=PackageTransactionPriceRuleDefault.class)
public abstract class PackageTransactionPriceRule
implements ReportFunction<TransactionReportInstruction, PriceFormat> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected GetPackageInformation getPackageInformation;
    @Inject
    protected IsAllowableActionForASIC isAllowableActionForASIC;
    @Inject
    protected PackageTransactionPriceNoFormatRule packageTransactionPriceNoFormatRule;
    @Inject
    protected PackageTransactionPriceNotationEnumRule packageTransactionPriceNotationEnumRule;
    @Inject
    protected PackageTransactionPriceNotationRule packageTransactionPriceNotationRule;
    @Inject
    protected PriceFormatFromNotation priceFormatFromNotation;

    public PriceFormat evaluate(TransactionReportInstruction input) {
        PriceFormat output;
        PriceFormat.PriceFormatBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(PriceFormat.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction var1);

    public static class PackageTransactionPriceRuleDefault
    extends PackageTransactionPriceRule {
        @Override
        protected PriceFormat.PriceFormatBuilder doEvaluate(TransactionReportInstruction input) {
            PriceFormat.PriceFormatBuilder output = PriceFormat.builder();
            return this.assignOutput(output, input);
        }

        protected PriceFormat.PriceFormatBuilder assignOutput(PriceFormat.PriceFormatBuilder output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForASIC.evaluate((ReportableEvent)item.get()));
            output = (PriceFormat.PriceFormatBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> {
                BigDecimal ifThenElseResult = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getPackageInformation.evaluate((ReportableEvent)item.get())).map("getListId", identifiedList -> identifiedList.getListId()).mapC("getAssignedIdentifier", identifier -> identifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)((Object)this.packageTransactionPriceNotationEnumRule.evaluate((TransactionReportInstruction)item.get()))))).getOrDefault(Boolean.valueOf(false)) != false ? BigDecimal.valueOf(99999999999L) : this.packageTransactionPriceNoFormatRule.evaluate((TransactionReportInstruction)item.get());
                return MapperS.of((Object)this.priceFormatFromNotation.evaluate(ifThenElseResult, this.packageTransactionPriceNotationRule.evaluate((TransactionReportInstruction)item.get())));
            }).get());
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

