/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.reports;

import cdm.base.datetime.PeriodExtendedEnum;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.cftc.rewrite.trade.functions.IsAllowableActionForCFTC;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.InterestRateLeg1;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.ProductOrUnderlierProduct;
import drr.standards.iosco.cde.base.payment.functions.MapCDEFrequencyPeriod;
import drr.standards.iso.FrequencyPeriodEnum;
import javax.inject.Inject;

@ImplementedBy(value=FloatingRateResetFrequencyPeriodLeg1RuleDefault.class)
public abstract class FloatingRateResetFrequencyPeriodLeg1Rule
implements ReportFunction<TransactionReportInstruction, FrequencyPeriodEnum> {
    @Inject
    protected InterestRateLeg1 interestRateLeg1;
    @Inject
    protected IsAllowableActionForCFTC isAllowableActionForCFTC;
    @Inject
    protected MapCDEFrequencyPeriod mapCDEFrequencyPeriod;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected ProductOrUnderlierProduct productOrUnderlierProduct;

    public FrequencyPeriodEnum evaluate(TransactionReportInstruction input) {
        FrequencyPeriodEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract FrequencyPeriodEnum doEvaluate(TransactionReportInstruction var1);

    public static class FloatingRateResetFrequencyPeriodLeg1RuleDefault
    extends FloatingRateResetFrequencyPeriodLeg1Rule {
        @Override
        protected FrequencyPeriodEnum doEvaluate(TransactionReportInstruction input) {
            FrequencyPeriodEnum output = null;
            return this.assignOutput(output, input);
        }

        protected FrequencyPeriodEnum assignOutput(FrequencyPeriodEnum output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableActionForCFTC.evaluate((ReportableEvent)item.get()));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.productOrUnderlierProduct.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> MapperS.of((Object)this.interestRateLeg1.evaluate((Product)item.get())));
            output = (FrequencyPeriodEnum)((Object)thenArg3.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getFloatingRate", rateSpecification -> rateSpecification.getFloatingRate())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getRateSpecification", interestRatePayout -> interestRatePayout.getRateSpecification()).map("getInflationRate", rateSpecification -> rateSpecification.getInflationRate()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)this.mapCDEFrequencyPeriod.evaluate((PeriodExtendedEnum)item.map("getResetDates", interestRatePayout -> interestRatePayout.getResetDates()).map("getResetFrequency", resetDates -> resetDates.getResetFrequency()).map("getPeriod", resetFrequency -> resetFrequency.getPeriod()).get())));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

