/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.cftc.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.cftc.rewrite.trade.CFTCPart45TransactionReport;
import drr.standards.iosco.upi.AnnaDsbDeliveryTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CFTCPart45TransactionReportSettlementCurrencyCondition")
@ImplementedBy(value=Default.class)
public interface CFTCPart45TransactionReportSettlementCurrencyCondition
extends Validator<CFTCPart45TransactionReport> {
    public static final String NAME = "CFTCPart45TransactionReportSettlementCurrencyCondition";
    public static final String DEFINITION = "if nonReportable -> postUpiData -> Attributes -> DeliveryType = CASH or nonReportable -> deliveryType = CASH then (leg1 -> settlementCurrency exists or leg2 -> settlementCurrency exists) else (leg1 -> settlementCurrency is absent and leg2 -> settlementCurrency is absent)";

    public static class NoOp
    implements CFTCPart45TransactionReportSettlementCurrencyCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CFTCPart45TransactionReportSettlementCurrencyCondition {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            ComparisonResult result = this.executeDataRule(cFTCPart45TransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CFTCPart45TransactionReportSettlementCurrencyCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportSettlementCurrencyCondition.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CFTCPart45TransactionReportSettlementCurrencyCondition.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CFTCPart45TransactionReport", (RosettaPath)path, (String)CFTCPart45TransactionReportSettlementCurrencyCondition.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CFTCPart45TransactionReport cFTCPart45TransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getPostUpiData", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getPostUpiData()).map("getAttributes", annaDsbUpiRecord -> annaDsbUpiRecord.getAttributes()).map("getDeliveryType", annaDsbAttributesRecord -> annaDsbAttributesRecord.getDeliveryType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbDeliveryTypeEnum.CASH)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getNonReportable", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getNonReportable()).map("getDeliveryType", cFTCNonReportablePart45 -> cFTCNonReportablePart45.getDeliveryType()), (Mapper)MapperS.of((Object)((Object)AnnaDsbDeliveryTypeEnum.CASH)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getSettlementCurrency", cFTCPart45Leg -> cFTCPart45Leg.getSettlementCurrency())).orNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getSettlementCurrency", cFTCPart45Leg -> cFTCPart45Leg.getSettlementCurrency())));
                }
                return ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg1", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg1()).map("getSettlementCurrency", cFTCPart45Leg -> cFTCPart45Leg.getSettlementCurrency())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)MapperS.of((Object)cFTCPart45TransactionReport).map("getLeg2", _cFTCPart45TransactionReport -> _cFTCPart45TransactionReport.getLeg2()).map("getSettlementCurrency", cFTCPart45Leg -> cFTCPart45Leg.getSettlementCurrency())));
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

