/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.identifier.Identifier;
import cdm.product.collateral.Collateral;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.ReportableValuation;
import drr.regulation.common.ReportingSide;
import drr.regulation.common.ValuationDetails;
import drr.regulation.common.meta.ValuationReportInstructionMeta;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationReportInstruction", builder=ValuationReportInstructionBuilderImpl.class, version="6.24.0")
@RuneDataType(value="ValuationReportInstruction", model="drr", builder=ValuationReportInstructionBuilderImpl.class, version="6.24.0")
public interface ValuationReportInstruction
extends ReportableValuation {
    public static final ValuationReportInstructionMeta metaData = new ValuationReportInstructionMeta();

    public ReportingSide getReportingSide();

    @Override
    public ValuationReportInstruction build();

    @Override
    public ValuationReportInstructionBuilder toBuilder();

    public static ValuationReportInstructionBuilder builder() {
        return new ValuationReportInstructionBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationReportInstruction> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationReportInstruction> getType() {
        return ValuationReportInstruction.class;
    }

    @Override
    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.class, this.getValuationDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.class, this.getReportableInformation(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("collateralDetails"), processor, Collateral.class, (RosettaModelObject)this.getCollateralDetails(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.class, this.getEventIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.class, this.getReportingSide(), new AttributeMeta[0]);
    }

    public static class ValuationReportInstructionBuilderImpl
    extends ReportableValuation.ReportableValuationBuilderImpl
    implements ValuationReportInstructionBuilder {
        protected ReportingSide.ReportingSideBuilder reportingSide;

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide.ReportingSideBuilder getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide() {
            ReportingSide.ReportingSideBuilder result = this.reportingSide != null ? this.reportingSide : (this.reportingSide = ReportingSide.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="valuationDetails")
        @RuneAttribute(value="valuationDetails")
        public ValuationReportInstructionBuilder setValuationDetails(ValuationDetails _valuationDetails) {
            this.valuationDetails = _valuationDetails == null ? null : _valuationDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="reportableInformation", isRequired=true)
        @RuneAttribute(value="reportableInformation", isRequired=true)
        public ValuationReportInstructionBuilder setReportableInformation(ReportableInformation _reportableInformation) {
            this.reportableInformation = _reportableInformation == null ? null : _reportableInformation.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="collateralDetails")
        @RuneAttribute(value="collateralDetails")
        public ValuationReportInstructionBuilder setCollateralDetails(Collateral _collateralDetails) {
            this.collateralDetails = _collateralDetails == null ? null : _collateralDetails.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="eventIdentifier")
        @RuneAttribute(value="eventIdentifier")
        public ValuationReportInstructionBuilder addEventIdentifier(Identifier _eventIdentifier) {
            if (_eventIdentifier != null) {
                this.eventIdentifier.add(_eventIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationReportInstructionBuilder addEventIdentifier(Identifier _eventIdentifier, int idx) {
            this.getIndex(this.eventIdentifier, idx, () -> _eventIdentifier.toBuilder());
            return this;
        }

        @Override
        public ValuationReportInstructionBuilder addEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            if (eventIdentifiers != null) {
                for (Identifier identifier : eventIdentifiers) {
                    this.eventIdentifier.add(identifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="eventIdentifier")
        public ValuationReportInstructionBuilder setEventIdentifier(List<? extends Identifier> eventIdentifiers) {
            this.eventIdentifier = eventIdentifiers == null ? new ArrayList() : (List)eventIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ValuationReportInstructionBuilder setReportingSide(ReportingSide _reportingSide) {
            this.reportingSide = _reportingSide == null ? null : _reportingSide.toBuilder();
            return this;
        }

        @Override
        public ValuationReportInstruction build() {
            return new ValuationReportInstructionImpl(this);
        }

        @Override
        public ValuationReportInstructionBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationReportInstructionBuilder prune() {
            super.prune();
            if (this.reportingSide != null && !this.reportingSide.prune().hasData()) {
                this.reportingSide = null;
            }
            return this;
        }

        @Override
        public boolean hasData() {
            if (super.hasData()) {
                return true;
            }
            return this.getReportingSide() != null && this.getReportingSide().hasData();
        }

        @Override
        public ValuationReportInstructionBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            super.merge(other, merger);
            ValuationReportInstructionBuilder o = (ValuationReportInstructionBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getReportingSide(), (RosettaModelObjectBuilder)o.getReportingSide(), this::setReportingSide);
            return this;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReportInstruction _that = (ValuationReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReportInstructionBuilder {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }

    public static interface ValuationReportInstructionBuilder
    extends ValuationReportInstruction,
    ReportableValuation.ReportableValuationBuilder {
        public ReportingSide.ReportingSideBuilder getOrCreateReportingSide();

        @Override
        public ReportingSide.ReportingSideBuilder getReportingSide();

        @Override
        public ValuationReportInstructionBuilder setValuationDetails(ValuationDetails var1);

        @Override
        public ValuationReportInstructionBuilder setReportableInformation(ReportableInformation var1);

        @Override
        public ValuationReportInstructionBuilder setCollateralDetails(Collateral var1);

        @Override
        public ValuationReportInstructionBuilder addEventIdentifier(Identifier var1);

        @Override
        public ValuationReportInstructionBuilder addEventIdentifier(Identifier var1, int var2);

        @Override
        public ValuationReportInstructionBuilder addEventIdentifier(List<? extends Identifier> var1);

        @Override
        public ValuationReportInstructionBuilder setEventIdentifier(List<? extends Identifier> var1);

        public ValuationReportInstructionBuilder setReportingSide(ReportingSide var1);

        @Override
        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("valuationDetails"), processor, ValuationDetails.ValuationDetailsBuilder.class, (RosettaModelObjectBuilder)this.getValuationDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportableInformation"), processor, ReportableInformation.ReportableInformationBuilder.class, (RosettaModelObjectBuilder)this.getReportableInformation(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("collateralDetails"), processor, Collateral.CollateralBuilder.class, (RosettaModelObjectBuilder)this.getCollateralDetails(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("eventIdentifier"), processor, Identifier.IdentifierBuilder.class, this.getEventIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("reportingSide"), processor, ReportingSide.ReportingSideBuilder.class, this.getReportingSide(), new AttributeMeta[0]);
        }

        @Override
        public ValuationReportInstructionBuilder prune();
    }

    public static class ValuationReportInstructionImpl
    extends ReportableValuation.ReportableValuationImpl
    implements ValuationReportInstruction {
        private final ReportingSide reportingSide;

        protected ValuationReportInstructionImpl(ValuationReportInstructionBuilder builder) {
            super(builder);
            this.reportingSide = Optional.ofNullable(builder.getReportingSide()).map(f -> f.build()).orElse(null);
        }

        @Override
        @RosettaAttribute(value="reportingSide", isRequired=true)
        @RuneAttribute(value="reportingSide", isRequired=true)
        public ReportingSide getReportingSide() {
            return this.reportingSide;
        }

        @Override
        public ValuationReportInstruction build() {
            return this;
        }

        @Override
        public ValuationReportInstructionBuilder toBuilder() {
            ValuationReportInstructionBuilder builder = ValuationReportInstruction.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationReportInstructionBuilder builder) {
            super.setBuilderFields(builder);
            Optional.ofNullable(this.getReportingSide()).ifPresent(builder::setReportingSide);
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            if (!super.equals(o)) {
                return false;
            }
            ValuationReportInstruction _that = (ValuationReportInstruction)this.getType().cast(o);
            return Objects.equals(this.reportingSide, _that.getReportingSide());
        }

        @Override
        public int hashCode() {
            int _result = super.hashCode();
            _result = 31 * _result + (this.reportingSide != null ? this.reportingSide.hashCode() : 0);
            return _result;
        }

        @Override
        public String toString() {
            return "ValuationReportInstruction {reportingSide=" + String.valueOf(this.reportingSide) + "} " + super.toString();
        }
    }
}

