/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common;

import cdm.base.staticdata.asset.common.ProductIdentifier;
import cdm.event.common.TradeIdentifier;
import com.google.common.collect.ImmutableList;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import com.rosetta.model.lib.records.Date;
import com.rosetta.util.ListEquals;
import drr.regulation.common.CommonAssetClass;
import drr.regulation.common.LastFloatingReference;
import drr.regulation.common.meta.ValuationTradeInformationMeta;
import drr.standards.iso.ActionTypeEnum;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;

@RosettaDataType(value="ValuationTradeInformation", builder=ValuationTradeInformationBuilderImpl.class, version="6.24.0")
@RuneDataType(value="ValuationTradeInformation", model="drr", builder=ValuationTradeInformationBuilderImpl.class, version="6.24.0")
public interface ValuationTradeInformation
extends RosettaModelObject {
    public static final ValuationTradeInformationMeta metaData = new ValuationTradeInformationMeta();

    public TradeIdentifier getUniqueTradeIdentifier();

    public List<? extends ProductIdentifier> getUniqueProductIdentifier();

    public ActionTypeEnum getAction();

    public Date getNextFloatingReferenceResetDateLeg1();

    public Date getNextFloatingReferenceResetDateLeg2();

    public LastFloatingReference getLastFloatingReference();

    public CommonAssetClass getAssetClass();

    public ValuationTradeInformation build();

    public ValuationTradeInformationBuilder toBuilder();

    public static ValuationTradeInformationBuilder builder() {
        return new ValuationTradeInformationBuilderImpl();
    }

    default public RosettaMetaData<? extends ValuationTradeInformation> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends ValuationTradeInformation> getType() {
        return ValuationTradeInformation.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        this.processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.class, (RosettaModelObject)this.getUniqueTradeIdentifier(), new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("uniqueProductIdentifier"), processor, ProductIdentifier.class, this.getUniqueProductIdentifier(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("action"), ActionTypeEnum.class, (Object)this.getAction(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObject)this, new AttributeMeta[0]);
        this.processRosetta(path.newSubPath("lastFloatingReference"), processor, LastFloatingReference.class, this.getLastFloatingReference(), new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class ValuationTradeInformationBuilderImpl
    implements ValuationTradeInformationBuilder {
        protected TradeIdentifier.TradeIdentifierBuilder uniqueTradeIdentifier;
        protected List<ProductIdentifier.ProductIdentifierBuilder> uniqueProductIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
        protected ActionTypeEnum action;
        protected Date nextFloatingReferenceResetDateLeg1;
        protected Date nextFloatingReferenceResetDateLeg2;
        protected LastFloatingReference.LastFloatingReferenceBuilder lastFloatingReference;
        protected CommonAssetClass assetClass;

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier() {
            return this.uniqueTradeIdentifier;
        }

        @Override
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier() {
            TradeIdentifier.TradeIdentifierBuilder result = this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier : (this.uniqueTradeIdentifier = TradeIdentifier.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        public ProductIdentifier.ProductIdentifierBuilder getOrCreateUniqueProductIdentifier(int index) {
            if (this.uniqueProductIdentifier == null) {
                this.uniqueProductIdentifier = new ArrayList<ProductIdentifier.ProductIdentifierBuilder>();
            }
            return (ProductIdentifier.ProductIdentifierBuilder)this.getIndex(this.uniqueProductIdentifier, index, () -> {
                ProductIdentifier.ProductIdentifierBuilder newUniqueProductIdentifier = ProductIdentifier.builder();
                return newUniqueProductIdentifier;
            });
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public ActionTypeEnum getAction() {
            return this.action;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReference")
        @RuneAttribute(value="lastFloatingReference")
        public LastFloatingReference.LastFloatingReferenceBuilder getLastFloatingReference() {
            return this.lastFloatingReference;
        }

        @Override
        public LastFloatingReference.LastFloatingReferenceBuilder getOrCreateLastFloatingReference() {
            LastFloatingReference.LastFloatingReferenceBuilder result = this.lastFloatingReference != null ? this.lastFloatingReference : (this.lastFloatingReference = LastFloatingReference.builder());
            return result;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public ValuationTradeInformationBuilder setUniqueTradeIdentifier(TradeIdentifier _uniqueTradeIdentifier) {
            this.uniqueTradeIdentifier = _uniqueTradeIdentifier == null ? null : _uniqueTradeIdentifier.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public ValuationTradeInformationBuilder addUniqueProductIdentifier(ProductIdentifier _uniqueProductIdentifier) {
            if (_uniqueProductIdentifier != null) {
                this.uniqueProductIdentifier.add(_uniqueProductIdentifier.toBuilder());
            }
            return this;
        }

        @Override
        public ValuationTradeInformationBuilder addUniqueProductIdentifier(ProductIdentifier _uniqueProductIdentifier, int idx) {
            this.getIndex(this.uniqueProductIdentifier, idx, () -> _uniqueProductIdentifier.toBuilder());
            return this;
        }

        @Override
        public ValuationTradeInformationBuilder addUniqueProductIdentifier(List<? extends ProductIdentifier> uniqueProductIdentifiers) {
            if (uniqueProductIdentifiers != null) {
                for (ProductIdentifier productIdentifier : uniqueProductIdentifiers) {
                    this.uniqueProductIdentifier.add(productIdentifier.toBuilder());
                }
            }
            return this;
        }

        @Override
        @RuneAttribute(value="uniqueProductIdentifier")
        public ValuationTradeInformationBuilder setUniqueProductIdentifier(List<? extends ProductIdentifier> uniqueProductIdentifiers) {
            this.uniqueProductIdentifier = uniqueProductIdentifiers == null ? new ArrayList<ProductIdentifier.ProductIdentifierBuilder>() : (List)uniqueProductIdentifiers.stream().map(_a -> _a.toBuilder()).collect(Collectors.toCollection(() -> new ArrayList()));
            return this;
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public ValuationTradeInformationBuilder setAction(ActionTypeEnum _action) {
            this.action = _action == null ? null : _action;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg1(Date _nextFloatingReferenceResetDateLeg1) {
            this.nextFloatingReferenceResetDateLeg1 = _nextFloatingReferenceResetDateLeg1 == null ? null : _nextFloatingReferenceResetDateLeg1;
            return this;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg2(Date _nextFloatingReferenceResetDateLeg2) {
            this.nextFloatingReferenceResetDateLeg2 = _nextFloatingReferenceResetDateLeg2 == null ? null : _nextFloatingReferenceResetDateLeg2;
            return this;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReference")
        @RuneAttribute(value="lastFloatingReference")
        public ValuationTradeInformationBuilder setLastFloatingReference(LastFloatingReference _lastFloatingReference) {
            this.lastFloatingReference = _lastFloatingReference == null ? null : _lastFloatingReference.toBuilder();
            return this;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public ValuationTradeInformationBuilder setAssetClass(CommonAssetClass _assetClass) {
            this.assetClass = _assetClass == null ? null : _assetClass;
            return this;
        }

        @Override
        public ValuationTradeInformation build() {
            return new ValuationTradeInformationImpl(this);
        }

        @Override
        public ValuationTradeInformationBuilder toBuilder() {
            return this;
        }

        @Override
        public ValuationTradeInformationBuilder prune() {
            if (this.uniqueTradeIdentifier != null && !this.uniqueTradeIdentifier.prune().hasData()) {
                this.uniqueTradeIdentifier = null;
            }
            this.uniqueProductIdentifier = this.uniqueProductIdentifier.stream().filter(b -> b != null).map(b -> b.prune()).filter(b -> b.hasData()).collect(Collectors.toList());
            if (this.lastFloatingReference != null && !this.lastFloatingReference.prune().hasData()) {
                this.lastFloatingReference = null;
            }
            return this;
        }

        public boolean hasData() {
            if (this.getUniqueTradeIdentifier() != null && this.getUniqueTradeIdentifier().hasData()) {
                return true;
            }
            if (this.getUniqueProductIdentifier() != null && this.getUniqueProductIdentifier().stream().filter(Objects::nonNull).anyMatch(a -> a.hasData())) {
                return true;
            }
            if (this.getAction() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg1() != null) {
                return true;
            }
            if (this.getNextFloatingReferenceResetDateLeg2() != null) {
                return true;
            }
            if (this.getLastFloatingReference() != null && this.getLastFloatingReference().hasData()) {
                return true;
            }
            return this.getAssetClass() != null;
        }

        public ValuationTradeInformationBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            ValuationTradeInformationBuilder o = (ValuationTradeInformationBuilder)other;
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getUniqueTradeIdentifier(), (RosettaModelObjectBuilder)o.getUniqueTradeIdentifier(), this::setUniqueTradeIdentifier);
            merger.mergeRosetta(this.getUniqueProductIdentifier(), o.getUniqueProductIdentifier(), this::getOrCreateUniqueProductIdentifier);
            merger.mergeRosetta((RosettaModelObjectBuilder)this.getLastFloatingReference(), (RosettaModelObjectBuilder)o.getLastFloatingReference(), this::setLastFloatingReference);
            merger.mergeBasic((Object)this.getAction(), (Object)o.getAction(), this::setAction, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg1(), (Object)o.getNextFloatingReferenceResetDateLeg1(), this::setNextFloatingReferenceResetDateLeg1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNextFloatingReferenceResetDateLeg2(), (Object)o.getNextFloatingReferenceResetDateLeg2(), this::setNextFloatingReferenceResetDateLeg2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getAssetClass(), (Object)o.getAssetClass(), this::setAssetClass, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationTradeInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReference, _that.getLastFloatingReference())) {
                return false;
            }
            return Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReference != null ? this.lastFloatingReference.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationTradeInformationBuilder {uniqueTradeIdentifier=" + String.valueOf(this.uniqueTradeIdentifier) + ", uniqueProductIdentifier=" + String.valueOf(this.uniqueProductIdentifier) + ", action=" + String.valueOf((Object)this.action) + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", lastFloatingReference=" + String.valueOf(this.lastFloatingReference) + ", assetClass=" + String.valueOf((Object)this.assetClass) + "}";
        }
    }

    public static interface ValuationTradeInformationBuilder
    extends ValuationTradeInformation,
    RosettaModelObjectBuilder {
        public TradeIdentifier.TradeIdentifierBuilder getOrCreateUniqueTradeIdentifier();

        public TradeIdentifier.TradeIdentifierBuilder getUniqueTradeIdentifier();

        public ProductIdentifier.ProductIdentifierBuilder getOrCreateUniqueProductIdentifier(int var1);

        public List<? extends ProductIdentifier.ProductIdentifierBuilder> getUniqueProductIdentifier();

        public LastFloatingReference.LastFloatingReferenceBuilder getOrCreateLastFloatingReference();

        @Override
        public LastFloatingReference.LastFloatingReferenceBuilder getLastFloatingReference();

        public ValuationTradeInformationBuilder setUniqueTradeIdentifier(TradeIdentifier var1);

        public ValuationTradeInformationBuilder addUniqueProductIdentifier(ProductIdentifier var1);

        public ValuationTradeInformationBuilder addUniqueProductIdentifier(ProductIdentifier var1, int var2);

        public ValuationTradeInformationBuilder addUniqueProductIdentifier(List<? extends ProductIdentifier> var1);

        public ValuationTradeInformationBuilder setUniqueProductIdentifier(List<? extends ProductIdentifier> var1);

        public ValuationTradeInformationBuilder setAction(ActionTypeEnum var1);

        public ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg1(Date var1);

        public ValuationTradeInformationBuilder setNextFloatingReferenceResetDateLeg2(Date var1);

        public ValuationTradeInformationBuilder setLastFloatingReference(LastFloatingReference var1);

        public ValuationTradeInformationBuilder setAssetClass(CommonAssetClass var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            this.processRosetta(path.newSubPath("uniqueTradeIdentifier"), processor, TradeIdentifier.TradeIdentifierBuilder.class, (RosettaModelObjectBuilder)this.getUniqueTradeIdentifier(), new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("uniqueProductIdentifier"), processor, ProductIdentifier.ProductIdentifierBuilder.class, this.getUniqueProductIdentifier(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("action"), ActionTypeEnum.class, (Object)this.getAction(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg1"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("nextFloatingReferenceResetDateLeg2"), Date.class, (Object)this.getNextFloatingReferenceResetDateLeg2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            this.processRosetta(path.newSubPath("lastFloatingReference"), processor, LastFloatingReference.LastFloatingReferenceBuilder.class, this.getLastFloatingReference(), new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("assetClass"), CommonAssetClass.class, (Object)this.getAssetClass(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public ValuationTradeInformationBuilder prune();
    }

    public static class ValuationTradeInformationImpl
    implements ValuationTradeInformation {
        private final TradeIdentifier uniqueTradeIdentifier;
        private final List<? extends ProductIdentifier> uniqueProductIdentifier;
        private final ActionTypeEnum action;
        private final Date nextFloatingReferenceResetDateLeg1;
        private final Date nextFloatingReferenceResetDateLeg2;
        private final LastFloatingReference lastFloatingReference;
        private final CommonAssetClass assetClass;

        protected ValuationTradeInformationImpl(ValuationTradeInformationBuilder builder) {
            this.uniqueTradeIdentifier = Optional.ofNullable(builder.getUniqueTradeIdentifier()).map(f -> f.build()).orElse(null);
            this.uniqueProductIdentifier = Optional.ofNullable(builder.getUniqueProductIdentifier()).filter(_l -> !_l.isEmpty()).map(list -> (ImmutableList)list.stream().filter(Objects::nonNull).map(f -> f.build()).filter(Objects::nonNull).collect(ImmutableList.toImmutableList())).orElse(null);
            this.action = builder.getAction();
            this.nextFloatingReferenceResetDateLeg1 = builder.getNextFloatingReferenceResetDateLeg1();
            this.nextFloatingReferenceResetDateLeg2 = builder.getNextFloatingReferenceResetDateLeg2();
            this.lastFloatingReference = Optional.ofNullable(builder.getLastFloatingReference()).map(f -> f.build()).orElse(null);
            this.assetClass = builder.getAssetClass();
        }

        @Override
        @RosettaAttribute(value="uniqueTradeIdentifier")
        @RuneAttribute(value="uniqueTradeIdentifier")
        public TradeIdentifier getUniqueTradeIdentifier() {
            return this.uniqueTradeIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueProductIdentifier")
        @RuneAttribute(value="uniqueProductIdentifier")
        public List<? extends ProductIdentifier> getUniqueProductIdentifier() {
            return this.uniqueProductIdentifier;
        }

        @Override
        @RosettaAttribute(value="action")
        @RuneAttribute(value="action")
        public ActionTypeEnum getAction() {
            return this.action;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg1")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg1")
        public Date getNextFloatingReferenceResetDateLeg1() {
            return this.nextFloatingReferenceResetDateLeg1;
        }

        @Override
        @RosettaAttribute(value="nextFloatingReferenceResetDateLeg2")
        @RuneAttribute(value="nextFloatingReferenceResetDateLeg2")
        public Date getNextFloatingReferenceResetDateLeg2() {
            return this.nextFloatingReferenceResetDateLeg2;
        }

        @Override
        @RosettaAttribute(value="lastFloatingReference")
        @RuneAttribute(value="lastFloatingReference")
        public LastFloatingReference getLastFloatingReference() {
            return this.lastFloatingReference;
        }

        @Override
        @RosettaAttribute(value="assetClass")
        @RuneAttribute(value="assetClass")
        public CommonAssetClass getAssetClass() {
            return this.assetClass;
        }

        @Override
        public ValuationTradeInformation build() {
            return this;
        }

        @Override
        public ValuationTradeInformationBuilder toBuilder() {
            ValuationTradeInformationBuilder builder = ValuationTradeInformation.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(ValuationTradeInformationBuilder builder) {
            Optional.ofNullable(this.getUniqueTradeIdentifier()).ifPresent(builder::setUniqueTradeIdentifier);
            Optional.ofNullable(this.getUniqueProductIdentifier()).ifPresent(builder::setUniqueProductIdentifier);
            Optional.ofNullable(this.getAction()).ifPresent(builder::setAction);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg1()).ifPresent(builder::setNextFloatingReferenceResetDateLeg1);
            Optional.ofNullable(this.getNextFloatingReferenceResetDateLeg2()).ifPresent(builder::setNextFloatingReferenceResetDateLeg2);
            Optional.ofNullable(this.getLastFloatingReference()).ifPresent(builder::setLastFloatingReference);
            Optional.ofNullable(this.getAssetClass()).ifPresent(builder::setAssetClass);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            ValuationTradeInformation _that = this.getType().cast(o);
            if (!Objects.equals(this.uniqueTradeIdentifier, _that.getUniqueTradeIdentifier())) {
                return false;
            }
            if (!ListEquals.listEquals(this.uniqueProductIdentifier, _that.getUniqueProductIdentifier())) {
                return false;
            }
            if (!Objects.equals((Object)this.action, (Object)_that.getAction())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg1, _that.getNextFloatingReferenceResetDateLeg1())) {
                return false;
            }
            if (!Objects.equals(this.nextFloatingReferenceResetDateLeg2, _that.getNextFloatingReferenceResetDateLeg2())) {
                return false;
            }
            if (!Objects.equals(this.lastFloatingReference, _that.getLastFloatingReference())) {
                return false;
            }
            return Objects.equals((Object)this.assetClass, (Object)_that.getAssetClass());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.uniqueTradeIdentifier != null ? this.uniqueTradeIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueProductIdentifier != null ? this.uniqueProductIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.action != null ? ((Object)((Object)this.action)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg1 != null ? this.nextFloatingReferenceResetDateLeg1.hashCode() : 0);
            _result = 31 * _result + (this.nextFloatingReferenceResetDateLeg2 != null ? this.nextFloatingReferenceResetDateLeg2.hashCode() : 0);
            _result = 31 * _result + (this.lastFloatingReference != null ? this.lastFloatingReference.hashCode() : 0);
            _result = 31 * _result + (this.assetClass != null ? ((Object)((Object)this.assetClass)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "ValuationTradeInformation {uniqueTradeIdentifier=" + String.valueOf(this.uniqueTradeIdentifier) + ", uniqueProductIdentifier=" + String.valueOf(this.uniqueProductIdentifier) + ", action=" + String.valueOf((Object)this.action) + ", nextFloatingReferenceResetDateLeg1=" + String.valueOf(this.nextFloatingReferenceResetDateLeg1) + ", nextFloatingReferenceResetDateLeg2=" + String.valueOf(this.nextFloatingReferenceResetDateLeg2) + ", lastFloatingReference=" + String.valueOf(this.lastFloatingReference) + ", assetClass=" + String.valueOf((Object)this.assetClass) + "}";
        }
    }
}

