/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.standards.iso.FrequencyPeriodEnum;
import java.math.BigDecimal;

@ImplementedBy(value=AdjustPeriodMultiplierDefault.class)
public abstract class AdjustPeriodMultiplier
implements RosettaFunction {
    public BigDecimal evaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
        BigDecimal periodMultiplierValue = this.doEvaluate(period, periodMultiplier);
        return periodMultiplierValue;
    }

    protected abstract BigDecimal doEvaluate(FrequencyPeriodEnum var1, BigDecimal var2);

    public static class AdjustPeriodMultiplierDefault
    extends AdjustPeriodMultiplier {
        @Override
        protected BigDecimal doEvaluate(FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
            BigDecimal periodMultiplierValue = null;
            return this.assignOutput(periodMultiplierValue, period, periodMultiplier);
        }

        protected BigDecimal assignOutput(BigDecimal periodMultiplierValue, FrequencyPeriodEnum period, BigDecimal periodMultiplier) {
            periodMultiplierValue = ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)((Object)period)), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.MNTH)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)periodMultiplier), (Mapper)MapperS.of((Object)BigDecimal.valueOf(12L)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? BigDecimal.valueOf(1L) : periodMultiplier;
            return periodMultiplierValue;
        }
    }
}

