/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.base.staticdata.asset.common.TaxonomySourceEnum;
import cdm.product.common.settlement.SettlementTerms;
import cdm.product.common.settlement.SettlementTypeEnum;
import cdm.product.qualification.functions.Qualify_AssetClass_Credit;
import cdm.product.qualification.functions.Qualify_BaseProduct_CrossCurrency;
import cdm.product.qualification.functions.Qualify_BaseProduct_IRSwap;
import cdm.product.qualification.functions.Qualify_BaseProduct_Inflation;
import cdm.product.qualification.functions.Qualify_ForeignExchange_NDS;
import cdm.product.qualification.functions.Qualify_ForeignExchange_Swap;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.GetDSBRecord;
import drr.regulation.common.functions.GetInstrumentType;
import drr.regulation.common.functions.ProductForEvent;
import drr.standards.iosco.upi.AnnaDsbDeliveryTypeEnum;
import drr.standards.iosco.upi.AnnaDsbInstrumentTypeEnum;
import drr.standards.iosco.upi.AnnaDsbUseCaseEnum;
import javax.inject.Inject;

@ImplementedBy(value=GetDeliveryTypeDSBRecordDefault.class)
public abstract class GetDeliveryTypeDSBRecord
implements RosettaFunction {
    @Inject
    protected GetDSBRecord getDSBRecord;
    @Inject
    protected GetInstrumentType getInstrumentType;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected Qualify_AssetClass_Credit qualify_AssetClass_Credit;
    @Inject
    protected Qualify_BaseProduct_CrossCurrency qualify_BaseProduct_CrossCurrency;
    @Inject
    protected Qualify_BaseProduct_IRSwap qualify_BaseProduct_IRSwap;
    @Inject
    protected Qualify_BaseProduct_Inflation qualify_BaseProduct_Inflation;
    @Inject
    protected Qualify_ForeignExchange_NDS qualify_ForeignExchange_NDS;
    @Inject
    protected Qualify_ForeignExchange_Swap qualify_ForeignExchange_Swap;

    public AnnaDsbDeliveryTypeEnum evaluate(ReportableEvent reportableEvent) {
        AnnaDsbDeliveryTypeEnum deliveryType = this.doEvaluate(reportableEvent);
        return deliveryType;
    }

    protected abstract AnnaDsbDeliveryTypeEnum doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends Product> product(ReportableEvent var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(ReportableEvent var1);

    protected abstract MapperS<AnnaDsbInstrumentTypeEnum> instrumentType(ReportableEvent var1);

    protected abstract MapperS<AnnaDsbUseCaseEnum> useCase(ReportableEvent var1);

    protected abstract MapperS<? extends FieldWithMetaString> isdaTaxonomy(ReportableEvent var1);

    protected abstract MapperS<? extends SettlementTerms> settlementTerms(ReportableEvent var1);

    public static class GetDeliveryTypeDSBRecordDefault
    extends GetDeliveryTypeDSBRecord {
        @Override
        protected AnnaDsbDeliveryTypeEnum doEvaluate(ReportableEvent reportableEvent) {
            AnnaDsbDeliveryTypeEnum deliveryType = null;
            return this.assignOutput(deliveryType, reportableEvent);
        }

        protected AnnaDsbDeliveryTypeEnum assignOutput(AnnaDsbDeliveryTypeEnum deliveryType, ReportableEvent reportableEvent) {
            Boolean boolean2;
            Boolean boolean1;
            Boolean boolean0;
            deliveryType = ExpressionOperatorsNullSafe.areEqual(this.useCase(reportableEvent), (Mapper)MapperS.of((Object)((Object)AnnaDsbUseCaseEnum.NDF)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual(this.useCase(reportableEvent), (Mapper)MapperS.of((Object)((Object)AnnaDsbUseCaseEnum.NDO)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? null : ((boolean0 = this.qualify_ForeignExchange_NDS.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())) != null && boolean0 != false ? AnnaDsbDeliveryTypeEnum.CASH : ((boolean1 = this.qualify_ForeignExchange_Swap.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())) != null && boolean1 != false ? AnnaDsbDeliveryTypeEnum.PHYS : (ExpressionOperatorsNullSafe.areEqual((Mapper)this.settlementTerms(reportableEvent).map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.CASH : (ExpressionOperatorsNullSafe.areEqual((Mapper)this.settlementTerms(reportableEvent).map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.CASH_OR_PHYSICAL), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.OPTL : (ExpressionOperatorsNullSafe.areEqual((Mapper)this.settlementTerms(reportableEvent).map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.PHYSICAL), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.PHYS : (ExpressionOperatorsNullSafe.areEqual((Mapper)this.settlementTerms(reportableEvent).map("getSettlementType", _settlementTerms -> _settlementTerms.getSettlementType()), (Mapper)MapperS.of((Object)SettlementTypeEnum.ELECTION), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.OPTL : (ExpressionOperatorsNullSafe.notExists((Mapper)this.settlementTerms(reportableEvent).map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)this.settlementTerms(reportableEvent).mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.CASH : (ExpressionOperatorsNullSafe.exists((Mapper)this.settlementTerms(reportableEvent).map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)this.settlementTerms(reportableEvent).mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.OPTL : (ExpressionOperatorsNullSafe.exists((Mapper)this.settlementTerms(reportableEvent).map("getPhysicalSettlementTerms", _settlementTerms -> _settlementTerms.getPhysicalSettlementTerms())).andNullSafe(ExpressionOperatorsNullSafe.notExists((Mapper)this.settlementTerms(reportableEvent).mapC("getCashSettlementTerms", _settlementTerms -> _settlementTerms.getCashSettlementTerms()))).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.PHYS : (ExpressionOperatorsNullSafe.areEqual(this.instrumentType(reportableEvent), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.OPTION)), (CardinalityOperator)CardinalityOperator.All).orNullSafe(ExpressionOperatorsNullSafe.areEqual(this.instrumentType(reportableEvent), (Mapper)MapperS.of((Object)((Object)AnnaDsbInstrumentTypeEnum.FORWARD)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.PHYS : (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_BaseProduct_IRSwap.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_BaseProduct_CrossCurrency.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_BaseProduct_Inflation.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)) != false ? AnnaDsbDeliveryTypeEnum.PHYS : ((boolean2 = this.qualify_AssetClass_Credit.evaluate((EconomicTerms)this.economicTerms(reportableEvent).get())) != null && boolean2 != false ? AnnaDsbDeliveryTypeEnum.OPTL : AnnaDsbDeliveryTypeEnum.CASH))))))))))));
            return deliveryType;
        }

        @Override
        protected MapperS<? extends Product> product(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(ReportableEvent reportableEvent) {
            return this.product(reportableEvent).map("getContractualProduct", _product -> _product.getContractualProduct()).map("getEconomicTerms", contractualProduct -> contractualProduct.getEconomicTerms());
        }

        @Override
        protected MapperS<AnnaDsbInstrumentTypeEnum> instrumentType(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((Object)this.getInstrumentType.evaluate(reportableEvent)));
        }

        @Override
        protected MapperS<AnnaDsbUseCaseEnum> useCase(ReportableEvent reportableEvent) {
            return MapperS.of((Object)((Object)this.getDSBRecord.evaluate(reportableEvent)));
        }

        @Override
        protected MapperS<? extends FieldWithMetaString> isdaTaxonomy(ReportableEvent reportableEvent) {
            MapperC thenArg0 = this.product(reportableEvent).map("getContractualProduct", _product -> _product.getContractualProduct()).mapC("getProductTaxonomy", contractualProduct -> contractualProduct.getProductTaxonomy()).filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getSource", productTaxonomy -> productTaxonomy.getSource()), (Mapper)MapperS.of((Object)TaxonomySourceEnum.ISDA), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.exists((Mapper)item.map("getValue", productTaxonomy -> productTaxonomy.getValue()).map("getName", taxonomyValue -> taxonomyValue.getName()))).get());
            MapperS thenArg1 = thenArg0.first();
            return thenArg1.map("getValue", productTaxonomy -> productTaxonomy.getValue()).map("getName", taxonomyValue -> taxonomyValue.getName());
        }

        @Override
        protected MapperS<? extends SettlementTerms> settlementTerms(ReportableEvent reportableEvent) {
            return MapperC.of((MapperBuilder[])new MapperBuilder[]{this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getSettlementTerms", forwardPayout -> forwardPayout.getSettlementTerms()), this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getSettlementTerms", optionPayout -> optionPayout.getSettlementTerms()), this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getInterestRatePayout", payout -> payout.getInterestRatePayout()).map("getSettlementTerms", interestRatePayout -> interestRatePayout.getSettlementTerms()), this.economicTerms(reportableEvent).map("getPayout", _economicTerms -> _economicTerms.getPayout()).map("getCreditDefaultPayout", payout -> payout.getCreditDefaultPayout()).map("getSettlementTerms", creditDefaultPayout -> creditDefaultPayout.getSettlementTerms())}).first();
        }
    }
}

