/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.common.settlement.ResolvablePriceQuantity;
import cdm.product.qualification.functions.Qualify_Commodity_Forward;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.ForwardPayout;
import cdm.product.template.Product;
import cdm.product.template.TradableProduct;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.CommodityLeg2;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.FXLeg2;
import drr.regulation.common.functions.FXSwapLeg2;
import drr.regulation.common.functions.InterestRateLeg2;
import drr.regulation.common.functions.IsCommoditySwap;
import drr.regulation.common.functions.IsEquitySwap;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFXSwap;
import drr.regulation.common.functions.IsGenericIRS;
import drr.regulation.common.functions.IsIRSwaption;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.UnderlierForProduct;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=GetLeg2ResolvablePriceQuantityDefault.class)
public abstract class GetLeg2ResolvablePriceQuantity
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected CommodityLeg2 commodityLeg2;
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected FXLeg2 fXLeg2;
    @Inject
    protected FXSwapLeg2 fXSwapLeg2;
    @Inject
    protected InterestRateLeg2 interestRateLeg2;
    @Inject
    protected IsCommoditySwap isCommoditySwap;
    @Inject
    protected IsEquitySwap isEquitySwap;
    @Inject
    protected IsFXForward isFXForward;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected IsFXSwap isFXSwap;
    @Inject
    protected IsGenericIRS isGenericIRS;
    @Inject
    protected IsIRSwaption isIRSwaption;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Forward qualify_Commodity_Forward;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public ResolvablePriceQuantity evaluate(Trade trade) {
        ResolvablePriceQuantity priceQuantity;
        ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantityBuilder = this.doEvaluate(trade);
        if (priceQuantityBuilder == null) {
            priceQuantity = null;
        } else {
            priceQuantity = priceQuantityBuilder.build();
            this.objectValidator.validate(ResolvablePriceQuantity.class, (RosettaModelObject)priceQuantity);
        }
        return priceQuantity;
    }

    protected abstract ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade var1);

    protected abstract MapperS<? extends Product> product(Trade var1);

    public static class GetLeg2ResolvablePriceQuantityDefault
    extends GetLeg2ResolvablePriceQuantity {
        @Override
        protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder doEvaluate(Trade trade) {
            ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity = ResolvablePriceQuantity.builder();
            return this.assignOutput(priceQuantity, trade);
        }

        protected ResolvablePriceQuantity.ResolvablePriceQuantityBuilder assignOutput(ResolvablePriceQuantity.ResolvablePriceQuantityBuilder priceQuantity, Trade trade) {
            Boolean boolean0 = this.isIRSwaption.evaluate((Product)this.product(trade).get());
            if (boolean0 != null && boolean0.booleanValue()) {
                MapperS thenArg = MapperS.of((Object)this.interestRateLeg2.evaluate(this.underlierForProduct.evaluate((Product)this.product(trade).get())));
                priceQuantity = (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)thenArg.mapSingleToItem(item -> item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get());
            } else {
                Boolean boolean6;
                Boolean boolean5;
                Boolean boolean4;
                Boolean boolean3;
                Boolean boolean2;
                Boolean boolean1;
                priceQuantity = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isGenericIRS.evaluate((Product)this.product(trade).get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isEquitySwap.evaluate((TradableProduct)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).get())))).getOrDefault(Boolean.valueOf(false)) != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.interestRateLeg2.evaluate((Product)this.product(trade).get())).mapSingleToItem(item -> item.map("getPriceQuantity", interestRatePayout -> interestRatePayout.getPriceQuantity())).get()) : ((boolean1 = this.isFXForward.evaluate((Product)this.product(trade).get())) != null && boolean1 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fXLeg2.evaluate((Product)this.product(trade).get())).mapSingleToItem(item -> item.map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get()) : ((boolean2 = this.isFXOption.evaluate((Product)this.product(trade).get())) != null && boolean2 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fXLeg2.evaluate((Product)this.product(trade).get())).mapSingleToItem(item -> item.map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity())).get()) : ((boolean3 = this.isFXSwap.evaluate((Product)this.product(trade).get())) != null && boolean3 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.fXSwapLeg2.evaluate((Product)this.product(trade).get())).map("getPriceQuantity", cashflow -> cashflow.getPriceQuantity()).get()) : ((boolean4 = this.isCommoditySwap.evaluate((Product)this.product(trade).get())) != null && boolean4 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.commodityLeg2.evaluate((Product)this.product(trade).get())).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get()) : ((boolean5 = this.qualify_Commodity_Swaption.evaluate(this.economicTermsForProduct.evaluate((Product)this.product(trade).get()))) != null && boolean5 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)this.commodityLeg2.evaluate(this.underlierForProduct.evaluate((Product)this.product(trade).get()))).map("getPriceQuantity", commodityPayout -> commodityPayout.getPriceQuantity()).get()) : ((boolean6 = this.qualify_Commodity_Forward.evaluate(this.economicTermsForProduct.evaluate((Product)this.product(trade).get()))) != null && boolean6 != false ? (ResolvablePriceQuantity.ResolvablePriceQuantityBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)((ForwardPayout)MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)this.product(trade).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).get())).map("getPriceQuantity", forwardPayout -> forwardPayout.getPriceQuantity()).get()) : null))))));
            }
            return Optional.ofNullable(priceQuantity).map(o -> o.prune()).orElse(null);
        }

        @Override
        protected MapperS<? extends Product> product(Trade trade) {
            return MapperS.of((Object)this.productForTrade.evaluate(trade));
        }
    }
}

