/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.IsFXForward;
import drr.regulation.common.functions.IsFXOption;
import drr.regulation.common.functions.IsFXSwap;
import javax.inject.Inject;

@ImplementedBy(value=IsFXProductDefault.class)
public abstract class IsFXProduct
implements RosettaFunction {
    @Inject
    protected IsFXForward isFXForward;
    @Inject
    protected IsFXOption isFXOption;
    @Inject
    protected IsFXSwap isFXSwap;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    public static class IsFXProductDefault
    extends IsFXProduct {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXForward.evaluate(product))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXOption.evaluate(product)))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isFXSwap.evaluate(product)))).get();
            return result;
        }
    }
}

