/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.functions.EconomicTermsForProduct;
import java.util.Arrays;
import javax.inject.Inject;

@ImplementedBy(value=IsSingleCommodityPayoutProductDefault.class)
public abstract class IsSingleCommodityPayoutProduct
implements RosettaFunction {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;

    public Boolean evaluate(Product product) {
        Boolean result = this.doEvaluate(product);
        return result;
    }

    protected abstract Boolean doEvaluate(Product var1);

    protected abstract MapperS<? extends EconomicTerms> economicTerms(Product var1);

    public static class IsSingleCommodityPayoutProductDefault
    extends IsSingleCommodityPayoutProduct {
        @Override
        protected Boolean doEvaluate(Product product) {
            Boolean result = null;
            return this.assignOutput(result, product);
        }

        protected Boolean assignOutput(Boolean result, Product product) {
            result = ExpressionOperatorsNullSafe.onlyExists((Mapper)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()), Arrays.asList("interestRatePayout", "creditDefaultPayout", "optionPayout", "commodityPayout", "forwardPayout", "fixedPricePayout", "securityPayout", "cashflow", "performancePayout", "assetPayout"), Arrays.asList("commodityPayout")).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)this.economicTerms(product).map("getPayout", _economicTerms -> _economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).resultCount()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All)).get();
            return result;
        }

        @Override
        protected MapperS<? extends EconomicTerms> economicTerms(Product product) {
            return MapperS.of((Object)this.economicTermsForProduct.evaluate(product));
        }
    }
}

