/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.functions;

import cdm.event.common.Trade;
import cdm.product.template.TradeLot;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.MapperS;
import java.util.Optional;
import javax.inject.Inject;

@ImplementedBy(value=SingleTradeLotDefault.class)
public abstract class SingleTradeLot
implements RosettaFunction {
    @Inject
    protected ModelObjectValidator objectValidator;

    public TradeLot evaluate(Trade trade) {
        TradeLot singleTradeLot;
        TradeLot.TradeLotBuilder singleTradeLotBuilder = this.doEvaluate(trade);
        if (singleTradeLotBuilder == null) {
            singleTradeLot = null;
        } else {
            singleTradeLot = singleTradeLotBuilder.build();
            this.objectValidator.validate(TradeLot.class, (RosettaModelObject)singleTradeLot);
        }
        return singleTradeLot;
    }

    protected abstract TradeLot.TradeLotBuilder doEvaluate(Trade var1);

    public static class SingleTradeLotDefault
    extends SingleTradeLot {
        @Override
        protected TradeLot.TradeLotBuilder doEvaluate(Trade trade) {
            TradeLot.TradeLotBuilder singleTradeLot = TradeLot.builder();
            return this.assignOutput(singleTradeLot, trade);
        }

        protected TradeLot.TradeLotBuilder assignOutput(TradeLot.TradeLotBuilder singleTradeLot, Trade trade) {
            singleTradeLot = (TradeLot.TradeLotBuilder)this.toBuilder((RosettaModelObject)MapperS.of((Object)trade).map("getTradableProduct", _trade -> _trade.getTradableProduct()).mapC("getTradeLot", tradableProduct -> tradableProduct.getTradeLot()).get());
            return Optional.ofNullable(singleTradeLot).map(o -> o.prune()).orElse(null);
        }
    }
}

