/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.trade.basket.reports;

import cdm.base.staticdata.asset.common.ProductIdTypeEnum;
import cdm.product.template.BasketConstituent;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.functions.GetProductIdentifierFilteringISIN;
import javax.inject.Inject;

@ImplementedBy(value=BasketConstituentIdentifierSourceRuleDefault.class)
public abstract class BasketConstituentIdentifierSourceRule
implements ReportFunction<BasketConstituent, ProductIdTypeEnum> {
    @Inject
    protected GetProductIdentifierFilteringISIN getProductIdentifierFilteringISIN;

    public ProductIdTypeEnum evaluate(BasketConstituent input) {
        ProductIdTypeEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract ProductIdTypeEnum doEvaluate(BasketConstituent var1);

    public static class BasketConstituentIdentifierSourceRuleDefault
    extends BasketConstituentIdentifierSourceRule {
        @Override
        protected ProductIdTypeEnum doEvaluate(BasketConstituent input) {
            ProductIdTypeEnum output = null;
            return this.assignOutput(output, input);
        }

        protected ProductIdTypeEnum assignOutput(ProductIdTypeEnum output, BasketConstituent input) {
            MapperC thenArg = ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)input).map("getSecurity", basketConstituent -> basketConstituent.getSecurity())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)input).map("getSecurity", basketConstituent -> basketConstituent.getSecurity()).mapC("getProductIdentifier", security -> security.getProductIdentifier()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)input).map("getLoan", basketConstituent -> basketConstituent.getLoan())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)input).map("getLoan", basketConstituent -> basketConstituent.getLoan()).mapC("getProductIdentifier", loan -> loan.getProductIdentifier()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)input).map("getCommodity", basketConstituent -> basketConstituent.getCommodity())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)input).map("getCommodity", basketConstituent -> basketConstituent.getCommodity()).map("Type coercion", referenceWithMetaCommodity -> referenceWithMetaCommodity == null ? null : referenceWithMetaCommodity.getValue()).mapC("getProductIdentifier", commodity -> commodity.getProductIdentifier()) : (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)input).map("getIndex", basketConstituent -> basketConstituent.getIndex())).getOrDefault(Boolean.valueOf(false)) != false ? MapperS.of((Object)input).map("getIndex", basketConstituent -> basketConstituent.getIndex()).mapC("getProductIdentifier", index -> index.getProductIdentifier()) : MapperC.ofNull())));
            output = (ProductIdTypeEnum)MapperS.of((Object)this.getProductIdentifierFilteringISIN.evaluate(thenArg.map("Type coercion", referenceWithMetaProductIdentifier -> referenceWithMetaProductIdentifier.getValue()).getMulti())).map("getSource", productIdentifier -> productIdentifier.getSource()).get();
            return output;
        }
    }
}

