/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.common.validation.exists;

import com.google.common.collect.ImmutableMap;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ExistenceChecker;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.ValidatorWithArg;
import drr.regulation.common.ASICPartyInformation;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

public class ASICPartyInformationOnlyExistsValidator
implements ValidatorWithArg<ASICPartyInformation, Set<String>> {
    public <T2 extends ASICPartyInformation> ValidationResult<ASICPartyInformation> validate(RosettaPath path, T2 o, Set<String> fields) {
        ImmutableMap fieldExistenceMap = ImmutableMap.builder().put((Object)"nonReportedTradePortfolio", (Object)ExistenceChecker.isSet((Object)o.getNonReportedTradePortfolio())).put((Object)"smallScaleBuySideIndicator", (Object)ExistenceChecker.isSet((Object)o.getSmallScaleBuySideIndicator())).build();
        Set setFields = fieldExistenceMap.entrySet().stream().filter(Map.Entry::getValue).map(Map.Entry::getKey).collect(Collectors.toSet());
        if (setFields.equals(fields)) {
            return ValidationResult.success((String)"ASICPartyInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ASICPartyInformation", (RosettaPath)path, (String)"");
        }
        return ValidationResult.failure((String)"ASICPartyInformation", (ValidationResult.ValidationType)ValidationResult.ValidationType.ONLY_EXISTS, (String)"ASICPartyInformation", (RosettaPath)path, (String)"", (String)String.format("[%s] should only be set.  Set fields: %s", fields, setFields));
    }
}

