/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.functions;

import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.functions.IsCreditSwaption;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.common.functions.UnderlierForProduct;
import drr.regulation.csa.rewrite.functions.GetUnderlierIDForIndexCSA;
import javax.inject.Inject;

@ImplementedBy(value=IsUnderlierForIndexDefault.class)
public abstract class IsUnderlierForIndex
implements RosettaFunction {
    @Inject
    protected GetUnderlierIDForIndexCSA getUnderlierIDForIndexCSA;
    @Inject
    protected IsCreditSwaption isCreditSwaption;
    @Inject
    protected ProductForEvent productForEvent;
    @Inject
    protected UnderlierForProduct underlierForProduct;

    public Boolean evaluate(ReportableEvent reportableEvent) {
        Boolean result = this.doEvaluate(reportableEvent);
        return result;
    }

    protected abstract Boolean doEvaluate(ReportableEvent var1);

    public static class IsUnderlierForIndexDefault
    extends IsUnderlierForIndex {
        @Override
        protected Boolean doEvaluate(ReportableEvent reportableEvent) {
            Boolean result = null;
            return this.assignOutput(result, reportableEvent);
        }

        protected Boolean assignOutput(Boolean result, ReportableEvent reportableEvent) {
            MapperS thenArg0 = MapperS.of((Object)this.productForEvent.evaluate(reportableEvent));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> {
                Boolean _boolean = this.isCreditSwaption.evaluate((Product)item.get());
                if (_boolean != null && _boolean.booleanValue()) {
                    return MapperS.of((Object)this.underlierForProduct.evaluate((Product)item.get()));
                }
                return item;
            });
            result = (Boolean)thenArg1.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperC.of(this.getUnderlierIDForIndexCSA.evaluate((Product)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)true);
                }
                return MapperS.of((Object)false);
            }).get();
            return result;
        }
    }
}

