/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation;

import com.google.common.base.Strings;
import com.google.common.collect.Lists;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSALeg;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class CSALegTypeFormatValidator
implements Validator<CSALeg> {
    private List<ComparisonResult> getComparisonResults(CSALeg o) {
        return Lists.newArrayList((Object[])new ComparisonResult[]{ExpressionOperatorsNullSafe.checkNumber((String)"notionalAmount", (BigDecimal)o.getNotionalAmount(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"totalNotionalQuantity", (BigDecimal)o.getTotalNotionalQuantity(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"fixedRate", (BigDecimal)o.getFixedRate(), Optional.of(11), Optional.of(10), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"quantityUnitOfMeasure", (String)o.getQuantityUnitOfMeasure(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"notionalQuantity", (BigDecimal)o.getNotionalQuantity(), Optional.of(25), Optional.of(5), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkNumber((String)"quantityFrequencyMultiplier", (Integer)o.getQuantityFrequencyMultiplier(), Optional.of(3), Optional.of(0), Optional.empty(), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"payerIdentifier", (String)o.getPayerIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"receiverIdentifier", (String)o.getReceiverIdentifier(), (int)20, Optional.of(72), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,72}"))), ExpressionOperatorsNullSafe.checkString((String)"underlierIDOther", (String)o.getUnderlierIDOther(), (int)1, Optional.of(350), Optional.of(Pattern.compile(".{1,350}"))), ExpressionOperatorsNullSafe.checkString((String)"underlierIDOtherSource", (String)o.getUnderlierIDOtherSource(), (int)1, Optional.of(350), Optional.of(Pattern.compile("[a-zA-Z0-9 \\:.\\-_]{1,350}"))), ExpressionOperatorsNullSafe.checkString((String)"underlyingAssetTradingPlatformIdentifier", (String)o.getUnderlyingAssetTradingPlatformIdentifier(), (int)1, Optional.of(4), Optional.empty()), ExpressionOperatorsNullSafe.checkString((String)"underlyingAssetPriceSource", (String)o.getUnderlyingAssetPriceSource(), (int)1, Optional.of(50), Optional.of(Pattern.compile("[a-zA-Z0-9]{1,50}")))});
    }

    public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSALeg o) {
        return this.getComparisonResults(o).stream().map(res -> {
            if (!Strings.isNullOrEmpty((String)res.getError())) {
                return ValidationResult.failure((String)"CSALeg", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CSALeg", (RosettaPath)path, (String)"", (String)res.getError());
            }
            return ValidationResult.success((String)"CSALeg", (ValidationResult.ValidationType)ValidationResult.ValidationType.TYPE_FORMAT, (String)"CSALeg", (RosettaPath)path, (String)"");
        }).collect(Collectors.toList());
    }
}

