/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.csa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.csa.rewrite.trade.CSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.EventTypeEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="CSATransactionReportDTCC_CSA_VR_0076_01")
@ImplementedBy(value=Default.class)
public interface CSATransactionReportDTCC_CSA_VR_0076_01
extends Validator<CSATransactionReport> {
    public static final String NAME = "CSATransactionReportDTCC_CSA_VR_0076_01";
    public static final String DEFINITION = "if dtccAdditionalFields -> messageTypeTransaction exists then (if (actionType = NEWT and [EventTypeEnum -> CLRG, EventTypeEnum -> CLAL] any = eventType) or (actionType = TERM and [EventTypeEnum -> CLRG, EventTypeEnum -> CLAL] any = eventType) then clearingReceiptTimestamp exists)";

    public static class NoOp
    implements CSATransactionReportDTCC_CSA_VR_0076_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements CSATransactionReportDTCC_CSA_VR_0076_01 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, CSATransactionReport cSATransactionReport) {
            ComparisonResult result = this.executeDataRule(cSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)CSATransactionReportDTCC_CSA_VR_0076_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0076_01.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)CSATransactionReportDTCC_CSA_VR_0076_01.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"CSATransactionReport", (RosettaPath)path, (String)CSATransactionReportDTCC_CSA_VR_0076_01.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(CSATransactionReport cSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getDtccAdditionalFields", _cSATransactionReport -> _cSATransactionReport.getDtccAdditionalFields()).map("getMessageTypeTransaction", dTCCAdditionalFields -> dTCCAdditionalFields.getMessageTypeTransaction())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getActionType", _cSATransactionReport -> _cSATransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.CLRG)), MapperS.of((Object)((Object)EventTypeEnum.CLAL))}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getEventType", _cSATransactionReport -> _cSATransactionReport.getEventType()), (CardinalityOperator)CardinalityOperator.Any)).orNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)cSATransactionReport).map("getActionType", _cSATransactionReport -> _cSATransactionReport.getActionType()), (Mapper)MapperS.of((Object)((Object)ActionTypeEnum.TERM)), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)EventTypeEnum.CLRG)), MapperS.of((Object)((Object)EventTypeEnum.CLAL))}), (Mapper)MapperS.of((Object)cSATransactionReport).map("getEventType", _cSATransactionReport -> _cSATransactionReport.getEventType()), (CardinalityOperator)CardinalityOperator.Any))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)cSATransactionReport).map("getClearingReceiptTimestamp", _cSATransactionReport -> _cSATransactionReport.getClearingReceiptTimestamp()));
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

