/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.esma.emir.refit.trade.reports;

import cdm.observable.asset.PriceSchedule;
import cdm.observable.asset.metafields.ReferenceWithMetaPriceSchedule;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.GetNameOfTheFloatingRateOfLeg2;
import drr.regulation.common.functions.IsAllowableAction;
import drr.standards.iosco.cde.base.price.PriceNotationEnum;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2NotationEnumRule;
import drr.standards.iosco.cde.version3.price.reports.SpreadLeg2Rule;
import javax.inject.Inject;

@ImplementedBy(value=SpreadOfLeg2NotationRuleDefault.class)
public abstract class SpreadOfLeg2NotationRule
implements ReportFunction<TransactionReportInstruction, PriceNotationEnum> {
    @Inject
    protected GetNameOfTheFloatingRateOfLeg2 getNameOfTheFloatingRateOfLeg2;
    @Inject
    protected IsAllowableAction isAllowableAction;
    @Inject
    protected SpreadLeg2NotationEnumRule spreadLeg2NotationEnumRule;
    @Inject
    protected SpreadLeg2Rule spreadLeg2Rule;

    public PriceNotationEnum evaluate(TransactionReportInstruction input) {
        PriceNotationEnum output = this.doEvaluate(input);
        return output;
    }

    protected abstract PriceNotationEnum doEvaluate(TransactionReportInstruction var1);

    public static class SpreadOfLeg2NotationRuleDefault
    extends SpreadOfLeg2NotationRule {
        @Override
        protected PriceNotationEnum doEvaluate(TransactionReportInstruction input) {
            PriceNotationEnum output = null;
            return this.assignOutput(output, input);
        }

        protected PriceNotationEnum assignOutput(PriceNotationEnum output, TransactionReportInstruction input) {
            MapperS thenArg = MapperS.of((Object)input).filterSingleNullSafe(item -> this.isAllowableAction.evaluate((ReportableEvent)item.get()));
            output = (PriceNotationEnum)((Object)thenArg.mapSingleToItem(item -> {
                PriceSchedule priceSchedule = this.spreadLeg2Rule.evaluate((TransactionReportInstruction)item.get());
                if ((priceSchedule == null ? ExpressionOperatorsNullSafe.exists((Mapper)MapperS.ofNull()).getOrDefault(Boolean.valueOf(false)) : ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)ReferenceWithMetaPriceSchedule.builder().setValue(priceSchedule).build())).getOrDefault(Boolean.valueOf(false))).booleanValue()) {
                    return MapperS.of((Object)((Object)this.spreadLeg2NotationEnumRule.evaluate((TransactionReportInstruction)item.get())));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)this.getNameOfTheFloatingRateOfLeg2.evaluate((ReportableEvent)item.get()))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((Object)PriceNotationEnum.BASIS));
                }
                return MapperS.ofNull();
            }).get());
            return output;
        }
    }
}

