/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.functions;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.functions.RosettaFunction;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import drr.regulation.common.RegimeNameEnum;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.ReportableInformation;
import drr.regulation.common.SupervisoryBodyEnum;
import drr.regulation.common.TradableOnTradingVenueEnum;
import drr.regulation.common.TransactionInformation;
import drr.regulation.common.functions.GetExecutionTimestamp;
import drr.regulation.common.functions.GetIsin;
import drr.regulation.common.functions.GetTransactionInformationForRegime;
import drr.regulation.common.functions.ProductForEvent;
import drr.regulation.fca.ukemir.refit.trade.functions.GetMicDataForFacility;
import drr.regulation.fca.ukemir.refit.trade.functions.IsSI;
import drr.regulation.fca.ukemir.refit.trade.functions.IsUKEmirTradingVenue;
import drr.standards.iso.MicData;
import drr.standards.iso.MicTypeEnum;
import java.time.LocalDate;
import javax.inject.Inject;

@ImplementedBy(value=UKEMIR_ISINDefault.class)
public abstract class UKEMIR_ISIN
implements RosettaFunction {
    @Inject
    protected GetExecutionTimestamp getExecutionTimestamp;
    @Inject
    protected GetIsin getIsin;
    @Inject
    protected GetMicDataForFacility getMicDataForFacility;
    @Inject
    protected GetTransactionInformationForRegime getTransactionInformationForRegime;
    @Inject
    protected IsSI isSI;
    @Inject
    protected IsUKEmirTradingVenue isUKEmirTradingVenue;
    @Inject
    protected ProductForEvent productForEvent;

    public String evaluate(ReportableEvent reportableEvent) {
        String isin = this.doEvaluate(reportableEvent);
        return isin;
    }

    protected abstract String doEvaluate(ReportableEvent var1);

    protected abstract MapperS<? extends MicData> micDataForFacility(ReportableEvent var1);

    protected abstract MapperS<String> venueMic(ReportableEvent var1);

    protected abstract MapperS<String> productIsin(ReportableEvent var1);

    protected abstract MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent var1);

    protected abstract MapperS<Boolean> isinTotv(ReportableEvent var1);

    public static class UKEMIR_ISINDefault
    extends UKEMIR_ISIN {
        @Override
        protected String doEvaluate(ReportableEvent reportableEvent) {
            String isin = null;
            return this.assignOutput(isin, reportableEvent);
        }

        protected String assignOutput(String isin, ReportableEvent reportableEvent) {
            isin = ExpressionOperatorsNullSafe.exists(this.venueMic(reportableEvent)).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (ExpressionOperatorsNullSafe.exists(this.productIsin(reportableEvent)).andNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isUKEmirTradingVenue.evaluate((MicData)this.micDataForFacility(reportableEvent).get())))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (String)this.productIsin(reportableEvent).get() : (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.isSI.evaluate((MicData)this.micDataForFacility(reportableEvent).get()))).andNullSafe(ComparisonResult.ofNullSafe(this.isinTotv(reportableEvent))).getOrDefault(Boolean.valueOf(false)).booleanValue() ? (String)this.productIsin(reportableEvent).get() : null)) : (ExpressionOperatorsNullSafe.exists(this.productIsin(reportableEvent)).andNullSafe(ComparisonResult.ofNullSafe(this.isinTotv(reportableEvent))).getOrDefault(Boolean.valueOf(false)) != false ? (String)this.productIsin(reportableEvent).get() : null);
            return isin;
        }

        @Override
        protected MapperS<? extends MicData> micDataForFacility(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.getMicDataForFacility.evaluate((ReportableInformation)MapperS.of((Object)reportableEvent).map("getReportableInformation", _reportableEvent -> _reportableEvent.getReportableInformation()).get()));
        }

        @Override
        protected MapperS<String> venueMic(ReportableEvent reportableEvent) {
            MapperS<? extends MicData> thenArg = this.micDataForFacility(reportableEvent);
            return thenArg.mapSingleToItem(item -> {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)item.map("getExpiryDate", micData -> micData.getExpiryDate()), (Mapper)MapperS.of((Object)this.getExecutionTimestamp.evaluate(reportableEvent)).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (CardinalityOperator)CardinalityOperator.All)).orNullSafe(ExpressionOperatorsNullSafe.notEqual((Mapper)item.map("getStatus", micData -> micData.getStatus()), (Mapper)MapperS.of((Object)"EXPIRED"), (CardinalityOperator)CardinalityOperator.Any)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getMicType", micData -> micData.getMicType()), (Mapper)MapperS.of((Object)((Object)MicTypeEnum.SGMT)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return item.map("getMic", micData -> micData.getMic());
                    }
                    return item.map("getOperatingMic", micData -> micData.getOperatingMic());
                }
                return MapperS.ofNull();
            });
        }

        @Override
        protected MapperS<String> productIsin(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.getIsin.evaluate(this.productForEvent.evaluate(reportableEvent)));
        }

        @Override
        protected MapperS<? extends TransactionInformation> transactionInformation(ReportableEvent reportableEvent) {
            return MapperS.of((Object)this.getTransactionInformationForRegime.evaluate(reportableEvent, RegimeNameEnum.UKEMIR, SupervisoryBodyEnum.FCA));
        }

        @Override
        protected MapperS<Boolean> isinTotv(ReportableEvent reportableEvent) {
            return MapperS.of((Object)ExpressionOperatorsNullSafe.areEqual((Mapper)this.transactionInformation(reportableEvent).map("getFcaTransactionInformation", _transactionInformation -> _transactionInformation.getFcaTransactionInformation()).map("getTradableOnTradingVenue", commonTransactionInformation -> commonTransactionInformation.getTradableOnTradingVenue()), (Mapper)MapperS.of((Object)((Object)TradableOnTradingVenueEnum.ADMITTED)), (CardinalityOperator)CardinalityOperator.All).getOrDefault(Boolean.valueOf(false)));
        }
    }
}

