/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.regulation.common.ReportableDelivery;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.FormatToLongFraction20DecimalNumber;
import drr.regulation.common.functions.GetReportableDelivery;
import drr.standards.iso.DurationType1Code;
import drr.standards.iso.EnergyQuantityUnit2Code;
import java.math.BigDecimal;
import java.time.LocalTime;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;

@ImplementedBy(value=DeliveryRuleDefault.class)
public abstract class DeliveryRule
implements ReportFunction<TransactionReportInstruction, List<? extends ReportableDelivery>> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected FormatToLongFraction20DecimalNumber formatToLongFraction20DecimalNumber;
    @Inject
    protected GetReportableDelivery getReportableDelivery;

    public List<? extends ReportableDelivery> evaluate(TransactionReportInstruction input) {
        List output;
        List<ReportableDelivery.ReportableDeliveryBuilder> outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.stream().map(ReportableDelivery::build).collect(Collectors.toList());
            this.objectValidator.validate(ReportableDelivery.class, output);
        }
        return output;
    }

    protected abstract List<ReportableDelivery.ReportableDeliveryBuilder> doEvaluate(TransactionReportInstruction var1);

    public static class DeliveryRuleDefault
    extends DeliveryRule {
        @Override
        protected List<ReportableDelivery.ReportableDeliveryBuilder> doEvaluate(TransactionReportInstruction input) {
            ArrayList<ReportableDelivery.ReportableDeliveryBuilder> output = new ArrayList<ReportableDelivery.ReportableDeliveryBuilder>();
            return this.assignOutput(output, input);
        }

        protected List<ReportableDelivery.ReportableDeliveryBuilder> assignOutput(List<ReportableDelivery.ReportableDeliveryBuilder> output, TransactionReportInstruction input) {
            MapperC thenArg = MapperS.of((Object)input).mapSingleToList(item -> MapperC.of(this.getReportableDelivery.evaluate((ReportableEvent)item.get())));
            output = this.toBuilder(thenArg.mapItem(item -> {
                MapperS thenArg0 = item.map("getDeliveryCapacity", reportableDelivery -> reportableDelivery.getDeliveryCapacity());
                MapperS thenArg1 = item.map("getPriceTimeIntervalQuantity", reportableDelivery -> reportableDelivery.getPriceTimeIntervalQuantity());
                return MapperS.of((Object)ReportableDelivery.builder().setDeliveryStartTime((LocalTime)item.map("getDeliveryStartTime", reportableDelivery -> reportableDelivery.getDeliveryStartTime()).get()).setDeliveryEndTime((LocalTime)item.map("getDeliveryEndTime", reportableDelivery -> reportableDelivery.getDeliveryEndTime()).get()).setDeliveryStartDate((Date)item.map("getDeliveryStartDate", reportableDelivery -> reportableDelivery.getDeliveryStartDate()).get()).setDeliveryEndDate((Date)item.map("getDeliveryEndDate", reportableDelivery -> reportableDelivery.getDeliveryEndDate()).get()).setDuration((DurationType1Code)((Object)((Object)item.map("getDuration", reportableDelivery -> reportableDelivery.getDuration()).get()))).setDaysOfTheWeek(item.mapC("getDaysOfTheWeek", reportableDelivery -> reportableDelivery.getDaysOfTheWeek()).getMulti()).setDeliveryCapacity((BigDecimal)MapperS.of((Object)this.formatToLongFraction20DecimalNumber.evaluate((BigDecimal)thenArg0.get())).get()).setQuantityUnit((EnergyQuantityUnit2Code)((Object)((Object)item.map("getQuantityUnit", reportableDelivery -> reportableDelivery.getQuantityUnit()).checkedMap("to-enum", e -> EnergyQuantityUnit2Code.valueOf(e.name()), IllegalArgumentException.class).get()))).setPriceTimeIntervalQuantity((BigDecimal)MapperS.of((Object)this.formatToLongFraction20DecimalNumber.evaluate((BigDecimal)thenArg1.get())).get()).setCurrencyOfThePriceTimeIntervalQuantity((String)item.map("getCurrencyOfThePriceTimeIntervalQuantity", reportableDelivery -> reportableDelivery.getCurrencyOfThePriceTimeIntervalQuantity()).get()).build());
            }).getMulti());
            return Optional.ofNullable(output).map(o -> o.stream().map(i -> i.prune()).collect(Collectors.toList())).orElse(null);
        }
    }
}

