/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.fca.ukemir.refit.trade.reports;

import cdm.base.staticdata.identifier.CommodityLocationIdentifierTypeEnum;
import cdm.base.staticdata.identifier.LocationIdentifier;
import cdm.event.common.Trade;
import cdm.product.asset.AssetDeliveryInformation;
import cdm.product.asset.CommodityPayout;
import cdm.product.qualification.functions.Qualify_Commodity_Option;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_Basis;
import cdm.product.qualification.functions.Qualify_Commodity_Swap_FixedFloat;
import cdm.product.qualification.functions.Qualify_Commodity_Swaption;
import cdm.product.template.EconomicTerms;
import cdm.product.template.Product;
import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.reports.ReportFunction;
import com.rosetta.model.metafields.FieldWithMetaString;
import drr.regulation.common.ReportableEvent;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.common.functions.EconomicTermsForProduct;
import drr.regulation.common.functions.ProductForTrade;
import drr.regulation.common.functions.TradeForEvent;
import javax.inject.Inject;

@ImplementedBy(value=InterconnectionPointRuleDefault.class)
public abstract class InterconnectionPointRule
implements ReportFunction<TransactionReportInstruction, String> {
    @Inject
    protected EconomicTermsForProduct economicTermsForProduct;
    @Inject
    protected ProductForTrade productForTrade;
    @Inject
    protected Qualify_Commodity_Option qualify_Commodity_Option;
    @Inject
    protected Qualify_Commodity_Swap_Basis qualify_Commodity_Swap_Basis;
    @Inject
    protected Qualify_Commodity_Swap_FixedFloat qualify_Commodity_Swap_FixedFloat;
    @Inject
    protected Qualify_Commodity_Swaption qualify_Commodity_Swaption;
    @Inject
    protected TradeForEvent tradeForEvent;

    public String evaluate(TransactionReportInstruction input) {
        String output = this.doEvaluate(input);
        return output;
    }

    protected abstract String doEvaluate(TransactionReportInstruction var1);

    public static class InterconnectionPointRuleDefault
    extends InterconnectionPointRule {
        @Override
        protected String doEvaluate(TransactionReportInstruction input) {
            String output = null;
            return this.assignOutput(output, input);
        }

        protected String assignOutput(String output, TransactionReportInstruction input) {
            MapperS thenArg0 = MapperS.of((Object)input).mapSingleToItem(item -> MapperS.of((Object)this.tradeForEvent.evaluate((ReportableEvent)item.get())));
            MapperS thenArg1 = thenArg0.mapSingleToItem(item -> MapperS.of((Object)this.productForTrade.evaluate((Trade)item.get())));
            MapperS thenArg2 = thenArg1.mapSingleToItem(item -> MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.get())));
            MapperS thenArg3 = thenArg2.mapSingleToItem(item -> {
                if (ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_FixedFloat.evaluate((EconomicTerms)item.get()))).orNullSafe(ComparisonResult.ofNullSafe((Mapper)MapperS.of((Object)this.qualify_Commodity_Swap_Basis.evaluate((EconomicTerms)item.get())))).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getDelivery", commodityPayout -> commodityPayout.getDelivery()).first();
                }
                Boolean boolean0 = this.qualify_Commodity_Swaption.evaluate((EconomicTerms)item.get());
                if (boolean0 != null && boolean0.booleanValue()) {
                    return MapperS.of((Object)this.economicTermsForProduct.evaluate((Product)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getUnderlier", optionPayout -> optionPayout.getUnderlier()).get())).map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).map("getDelivery", commodityPayout -> commodityPayout.getDelivery()).first();
                }
                Boolean boolean1 = this.qualify_Commodity_Option.evaluate((EconomicTerms)item.get());
                if (boolean1 != null && boolean1.booleanValue()) {
                    return MapperS.of((Object)((AssetDeliveryInformation)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getOptionPayout", payout -> payout.getOptionPayout()).map("getDelivery", optionPayout -> optionPayout.getDelivery()).get()));
                }
                if (ExpressionOperatorsNullSafe.exists((Mapper)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getUnderlier", forwardPayout -> forwardPayout.getUnderlier()).map("getCommodity", product -> product.getCommodity())).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return MapperS.of((Object)((AssetDeliveryInformation)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getForwardPayout", payout -> payout.getForwardPayout()).map("getDelivery", forwardPayout -> forwardPayout.getDelivery()).get()));
                }
                return MapperS.of((Object)((CommodityPayout)item.map("getPayout", economicTerms -> economicTerms.getPayout()).mapC("getCommodityPayout", payout -> payout.getCommodityPayout()).get())).map("getDelivery", commodityPayout -> commodityPayout.getDelivery());
            });
            MapperC thenArg4 = thenArg3.mapSingleToList(item -> item.mapC("getLocation", assetDeliveryInformation -> assetDeliveryInformation.getLocation()));
            MapperC thenArg5 = thenArg4.filterItemNullSafe(item -> ExpressionOperatorsNullSafe.areEqual((Mapper)item.map("getLocationIdentifierType", locationIdentifier -> locationIdentifier.getLocationIdentifierType()), (Mapper)MapperS.of((Object)CommodityLocationIdentifierTypeEnum.INTERCONNECTION_POINT), (CardinalityOperator)CardinalityOperator.All).get());
            MapperS thenArg6 = MapperS.of((Object)((LocationIdentifier)thenArg5.get()));
            MapperC thenArg7 = thenArg6.mapSingleToList(item -> item.mapC("getAssignedIdentifier", locationIdentifier -> locationIdentifier.getAssignedIdentifier()).map("getIdentifier", assignedIdentifier -> assignedIdentifier.getIdentifier()));
            FieldWithMetaString fieldWithMetaString = (FieldWithMetaString)MapperS.of((Object)((FieldWithMetaString)thenArg7.get())).get();
            output = fieldWithMetaString == null ? null : fieldWithMetaString.getValue();
            return output;
        }
    }
}

