/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.hkma.rewrite.trade.HKMATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.FrequencyPeriodEnum;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="HKMATransactionReportDOC0031")
@ImplementedBy(value=Default.class)
public interface HKMATransactionReportDOC0031
extends Validator<HKMATransactionReport> {
    public static final String NAME = "HKMATransactionReportDOC0031";
    public static final String DEFINITION = "if [ActionTypeEnum -> NEWT, ActionTypeEnum -> MODI, ActionTypeEnum -> CORR, ActionTypeEnum -> REVI] any = actionType then if leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod exists and leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriod = FrequencyPeriodEnum -> EXPI then leg1 -> periodicPayment -> fixedRatePaymentFrequencyPeriodMultiplier = 1";

    public static class NoOp
    implements HKMATransactionReportDOC0031 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements HKMATransactionReportDOC0031 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, HKMATransactionReport hKMATransactionReport) {
            ComparisonResult result = this.executeDataRule(hKMATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)HKMATransactionReportDOC0031.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0031.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)HKMATransactionReportDOC0031.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"HKMATransactionReport", (RosettaPath)path, (String)HKMATransactionReportDOC0031.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(HKMATransactionReport hKMATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.NEWT)), MapperS.of((Object)((Object)ActionTypeEnum.MODI)), MapperS.of((Object)((Object)ActionTypeEnum.CORR)), MapperS.of((Object)((Object)ActionTypeEnum.REVI))}), (Mapper)MapperS.of((Object)hKMATransactionReport).map("getActionType", _hKMATransactionReport -> _hKMATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    if (ExpressionOperatorsNullSafe.exists((Mapper)MapperS.of((Object)hKMATransactionReport).map("getLeg1", _hKMATransactionReport -> _hKMATransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod())).andNullSafe(ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)hKMATransactionReport).map("getLeg1", _hKMATransactionReport -> _hKMATransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriod", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriod()), (Mapper)MapperS.of((Object)((Object)FrequencyPeriodEnum.EXPI)), (CardinalityOperator)CardinalityOperator.All)).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                        return ExpressionOperatorsNullSafe.areEqual((Mapper)MapperS.of((Object)hKMATransactionReport).map("getLeg1", _hKMATransactionReport -> _hKMATransactionReport.getLeg1()).map("getPeriodicPayment", commonLeg -> commonLeg.getPeriodicPayment()).map("getFixedRatePaymentFrequencyPeriodMultiplier", commonPeriodicPayment -> commonPeriodicPayment.getFixedRatePaymentFrequencyPeriodMultiplier()), (Mapper)MapperS.of((Object)1), (CardinalityOperator)CardinalityOperator.All);
                    }
                    return ComparisonResult.ofEmpty();
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

