/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.hkma.rewrite.valuation;

import cdm.base.staticdata.asset.common.ISOCurrencyCodeEnum;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.RosettaModelObjectBuilder;
import com.rosetta.model.lib.annotations.RosettaAttribute;
import com.rosetta.model.lib.annotations.RosettaDataType;
import com.rosetta.model.lib.annotations.RuneAttribute;
import com.rosetta.model.lib.annotations.RuneDataType;
import com.rosetta.model.lib.meta.RosettaMetaData;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.process.AttributeMeta;
import com.rosetta.model.lib.process.BuilderMerger;
import com.rosetta.model.lib.process.BuilderProcessor;
import com.rosetta.model.lib.process.Processor;
import drr.regulation.common.HKTRPartyScheme;
import drr.regulation.common.PartyIdentifierFormat2Enum;
import drr.regulation.common.UTIProprietarySchemeNameEnum;
import drr.regulation.hkma.rewrite.valuation.meta.HKMAValuationReportMeta;
import drr.standards.iso.ActionTypeEnum;
import drr.standards.iso.ValuationType1Code;
import java.math.BigDecimal;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.Optional;

@RosettaDataType(value="HKMAValuationReport", builder=HKMAValuationReportBuilderImpl.class, version="6.24.0")
@RuneDataType(value="HKMAValuationReport", model="drr", builder=HKMAValuationReportBuilderImpl.class, version="6.24.0")
public interface HKMAValuationReport
extends RosettaModelObject {
    public static final HKMAValuationReportMeta metaData = new HKMAValuationReportMeta();

    public ZonedDateTime getReportingTimestamp();

    public String getCounterparty1();

    public String getCounterparty2();

    public String getCounterparty2Name();

    public Boolean getCounterparty2IdentifierTypeIndicator();

    public BigDecimal getValuationAmount();

    public ISOCurrencyCodeEnum getValuationCurrency();

    public ZonedDateTime getValuationTimestamp();

    public ValuationType1Code getValuationMethod();

    public BigDecimal getDelta();

    public ActionTypeEnum getActionType();

    public String getUniqueTransactionIdentifier();

    public String getUniqueTransactionIdentifierProprietary();

    public String getSubmitterIdentifier();

    public String getEntityResponsibleForReporting();

    public BigDecimal getNumberRecords();

    public String getTechnicalRecordId();

    public String getRemarks();

    public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat();

    public HKTRPartyScheme getCounterparty2SchemeName();

    public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName();

    public HKMAValuationReport build();

    public HKMAValuationReportBuilder toBuilder();

    public static HKMAValuationReportBuilder builder() {
        return new HKMAValuationReportBuilderImpl();
    }

    default public RosettaMetaData<? extends HKMAValuationReport> metaData() {
        return metaData;
    }

    @RuneAttribute(value="@type")
    default public Class<? extends HKMAValuationReport> getType() {
        return HKMAValuationReport.class;
    }

    default public void process(RosettaPath path, Processor processor) {
        processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
        processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObject)this, new AttributeMeta[0]);
    }

    public static class HKMAValuationReportBuilderImpl
    implements HKMAValuationReportBuilder {
        protected ZonedDateTime reportingTimestamp;
        protected String counterparty1;
        protected String counterparty2;
        protected String counterparty2Name;
        protected Boolean counterparty2IdentifierTypeIndicator;
        protected BigDecimal valuationAmount;
        protected ISOCurrencyCodeEnum valuationCurrency;
        protected ZonedDateTime valuationTimestamp;
        protected ValuationType1Code valuationMethod;
        protected BigDecimal delta;
        protected ActionTypeEnum actionType;
        protected String uniqueTransactionIdentifier;
        protected String uniqueTransactionIdentifierProprietary;
        protected String submitterIdentifier;
        protected String entityResponsibleForReporting;
        protected BigDecimal numberRecords;
        protected String technicalRecordId;
        protected String remarks;
        protected PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        protected HKTRPartyScheme counterparty2SchemeName;
        protected UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime _reportingTimestamp) {
            this.reportingTimestamp = _reportingTimestamp == null ? null : _reportingTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty1(String _counterparty1) {
            this.counterparty1 = _counterparty1 == null ? null : _counterparty1;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2(String _counterparty2) {
            this.counterparty2 = _counterparty2 == null ? null : _counterparty2;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2Name(String _counterparty2Name) {
            this.counterparty2Name = _counterparty2Name == null ? null : _counterparty2Name;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public HKMAValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean _counterparty2IdentifierTypeIndicator) {
            this.counterparty2IdentifierTypeIndicator = _counterparty2IdentifierTypeIndicator == null ? null : _counterparty2IdentifierTypeIndicator;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public HKMAValuationReportBuilder setValuationAmount(BigDecimal _valuationAmount) {
            this.valuationAmount = _valuationAmount == null ? null : _valuationAmount;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum _valuationCurrency) {
            this.valuationCurrency = _valuationCurrency == null ? null : _valuationCurrency;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime _valuationTimestamp) {
            this.valuationTimestamp = _valuationTimestamp == null ? null : _valuationTimestamp;
            return this;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public HKMAValuationReportBuilder setValuationMethod(ValuationType1Code _valuationMethod) {
            this.valuationMethod = _valuationMethod == null ? null : _valuationMethod;
            return this;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public HKMAValuationReportBuilder setDelta(BigDecimal _delta) {
            this.delta = _delta == null ? null : _delta;
            return this;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public HKMAValuationReportBuilder setActionType(ActionTypeEnum _actionType) {
            this.actionType = _actionType == null ? null : _actionType;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public HKMAValuationReportBuilder setUniqueTransactionIdentifier(String _uniqueTransactionIdentifier) {
            this.uniqueTransactionIdentifier = _uniqueTransactionIdentifier == null ? null : _uniqueTransactionIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String _uniqueTransactionIdentifierProprietary) {
            this.uniqueTransactionIdentifierProprietary = _uniqueTransactionIdentifierProprietary == null ? null : _uniqueTransactionIdentifierProprietary;
            return this;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public HKMAValuationReportBuilder setSubmitterIdentifier(String _submitterIdentifier) {
            this.submitterIdentifier = _submitterIdentifier == null ? null : _submitterIdentifier;
            return this;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public HKMAValuationReportBuilder setEntityResponsibleForReporting(String _entityResponsibleForReporting) {
            this.entityResponsibleForReporting = _entityResponsibleForReporting == null ? null : _entityResponsibleForReporting;
            return this;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public HKMAValuationReportBuilder setNumberRecords(BigDecimal _numberRecords) {
            this.numberRecords = _numberRecords == null ? null : _numberRecords;
            return this;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public HKMAValuationReportBuilder setTechnicalRecordId(String _technicalRecordId) {
            this.technicalRecordId = _technicalRecordId == null ? null : _technicalRecordId;
            return this;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public HKMAValuationReportBuilder setRemarks(String _remarks) {
            this.remarks = _remarks == null ? null : _remarks;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum _counterparty2IdentifierFormat) {
            this.counterparty2IdentifierFormat = _counterparty2IdentifierFormat == null ? null : _counterparty2IdentifierFormat;
            return this;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKMAValuationReportBuilder setCounterparty2SchemeName(HKTRPartyScheme _counterparty2SchemeName) {
            this.counterparty2SchemeName = _counterparty2SchemeName == null ? null : _counterparty2SchemeName;
            return this;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum _uniqueTransactionIdentifierProprietarySchemeName) {
            this.uniqueTransactionIdentifierProprietarySchemeName = _uniqueTransactionIdentifierProprietarySchemeName == null ? null : _uniqueTransactionIdentifierProprietarySchemeName;
            return this;
        }

        @Override
        public HKMAValuationReport build() {
            return new HKMAValuationReportImpl(this);
        }

        @Override
        public HKMAValuationReportBuilder toBuilder() {
            return this;
        }

        @Override
        public HKMAValuationReportBuilder prune() {
            return this;
        }

        public boolean hasData() {
            if (this.getReportingTimestamp() != null) {
                return true;
            }
            if (this.getCounterparty1() != null) {
                return true;
            }
            if (this.getCounterparty2() != null) {
                return true;
            }
            if (this.getCounterparty2Name() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierTypeIndicator() != null) {
                return true;
            }
            if (this.getValuationAmount() != null) {
                return true;
            }
            if (this.getValuationCurrency() != null) {
                return true;
            }
            if (this.getValuationTimestamp() != null) {
                return true;
            }
            if (this.getValuationMethod() != null) {
                return true;
            }
            if (this.getDelta() != null) {
                return true;
            }
            if (this.getActionType() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifier() != null) {
                return true;
            }
            if (this.getUniqueTransactionIdentifierProprietary() != null) {
                return true;
            }
            if (this.getSubmitterIdentifier() != null) {
                return true;
            }
            if (this.getEntityResponsibleForReporting() != null) {
                return true;
            }
            if (this.getNumberRecords() != null) {
                return true;
            }
            if (this.getTechnicalRecordId() != null) {
                return true;
            }
            if (this.getRemarks() != null) {
                return true;
            }
            if (this.getCounterparty2IdentifierFormat() != null) {
                return true;
            }
            if (this.getCounterparty2SchemeName() != null) {
                return true;
            }
            return this.getUniqueTransactionIdentifierProprietarySchemeName() != null;
        }

        public HKMAValuationReportBuilder merge(RosettaModelObjectBuilder other, BuilderMerger merger) {
            HKMAValuationReportBuilder o = (HKMAValuationReportBuilder)other;
            merger.mergeBasic((Object)this.getReportingTimestamp(), (Object)o.getReportingTimestamp(), this::setReportingTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty1(), (Object)o.getCounterparty1(), this::setCounterparty1, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2(), (Object)o.getCounterparty2(), this::setCounterparty2, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2Name(), (Object)o.getCounterparty2Name(), this::setCounterparty2Name, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierTypeIndicator(), (Object)o.getCounterparty2IdentifierTypeIndicator(), this::setCounterparty2IdentifierTypeIndicator, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationAmount(), (Object)o.getValuationAmount(), this::setValuationAmount, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationCurrency(), (Object)o.getValuationCurrency(), this::setValuationCurrency, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationTimestamp(), (Object)o.getValuationTimestamp(), this::setValuationTimestamp, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getValuationMethod(), (Object)o.getValuationMethod(), this::setValuationMethod, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getDelta(), (Object)o.getDelta(), this::setDelta, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getActionType(), (Object)o.getActionType(), this::setActionType, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifier(), (Object)o.getUniqueTransactionIdentifier(), this::setUniqueTransactionIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietary(), (Object)o.getUniqueTransactionIdentifierProprietary(), this::setUniqueTransactionIdentifierProprietary, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getSubmitterIdentifier(), (Object)o.getSubmitterIdentifier(), this::setSubmitterIdentifier, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getEntityResponsibleForReporting(), (Object)o.getEntityResponsibleForReporting(), this::setEntityResponsibleForReporting, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getNumberRecords(), (Object)o.getNumberRecords(), this::setNumberRecords, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getTechnicalRecordId(), (Object)o.getTechnicalRecordId(), this::setTechnicalRecordId, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getRemarks(), (Object)o.getRemarks(), this::setRemarks, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2IdentifierFormat(), (Object)o.getCounterparty2IdentifierFormat(), this::setCounterparty2IdentifierFormat, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getCounterparty2SchemeName(), (Object)o.getCounterparty2SchemeName(), this::setCounterparty2SchemeName, new AttributeMeta[0]);
            merger.mergeBasic((Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (Object)o.getUniqueTransactionIdentifierProprietarySchemeName(), this::setUniqueTransactionIdentifierProprietarySchemeName, new AttributeMeta[0]);
            return this;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            HKMAValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "HKMAValuationReportBuilder {reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", actionType=" + String.valueOf((Object)this.actionType) + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", submitterIdentifier=" + this.submitterIdentifier + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", numberRecords=" + String.valueOf(this.numberRecords) + ", technicalRecordId=" + this.technicalRecordId + ", remarks=" + this.remarks + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "}";
        }
    }

    public static interface HKMAValuationReportBuilder
    extends HKMAValuationReport,
    RosettaModelObjectBuilder {
        public HKMAValuationReportBuilder setReportingTimestamp(ZonedDateTime var1);

        public HKMAValuationReportBuilder setCounterparty1(String var1);

        public HKMAValuationReportBuilder setCounterparty2(String var1);

        public HKMAValuationReportBuilder setCounterparty2Name(String var1);

        public HKMAValuationReportBuilder setCounterparty2IdentifierTypeIndicator(Boolean var1);

        public HKMAValuationReportBuilder setValuationAmount(BigDecimal var1);

        public HKMAValuationReportBuilder setValuationCurrency(ISOCurrencyCodeEnum var1);

        public HKMAValuationReportBuilder setValuationTimestamp(ZonedDateTime var1);

        public HKMAValuationReportBuilder setValuationMethod(ValuationType1Code var1);

        public HKMAValuationReportBuilder setDelta(BigDecimal var1);

        public HKMAValuationReportBuilder setActionType(ActionTypeEnum var1);

        public HKMAValuationReportBuilder setUniqueTransactionIdentifier(String var1);

        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietary(String var1);

        public HKMAValuationReportBuilder setSubmitterIdentifier(String var1);

        public HKMAValuationReportBuilder setEntityResponsibleForReporting(String var1);

        public HKMAValuationReportBuilder setNumberRecords(BigDecimal var1);

        public HKMAValuationReportBuilder setTechnicalRecordId(String var1);

        public HKMAValuationReportBuilder setRemarks(String var1);

        public HKMAValuationReportBuilder setCounterparty2IdentifierFormat(PartyIdentifierFormat2Enum var1);

        public HKMAValuationReportBuilder setCounterparty2SchemeName(HKTRPartyScheme var1);

        public HKMAValuationReportBuilder setUniqueTransactionIdentifierProprietarySchemeName(UTIProprietarySchemeNameEnum var1);

        default public void process(RosettaPath path, BuilderProcessor processor) {
            processor.processBasic(path.newSubPath("reportingTimestamp"), ZonedDateTime.class, (Object)this.getReportingTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty1"), String.class, (Object)this.getCounterparty1(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2"), String.class, (Object)this.getCounterparty2(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2Name"), String.class, (Object)this.getCounterparty2Name(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierTypeIndicator"), Boolean.class, (Object)this.getCounterparty2IdentifierTypeIndicator(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationAmount"), BigDecimal.class, (Object)this.getValuationAmount(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationCurrency"), ISOCurrencyCodeEnum.class, (Object)this.getValuationCurrency(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationTimestamp"), ZonedDateTime.class, (Object)this.getValuationTimestamp(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("valuationMethod"), ValuationType1Code.class, (Object)this.getValuationMethod(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("delta"), BigDecimal.class, (Object)this.getDelta(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("actionType"), ActionTypeEnum.class, (Object)this.getActionType(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifier"), String.class, (Object)this.getUniqueTransactionIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietary"), String.class, (Object)this.getUniqueTransactionIdentifierProprietary(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("submitterIdentifier"), String.class, (Object)this.getSubmitterIdentifier(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("entityResponsibleForReporting"), String.class, (Object)this.getEntityResponsibleForReporting(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("numberRecords"), BigDecimal.class, (Object)this.getNumberRecords(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("technicalRecordId"), String.class, (Object)this.getTechnicalRecordId(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("remarks"), String.class, (Object)this.getRemarks(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2IdentifierFormat"), PartyIdentifierFormat2Enum.class, (Object)this.getCounterparty2IdentifierFormat(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("counterparty2SchemeName"), HKTRPartyScheme.class, (Object)this.getCounterparty2SchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
            processor.processBasic(path.newSubPath("uniqueTransactionIdentifierProprietarySchemeName"), UTIProprietarySchemeNameEnum.class, (Object)this.getUniqueTransactionIdentifierProprietarySchemeName(), (RosettaModelObjectBuilder)this, new AttributeMeta[0]);
        }

        public HKMAValuationReportBuilder prune();
    }

    public static class HKMAValuationReportImpl
    implements HKMAValuationReport {
        private final ZonedDateTime reportingTimestamp;
        private final String counterparty1;
        private final String counterparty2;
        private final String counterparty2Name;
        private final Boolean counterparty2IdentifierTypeIndicator;
        private final BigDecimal valuationAmount;
        private final ISOCurrencyCodeEnum valuationCurrency;
        private final ZonedDateTime valuationTimestamp;
        private final ValuationType1Code valuationMethod;
        private final BigDecimal delta;
        private final ActionTypeEnum actionType;
        private final String uniqueTransactionIdentifier;
        private final String uniqueTransactionIdentifierProprietary;
        private final String submitterIdentifier;
        private final String entityResponsibleForReporting;
        private final BigDecimal numberRecords;
        private final String technicalRecordId;
        private final String remarks;
        private final PartyIdentifierFormat2Enum counterparty2IdentifierFormat;
        private final HKTRPartyScheme counterparty2SchemeName;
        private final UTIProprietarySchemeNameEnum uniqueTransactionIdentifierProprietarySchemeName;

        protected HKMAValuationReportImpl(HKMAValuationReportBuilder builder) {
            this.reportingTimestamp = builder.getReportingTimestamp();
            this.counterparty1 = builder.getCounterparty1();
            this.counterparty2 = builder.getCounterparty2();
            this.counterparty2Name = builder.getCounterparty2Name();
            this.counterparty2IdentifierTypeIndicator = builder.getCounterparty2IdentifierTypeIndicator();
            this.valuationAmount = builder.getValuationAmount();
            this.valuationCurrency = builder.getValuationCurrency();
            this.valuationTimestamp = builder.getValuationTimestamp();
            this.valuationMethod = builder.getValuationMethod();
            this.delta = builder.getDelta();
            this.actionType = builder.getActionType();
            this.uniqueTransactionIdentifier = builder.getUniqueTransactionIdentifier();
            this.uniqueTransactionIdentifierProprietary = builder.getUniqueTransactionIdentifierProprietary();
            this.submitterIdentifier = builder.getSubmitterIdentifier();
            this.entityResponsibleForReporting = builder.getEntityResponsibleForReporting();
            this.numberRecords = builder.getNumberRecords();
            this.technicalRecordId = builder.getTechnicalRecordId();
            this.remarks = builder.getRemarks();
            this.counterparty2IdentifierFormat = builder.getCounterparty2IdentifierFormat();
            this.counterparty2SchemeName = builder.getCounterparty2SchemeName();
            this.uniqueTransactionIdentifierProprietarySchemeName = builder.getUniqueTransactionIdentifierProprietarySchemeName();
        }

        @Override
        @RosettaAttribute(value="reportingTimestamp", isRequired=true)
        @RuneAttribute(value="reportingTimestamp", isRequired=true)
        public ZonedDateTime getReportingTimestamp() {
            return this.reportingTimestamp;
        }

        @Override
        @RosettaAttribute(value="counterparty1", isRequired=true)
        @RuneAttribute(value="counterparty1", isRequired=true)
        public String getCounterparty1() {
            return this.counterparty1;
        }

        @Override
        @RosettaAttribute(value="counterparty2", isRequired=true)
        @RuneAttribute(value="counterparty2", isRequired=true)
        public String getCounterparty2() {
            return this.counterparty2;
        }

        @Override
        @RosettaAttribute(value="counterparty2Name", isRequired=true)
        @RuneAttribute(value="counterparty2Name", isRequired=true)
        public String getCounterparty2Name() {
            return this.counterparty2Name;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        @RuneAttribute(value="counterparty2IdentifierTypeIndicator", isRequired=true)
        public Boolean getCounterparty2IdentifierTypeIndicator() {
            return this.counterparty2IdentifierTypeIndicator;
        }

        @Override
        @RosettaAttribute(value="valuationAmount", isRequired=true)
        @RuneAttribute(value="valuationAmount", isRequired=true)
        public BigDecimal getValuationAmount() {
            return this.valuationAmount;
        }

        @Override
        @RosettaAttribute(value="valuationCurrency", isRequired=true)
        @RuneAttribute(value="valuationCurrency", isRequired=true)
        public ISOCurrencyCodeEnum getValuationCurrency() {
            return this.valuationCurrency;
        }

        @Override
        @RosettaAttribute(value="valuationTimestamp", isRequired=true)
        @RuneAttribute(value="valuationTimestamp", isRequired=true)
        public ZonedDateTime getValuationTimestamp() {
            return this.valuationTimestamp;
        }

        @Override
        @RosettaAttribute(value="valuationMethod", isRequired=true)
        @RuneAttribute(value="valuationMethod", isRequired=true)
        public ValuationType1Code getValuationMethod() {
            return this.valuationMethod;
        }

        @Override
        @RosettaAttribute(value="delta")
        @RuneAttribute(value="delta")
        public BigDecimal getDelta() {
            return this.delta;
        }

        @Override
        @RosettaAttribute(value="actionType", isRequired=true)
        @RuneAttribute(value="actionType", isRequired=true)
        public ActionTypeEnum getActionType() {
            return this.actionType;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifier", isRequired=true)
        public String getUniqueTransactionIdentifier() {
            return this.uniqueTransactionIdentifier;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        @RuneAttribute(value="uniqueTransactionIdentifierProprietary", isRequired=true)
        public String getUniqueTransactionIdentifierProprietary() {
            return this.uniqueTransactionIdentifierProprietary;
        }

        @Override
        @RosettaAttribute(value="submitterIdentifier", isRequired=true)
        @RuneAttribute(value="submitterIdentifier", isRequired=true)
        public String getSubmitterIdentifier() {
            return this.submitterIdentifier;
        }

        @Override
        @RosettaAttribute(value="entityResponsibleForReporting")
        @RuneAttribute(value="entityResponsibleForReporting")
        public String getEntityResponsibleForReporting() {
            return this.entityResponsibleForReporting;
        }

        @Override
        @RosettaAttribute(value="numberRecords", isRequired=true)
        @RuneAttribute(value="numberRecords", isRequired=true)
        public BigDecimal getNumberRecords() {
            return this.numberRecords;
        }

        @Override
        @RosettaAttribute(value="technicalRecordId", isRequired=true)
        @RuneAttribute(value="technicalRecordId", isRequired=true)
        public String getTechnicalRecordId() {
            return this.technicalRecordId;
        }

        @Override
        @RosettaAttribute(value="remarks")
        @RuneAttribute(value="remarks")
        public String getRemarks() {
            return this.remarks;
        }

        @Override
        @RosettaAttribute(value="counterparty2IdentifierFormat")
        @RuneAttribute(value="counterparty2IdentifierFormat")
        public PartyIdentifierFormat2Enum getCounterparty2IdentifierFormat() {
            return this.counterparty2IdentifierFormat;
        }

        @Override
        @RosettaAttribute(value="counterparty2SchemeName")
        @RuneAttribute(value="counterparty2SchemeName")
        public HKTRPartyScheme getCounterparty2SchemeName() {
            return this.counterparty2SchemeName;
        }

        @Override
        @RosettaAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        @RuneAttribute(value="uniqueTransactionIdentifierProprietarySchemeName")
        public UTIProprietarySchemeNameEnum getUniqueTransactionIdentifierProprietarySchemeName() {
            return this.uniqueTransactionIdentifierProprietarySchemeName;
        }

        @Override
        public HKMAValuationReport build() {
            return this;
        }

        @Override
        public HKMAValuationReportBuilder toBuilder() {
            HKMAValuationReportBuilder builder = HKMAValuationReport.builder();
            this.setBuilderFields(builder);
            return builder;
        }

        protected void setBuilderFields(HKMAValuationReportBuilder builder) {
            Optional.ofNullable(this.getReportingTimestamp()).ifPresent(builder::setReportingTimestamp);
            Optional.ofNullable(this.getCounterparty1()).ifPresent(builder::setCounterparty1);
            Optional.ofNullable(this.getCounterparty2()).ifPresent(builder::setCounterparty2);
            Optional.ofNullable(this.getCounterparty2Name()).ifPresent(builder::setCounterparty2Name);
            Optional.ofNullable(this.getCounterparty2IdentifierTypeIndicator()).ifPresent(builder::setCounterparty2IdentifierTypeIndicator);
            Optional.ofNullable(this.getValuationAmount()).ifPresent(builder::setValuationAmount);
            Optional.ofNullable(this.getValuationCurrency()).ifPresent(builder::setValuationCurrency);
            Optional.ofNullable(this.getValuationTimestamp()).ifPresent(builder::setValuationTimestamp);
            Optional.ofNullable(this.getValuationMethod()).ifPresent(builder::setValuationMethod);
            Optional.ofNullable(this.getDelta()).ifPresent(builder::setDelta);
            Optional.ofNullable(this.getActionType()).ifPresent(builder::setActionType);
            Optional.ofNullable(this.getUniqueTransactionIdentifier()).ifPresent(builder::setUniqueTransactionIdentifier);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietary()).ifPresent(builder::setUniqueTransactionIdentifierProprietary);
            Optional.ofNullable(this.getSubmitterIdentifier()).ifPresent(builder::setSubmitterIdentifier);
            Optional.ofNullable(this.getEntityResponsibleForReporting()).ifPresent(builder::setEntityResponsibleForReporting);
            Optional.ofNullable(this.getNumberRecords()).ifPresent(builder::setNumberRecords);
            Optional.ofNullable(this.getTechnicalRecordId()).ifPresent(builder::setTechnicalRecordId);
            Optional.ofNullable(this.getRemarks()).ifPresent(builder::setRemarks);
            Optional.ofNullable(this.getCounterparty2IdentifierFormat()).ifPresent(builder::setCounterparty2IdentifierFormat);
            Optional.ofNullable(this.getCounterparty2SchemeName()).ifPresent(builder::setCounterparty2SchemeName);
            Optional.ofNullable(this.getUniqueTransactionIdentifierProprietarySchemeName()).ifPresent(builder::setUniqueTransactionIdentifierProprietarySchemeName);
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || !(o instanceof RosettaModelObject) || !this.getType().equals(((RosettaModelObject)o).getType())) {
                return false;
            }
            HKMAValuationReport _that = this.getType().cast(o);
            if (!Objects.equals(this.reportingTimestamp, _that.getReportingTimestamp())) {
                return false;
            }
            if (!Objects.equals(this.counterparty1, _that.getCounterparty1())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2, _that.getCounterparty2())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2Name, _that.getCounterparty2Name())) {
                return false;
            }
            if (!Objects.equals(this.counterparty2IdentifierTypeIndicator, _that.getCounterparty2IdentifierTypeIndicator())) {
                return false;
            }
            if (!Objects.equals(this.valuationAmount, _that.getValuationAmount())) {
                return false;
            }
            if (!Objects.equals(this.valuationCurrency, _that.getValuationCurrency())) {
                return false;
            }
            if (!Objects.equals(this.valuationTimestamp, _that.getValuationTimestamp())) {
                return false;
            }
            if (!Objects.equals((Object)this.valuationMethod, (Object)_that.getValuationMethod())) {
                return false;
            }
            if (!Objects.equals(this.delta, _that.getDelta())) {
                return false;
            }
            if (!Objects.equals((Object)this.actionType, (Object)_that.getActionType())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifier, _that.getUniqueTransactionIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.uniqueTransactionIdentifierProprietary, _that.getUniqueTransactionIdentifierProprietary())) {
                return false;
            }
            if (!Objects.equals(this.submitterIdentifier, _that.getSubmitterIdentifier())) {
                return false;
            }
            if (!Objects.equals(this.entityResponsibleForReporting, _that.getEntityResponsibleForReporting())) {
                return false;
            }
            if (!Objects.equals(this.numberRecords, _that.getNumberRecords())) {
                return false;
            }
            if (!Objects.equals(this.technicalRecordId, _that.getTechnicalRecordId())) {
                return false;
            }
            if (!Objects.equals(this.remarks, _that.getRemarks())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2IdentifierFormat, (Object)_that.getCounterparty2IdentifierFormat())) {
                return false;
            }
            if (!Objects.equals((Object)this.counterparty2SchemeName, (Object)_that.getCounterparty2SchemeName())) {
                return false;
            }
            return Objects.equals((Object)this.uniqueTransactionIdentifierProprietarySchemeName, (Object)_that.getUniqueTransactionIdentifierProprietarySchemeName());
        }

        public int hashCode() {
            int _result = 0;
            _result = 31 * _result + (this.reportingTimestamp != null ? this.reportingTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.counterparty1 != null ? this.counterparty1.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2 != null ? this.counterparty2.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2Name != null ? this.counterparty2Name.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierTypeIndicator != null ? this.counterparty2IdentifierTypeIndicator.hashCode() : 0);
            _result = 31 * _result + (this.valuationAmount != null ? this.valuationAmount.hashCode() : 0);
            _result = 31 * _result + (this.valuationCurrency != null ? this.valuationCurrency.getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.valuationTimestamp != null ? this.valuationTimestamp.hashCode() : 0);
            _result = 31 * _result + (this.valuationMethod != null ? ((Object)((Object)this.valuationMethod)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.delta != null ? this.delta.hashCode() : 0);
            _result = 31 * _result + (this.actionType != null ? ((Object)((Object)this.actionType)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifier != null ? this.uniqueTransactionIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietary != null ? this.uniqueTransactionIdentifierProprietary.hashCode() : 0);
            _result = 31 * _result + (this.submitterIdentifier != null ? this.submitterIdentifier.hashCode() : 0);
            _result = 31 * _result + (this.entityResponsibleForReporting != null ? this.entityResponsibleForReporting.hashCode() : 0);
            _result = 31 * _result + (this.numberRecords != null ? this.numberRecords.hashCode() : 0);
            _result = 31 * _result + (this.technicalRecordId != null ? this.technicalRecordId.hashCode() : 0);
            _result = 31 * _result + (this.remarks != null ? this.remarks.hashCode() : 0);
            _result = 31 * _result + (this.counterparty2IdentifierFormat != null ? ((Object)((Object)this.counterparty2IdentifierFormat)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.counterparty2SchemeName != null ? ((Object)((Object)this.counterparty2SchemeName)).getClass().getName().hashCode() : 0);
            _result = 31 * _result + (this.uniqueTransactionIdentifierProprietarySchemeName != null ? ((Object)((Object)this.uniqueTransactionIdentifierProprietarySchemeName)).getClass().getName().hashCode() : 0);
            return _result;
        }

        public String toString() {
            return "HKMAValuationReport {reportingTimestamp=" + String.valueOf(this.reportingTimestamp) + ", counterparty1=" + this.counterparty1 + ", counterparty2=" + this.counterparty2 + ", counterparty2Name=" + this.counterparty2Name + ", counterparty2IdentifierTypeIndicator=" + this.counterparty2IdentifierTypeIndicator + ", valuationAmount=" + String.valueOf(this.valuationAmount) + ", valuationCurrency=" + String.valueOf(this.valuationCurrency) + ", valuationTimestamp=" + String.valueOf(this.valuationTimestamp) + ", valuationMethod=" + String.valueOf((Object)this.valuationMethod) + ", delta=" + String.valueOf(this.delta) + ", actionType=" + String.valueOf((Object)this.actionType) + ", uniqueTransactionIdentifier=" + this.uniqueTransactionIdentifier + ", uniqueTransactionIdentifierProprietary=" + this.uniqueTransactionIdentifierProprietary + ", submitterIdentifier=" + this.submitterIdentifier + ", entityResponsibleForReporting=" + this.entityResponsibleForReporting + ", numberRecords=" + String.valueOf(this.numberRecords) + ", technicalRecordId=" + this.technicalRecordId + ", remarks=" + this.remarks + ", counterparty2IdentifierFormat=" + String.valueOf((Object)this.counterparty2IdentifierFormat) + ", counterparty2SchemeName=" + String.valueOf((Object)this.counterparty2SchemeName) + ", uniqueTransactionIdentifierProprietarySchemeName=" + String.valueOf((Object)this.uniqueTransactionIdentifierProprietarySchemeName) + "}";
        }
    }
}

