/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.jfsa.rewrite.trade.validation.datarule;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.annotations.RosettaDataRule;
import com.rosetta.model.lib.expression.CardinalityOperator;
import com.rosetta.model.lib.expression.ComparisonResult;
import com.rosetta.model.lib.expression.ExpressionOperatorsNullSafe;
import com.rosetta.model.lib.mapper.Mapper;
import com.rosetta.model.lib.mapper.MapperBuilder;
import com.rosetta.model.lib.mapper.MapperC;
import com.rosetta.model.lib.mapper.MapperS;
import com.rosetta.model.lib.path.RosettaPath;
import com.rosetta.model.lib.records.Date;
import com.rosetta.model.lib.validation.ValidationResult;
import com.rosetta.model.lib.validation.Validator;
import drr.regulation.jfsa.rewrite.trade.JFSATransactionReport;
import drr.standards.iso.ActionTypeEnum;
import java.time.LocalDate;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;

@RosettaDataRule(value="JFSATransactionReportDTCC_JFSA_BR_0104_02")
@ImplementedBy(value=Default.class)
public interface JFSATransactionReportDTCC_JFSA_BR_0104_02
extends Validator<JFSATransactionReport> {
    public static final String NAME = "JFSATransactionReportDTCC_JFSA_BR_0104_02";
    public static final String DEFINITION = "if [ActionTypeEnum -> EROR, ActionTypeEnum -> PRTO] any = actionType then eventTimestamp >= executionTimestamp and eventTimestamp <= reportingTimestamp and eventTimestamp -> date <= expirationDate and eventTimestamp -> date <= earlyTerminationDate";

    public static class NoOp
    implements JFSATransactionReportDTCC_JFSA_BR_0104_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            return Collections.emptyList();
        }
    }

    public static class Default
    implements JFSATransactionReportDTCC_JFSA_BR_0104_02 {
        public List<ValidationResult<?>> getValidationResults(RosettaPath path, JFSATransactionReport jFSATransactionReport) {
            ComparisonResult result = this.executeDataRule(jFSATransactionReport);
            if (result.getOrDefault(Boolean.valueOf(true)).booleanValue()) {
                return Arrays.asList(ValidationResult.success((String)JFSATransactionReportDTCC_JFSA_BR_0104_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0104_02.DEFINITION));
            }
            String failureMessage = result.getError();
            if (failureMessage == null || failureMessage.contains("Null") || failureMessage == "") {
                failureMessage = "Condition has failed.";
            }
            return Arrays.asList(ValidationResult.failure((String)JFSATransactionReportDTCC_JFSA_BR_0104_02.NAME, (ValidationResult.ValidationType)ValidationResult.ValidationType.DATA_RULE, (String)"JFSATransactionReport", (RosettaPath)path, (String)JFSATransactionReportDTCC_JFSA_BR_0104_02.DEFINITION, (String)failureMessage));
        }

        private ComparisonResult executeDataRule(JFSATransactionReport jFSATransactionReport) {
            try {
                if (ExpressionOperatorsNullSafe.areEqual((Mapper)MapperC.of((MapperBuilder[])new MapperBuilder[]{MapperS.of((Object)((Object)ActionTypeEnum.EROR)), MapperS.of((Object)((Object)ActionTypeEnum.PRTO))}), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getActionType", _jFSATransactionReport -> _jFSATransactionReport.getActionType()), (CardinalityOperator)CardinalityOperator.Any).getOrDefault(Boolean.valueOf(false)).booleanValue()) {
                    return ExpressionOperatorsNullSafe.greaterThanEquals((Mapper)MapperS.of((Object)jFSATransactionReport).map("getEventTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getEventTimestamp()), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getExecutionTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getExecutionTimestamp()), (CardinalityOperator)CardinalityOperator.All).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)jFSATransactionReport).map("getEventTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getEventTimestamp()), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getReportingTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getReportingTimestamp()), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)jFSATransactionReport).map("getEventTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getEventTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getExpirationDate", _jFSATransactionReport -> _jFSATransactionReport.getExpirationDate()), (CardinalityOperator)CardinalityOperator.All)).andNullSafe(ExpressionOperatorsNullSafe.lessThanEquals((Mapper)MapperS.of((Object)jFSATransactionReport).map("getEventTimestamp", _jFSATransactionReport -> _jFSATransactionReport.getEventTimestamp()).map("Date", zdt -> Date.of((LocalDate)zdt.toLocalDate())), (Mapper)MapperS.of((Object)jFSATransactionReport).map("getEarlyTerminationDate", _jFSATransactionReport -> _jFSATransactionReport.getEarlyTerminationDate()), (CardinalityOperator)CardinalityOperator.All));
                }
                return ComparisonResult.ofEmpty();
            }
            catch (Exception ex) {
                return ComparisonResult.failure((String)ex.getMessage());
            }
        }
    }
}

