/*
 * Decompiled with CFR 0.152.
 */
package drr.regulation.mas.rewrite.trade.reports;

import com.google.inject.ImplementedBy;
import com.rosetta.model.lib.RosettaModelObject;
import com.rosetta.model.lib.annotations.RosettaReport;
import com.rosetta.model.lib.annotations.RuneLabelProvider;
import com.rosetta.model.lib.functions.ModelObjectValidator;
import com.rosetta.model.lib.reports.ReportFunction;
import drr.enrichment.common.reports.EnrichmentDataRule;
import drr.enrichment.common.reports.UpiPostEnrichmentDataRule;
import drr.enrichment.common.reports.UpiPreEnrichmentDataRule;
import drr.regulation.common.TransactionReportInstruction;
import drr.regulation.mas.rewrite.trade.MASTransactionReport;
import drr.regulation.mas.rewrite.trade.labels.MASTradeLabelProvider;
import drr.regulation.mas.rewrite.trade.reports.ActionTypeRule;
import drr.regulation.mas.rewrite.trade.reports.AssetClassRule;
import drr.regulation.mas.rewrite.trade.reports.BasketConstituentsRule;
import drr.regulation.mas.rewrite.trade.reports.BookingLocationRule;
import drr.regulation.mas.rewrite.trade.reports.CallAmountRule;
import drr.regulation.mas.rewrite.trade.reports.CallCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.CentralCounterpartyRule;
import drr.regulation.mas.rewrite.trade.reports.ClearedRule;
import drr.regulation.mas.rewrite.trade.reports.ClearingMemberRule;
import drr.regulation.mas.rewrite.trade.reports.ClearingTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.CollateralPortfolioIndicatorRule;
import drr.regulation.mas.rewrite.trade.reports.ConfirmationTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.ConfirmedRule;
import drr.regulation.mas.rewrite.trade.reports.ContractPriceScheduleRule;
import drr.regulation.mas.rewrite.trade.reports.ContractTypeRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty1Rule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2IdentifierTypeRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2NameDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.Counterparty2Rule;
import drr.regulation.mas.rewrite.trade.reports.DataSubmitterRule;
import drr.regulation.mas.rewrite.trade.reports.DeliveryTypeRule;
import drr.regulation.mas.rewrite.trade.reports.Direction2Leg1Rule;
import drr.regulation.mas.rewrite.trade.reports.Direction2Leg2Rule;
import drr.regulation.mas.rewrite.trade.reports.DirectionRule;
import drr.regulation.mas.rewrite.trade.reports.EffectiveDateRule;
import drr.regulation.mas.rewrite.trade.reports.EventTypeRule;
import drr.regulation.mas.rewrite.trade.reports.ExchangeRateBasisRule;
import drr.regulation.mas.rewrite.trade.reports.ExchangeRateRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionAgentCounterparty1DTCCRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionAgentCounterparty2DTCCRule;
import drr.regulation.mas.rewrite.trade.reports.ExecutionTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.ExpirationDateRule;
import drr.regulation.mas.rewrite.trade.reports.FinalContractualSettlementDateRule;
import drr.regulation.mas.rewrite.trade.reports.FirstExerciseDateRule;
import drr.regulation.mas.rewrite.trade.reports.FixedRateDayCountConventionLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRateDayCountConventionLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRateLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRateLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRatePaymentFrequencyPeriodLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRatePaymentFrequencyPeriodLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateDayCountConventionLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateDayCountConventionLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateIdentifierLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateIdentifierLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRatePaymentFrequencyPeriodLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRatePaymentFrequencyPeriodLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateResetFrequencyMultiplierOfLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateResetFrequencyMultiplierOfLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateResetFrequencyPeriodOfLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.FloatingRateResetFrequencyPeriodOfLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.InitialMarginCollateralPortfolioCodeDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.NameOfTheFloatingRateLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NameOfTheFloatingRateLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NameOfTheUnderlyingIndexDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.NotionalAmountLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalAmountLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalAmountScheduleLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalAmountScheduleLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalCurrencyLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalCurrencyLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalQuantityLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalQuantityLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalQuantityScheduleLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.NotionalQuantityScheduleLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.OptionPremiumAmountRule;
import drr.regulation.mas.rewrite.trade.reports.OptionPremiumCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.OptionStyleRule;
import drr.regulation.mas.rewrite.trade.reports.OptionTypeRule;
import drr.regulation.mas.rewrite.trade.reports.OtherPaymentRule;
import drr.regulation.mas.rewrite.trade.reports.PackageIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.PlatformIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.PriceCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.PriceNotationRule;
import drr.regulation.mas.rewrite.trade.reports.PriceRule;
import drr.regulation.mas.rewrite.trade.reports.PriceUnitOfMeasureRule;
import drr.regulation.mas.rewrite.trade.reports.PriorUTIProprietaryRule;
import drr.regulation.mas.rewrite.trade.reports.PriorUTIRule;
import drr.regulation.mas.rewrite.trade.reports.PutAmountRule;
import drr.regulation.mas.rewrite.trade.reports.PutCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.QuantityFrequencyPeriodLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.QuantityFrequencyPeriodLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.QuantityFrequencyPeriodMultiplierLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.QuantityFrequencyPeriodMultiplierLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.QuantityUnitOfMeasureLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.QuantityUnitOfMeasureLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.ReportingSpecifiedPersonRule;
import drr.regulation.mas.rewrite.trade.reports.ReportingTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.SettlementCurrencyLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.SettlementCurrencyLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadCurrencyLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadCurrencyLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadNotationLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.SpreadNotationLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceCurrencyCurrencyPairRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceNotationRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceRule;
import drr.regulation.mas.rewrite.trade.reports.StrikePriceScheduleRule;
import drr.regulation.mas.rewrite.trade.reports.SwapLinkIDRule;
import drr.regulation.mas.rewrite.trade.reports.TechnicalRecordIdRule;
import drr.regulation.mas.rewrite.trade.reports.TotalNotionalQuantityLeg1Rule;
import drr.regulation.mas.rewrite.trade.reports.TotalNotionalQuantityLeg2Rule;
import drr.regulation.mas.rewrite.trade.reports.TraderLocationRule;
import drr.regulation.mas.rewrite.trade.reports.TradingCapacityOfSpecifiedPersonRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdOtherDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdOtherSourceDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingIdentificationTypeDTCCRule;
import drr.regulation.mas.rewrite.trade.reports.UnderlyingRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueProductIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueTransactionIdentifierProprietaryRule;
import drr.regulation.mas.rewrite.trade.reports.UniqueTransactionIdentifierRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationAmountRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationCurrencyRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationMethodRule;
import drr.regulation.mas.rewrite.trade.reports.ValuationTimestampRule;
import drr.regulation.mas.rewrite.trade.reports.VariationMarginCollateralPortfolioCodeDTCCRule;
import drr.standards.iosco.cde.version3.datetime.reports.EventTimestampRule;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;

@RosettaReport(namespace="drr.regulation.mas.rewrite.trade", body="MAS", corpusList={"Trade"})
@RuneLabelProvider(labelProvider=MASTradeLabelProvider.class)
@ImplementedBy(value=MASTradeReportFunctionDefault.class)
public abstract class MASTradeReportFunction
implements ReportFunction<TransactionReportInstruction, MASTransactionReport> {
    @Inject
    protected ModelObjectValidator objectValidator;
    @Inject
    protected ActionTypeRule actionTypeRule;
    @Inject
    protected AssetClassRule assetClassRule;
    @Inject
    protected BasketConstituentsRule basketConstituentsRule;
    @Inject
    protected BookingLocationRule bookingLocationRule;
    @Inject
    protected CallAmountRule callAmountRule;
    @Inject
    protected CallCurrencyRule callCurrencyRule;
    @Inject
    protected CentralCounterpartyRule centralCounterpartyRule;
    @Inject
    protected ClearedRule clearedRule;
    @Inject
    protected ClearingMemberRule clearingMemberRule;
    @Inject
    protected ClearingTimestampRule clearingTimestampRule;
    @Inject
    protected CollateralPortfolioIndicatorRule collateralPortfolioIndicatorRule;
    @Inject
    protected ConfirmationTimestampRule confirmationTimestampRule;
    @Inject
    protected ConfirmedRule confirmedRule;
    @Inject
    protected ContractPriceScheduleRule contractPriceScheduleRule;
    @Inject
    protected ContractTypeRule contractTypeRule;
    @Inject
    protected Counterparty1Rule counterparty1Rule;
    @Inject
    protected Counterparty2IdentifierTypeRule counterparty2IdentifierTypeRule;
    @Inject
    protected Counterparty2NameDTCCRule counterparty2NameDTCCRule;
    @Inject
    protected Counterparty2Rule counterparty2Rule;
    @Inject
    protected DataSubmitterRule dataSubmitterRule;
    @Inject
    protected DeliveryTypeRule deliveryTypeRule;
    @Inject
    protected Direction2Leg1Rule direction2Leg1Rule;
    @Inject
    protected Direction2Leg2Rule direction2Leg2Rule;
    @Inject
    protected DirectionRule directionRule;
    @Inject
    protected EffectiveDateRule effectiveDateRule;
    @Inject
    protected EnrichmentDataRule enrichmentDataRule;
    @Inject
    protected EventTimestampRule eventTimestampRule;
    @Inject
    protected EventTypeRule eventTypeRule;
    @Inject
    protected ExchangeRateBasisRule exchangeRateBasisRule;
    @Inject
    protected ExchangeRateRule exchangeRateRule;
    @Inject
    protected ExecutionAgentCounterparty1DTCCRule executionAgentCounterparty1DTCCRule;
    @Inject
    protected ExecutionAgentCounterparty2DTCCRule executionAgentCounterparty2DTCCRule;
    @Inject
    protected ExecutionTimestampRule executionTimestampRule;
    @Inject
    protected ExpirationDateRule expirationDateRule;
    @Inject
    protected FinalContractualSettlementDateRule finalContractualSettlementDateRule;
    @Inject
    protected FirstExerciseDateRule firstExerciseDateRule;
    @Inject
    protected FixedRateDayCountConventionLeg1Rule fixedRateDayCountConventionLeg1Rule;
    @Inject
    protected FixedRateDayCountConventionLeg2Rule fixedRateDayCountConventionLeg2Rule;
    @Inject
    protected FixedRateLeg1Rule fixedRateLeg1Rule;
    @Inject
    protected FixedRateLeg2Rule fixedRateLeg2Rule;
    @Inject
    protected FixedRatePaymentFrequencyPeriodLeg1Rule fixedRatePaymentFrequencyPeriodLeg1Rule;
    @Inject
    protected FixedRatePaymentFrequencyPeriodLeg2Rule fixedRatePaymentFrequencyPeriodLeg2Rule;
    @Inject
    protected FixedRatePaymentFrequencyPeriodMultiplierLeg1Rule fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule;
    @Inject
    protected FixedRatePaymentFrequencyPeriodMultiplierLeg2Rule fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule;
    @Inject
    protected FloatingRateDayCountConventionLeg1Rule floatingRateDayCountConventionLeg1Rule;
    @Inject
    protected FloatingRateDayCountConventionLeg2Rule floatingRateDayCountConventionLeg2Rule;
    @Inject
    protected FloatingRateIdentifierLeg1Rule floatingRateIdentifierLeg1Rule;
    @Inject
    protected FloatingRateIdentifierLeg2Rule floatingRateIdentifierLeg2Rule;
    @Inject
    protected FloatingRatePaymentFrequencyPeriodLeg1Rule floatingRatePaymentFrequencyPeriodLeg1Rule;
    @Inject
    protected FloatingRatePaymentFrequencyPeriodLeg2Rule floatingRatePaymentFrequencyPeriodLeg2Rule;
    @Inject
    protected FloatingRatePaymentFrequencyPeriodMultiplierLeg1Rule floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule;
    @Inject
    protected FloatingRatePaymentFrequencyPeriodMultiplierLeg2Rule floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule;
    @Inject
    protected FloatingRateResetFrequencyMultiplierOfLeg1Rule floatingRateResetFrequencyMultiplierOfLeg1Rule;
    @Inject
    protected FloatingRateResetFrequencyMultiplierOfLeg2Rule floatingRateResetFrequencyMultiplierOfLeg2Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodOfLeg1Rule floatingRateResetFrequencyPeriodOfLeg1Rule;
    @Inject
    protected FloatingRateResetFrequencyPeriodOfLeg2Rule floatingRateResetFrequencyPeriodOfLeg2Rule;
    @Inject
    protected InitialMarginCollateralPortfolioCodeDTCCRule initialMarginCollateralPortfolioCodeDTCCRule;
    @Inject
    protected NameOfTheFloatingRateLeg1Rule nameOfTheFloatingRateLeg1Rule;
    @Inject
    protected NameOfTheFloatingRateLeg2Rule nameOfTheFloatingRateLeg2Rule;
    @Inject
    protected NameOfTheUnderlyingIndexDTCCRule nameOfTheUnderlyingIndexDTCCRule;
    @Inject
    protected NotionalAmountLeg1Rule notionalAmountLeg1Rule;
    @Inject
    protected NotionalAmountLeg2Rule notionalAmountLeg2Rule;
    @Inject
    protected NotionalAmountScheduleLeg1Rule notionalAmountScheduleLeg1Rule;
    @Inject
    protected NotionalAmountScheduleLeg2Rule notionalAmountScheduleLeg2Rule;
    @Inject
    protected NotionalCurrencyLeg1Rule notionalCurrencyLeg1Rule;
    @Inject
    protected NotionalCurrencyLeg2Rule notionalCurrencyLeg2Rule;
    @Inject
    protected NotionalQuantityLeg1Rule notionalQuantityLeg1Rule;
    @Inject
    protected NotionalQuantityLeg2Rule notionalQuantityLeg2Rule;
    @Inject
    protected NotionalQuantityScheduleLeg1Rule notionalQuantityScheduleLeg1Rule;
    @Inject
    protected NotionalQuantityScheduleLeg2Rule notionalQuantityScheduleLeg2Rule;
    @Inject
    protected OptionPremiumAmountRule optionPremiumAmountRule;
    @Inject
    protected OptionPremiumCurrencyRule optionPremiumCurrencyRule;
    @Inject
    protected OptionStyleRule optionStyleRule;
    @Inject
    protected OptionTypeRule optionTypeRule;
    @Inject
    protected OtherPaymentRule otherPaymentRule;
    @Inject
    protected PackageIdentifierRule packageIdentifierRule;
    @Inject
    protected PlatformIdentifierRule platformIdentifierRule;
    @Inject
    protected PriceCurrencyRule priceCurrencyRule;
    @Inject
    protected PriceNotationRule priceNotationRule;
    @Inject
    protected PriceRule priceRule;
    @Inject
    protected PriceUnitOfMeasureRule priceUnitOfMeasureRule;
    @Inject
    protected PriorUTIProprietaryRule priorUTIProprietaryRule;
    @Inject
    protected PriorUTIRule priorUTIRule;
    @Inject
    protected PutAmountRule putAmountRule;
    @Inject
    protected PutCurrencyRule putCurrencyRule;
    @Inject
    protected QuantityFrequencyPeriodLeg1Rule quantityFrequencyPeriodLeg1Rule;
    @Inject
    protected QuantityFrequencyPeriodLeg2Rule quantityFrequencyPeriodLeg2Rule;
    @Inject
    protected QuantityFrequencyPeriodMultiplierLeg1Rule quantityFrequencyPeriodMultiplierLeg1Rule;
    @Inject
    protected QuantityFrequencyPeriodMultiplierLeg2Rule quantityFrequencyPeriodMultiplierLeg2Rule;
    @Inject
    protected QuantityUnitOfMeasureLeg1Rule quantityUnitOfMeasureLeg1Rule;
    @Inject
    protected QuantityUnitOfMeasureLeg2Rule quantityUnitOfMeasureLeg2Rule;
    @Inject
    protected ReportingSpecifiedPersonRule reportingSpecifiedPersonRule;
    @Inject
    protected ReportingTimestampRule reportingTimestampRule;
    @Inject
    protected SettlementCurrencyLeg1Rule settlementCurrencyLeg1Rule;
    @Inject
    protected SettlementCurrencyLeg2Rule settlementCurrencyLeg2Rule;
    @Inject
    protected SpreadCurrencyLeg1Rule spreadCurrencyLeg1Rule;
    @Inject
    protected SpreadCurrencyLeg2Rule spreadCurrencyLeg2Rule;
    @Inject
    protected SpreadLeg1Rule spreadLeg1Rule;
    @Inject
    protected SpreadLeg2Rule spreadLeg2Rule;
    @Inject
    protected SpreadNotationLeg1Rule spreadNotationLeg1Rule;
    @Inject
    protected SpreadNotationLeg2Rule spreadNotationLeg2Rule;
    @Inject
    protected StrikePriceCurrencyCurrencyPairRule strikePriceCurrencyCurrencyPairRule;
    @Inject
    protected StrikePriceNotationRule strikePriceNotationRule;
    @Inject
    protected StrikePriceRule strikePriceRule;
    @Inject
    protected StrikePriceScheduleRule strikePriceScheduleRule;
    @Inject
    protected SwapLinkIDRule swapLinkIDRule;
    @Inject
    protected TechnicalRecordIdRule technicalRecordIdRule;
    @Inject
    protected TotalNotionalQuantityLeg1Rule totalNotionalQuantityLeg1Rule;
    @Inject
    protected TotalNotionalQuantityLeg2Rule totalNotionalQuantityLeg2Rule;
    @Inject
    protected TraderLocationRule traderLocationRule;
    @Inject
    protected TradingCapacityOfSpecifiedPersonRule tradingCapacityOfSpecifiedPersonRule;
    @Inject
    protected UnderlyingIdOtherDTCCRule underlyingIdOtherDTCCRule;
    @Inject
    protected UnderlyingIdOtherSourceDTCCRule underlyingIdOtherSourceDTCCRule;
    @Inject
    protected UnderlyingIdentificationTypeDTCCRule underlyingIdentificationTypeDTCCRule;
    @Inject
    protected UnderlyingRule underlyingRule;
    @Inject
    protected UniqueProductIdentifierRule uniqueProductIdentifierRule;
    @Inject
    protected UniqueTransactionIdentifierProprietaryRule uniqueTransactionIdentifierProprietaryRule;
    @Inject
    protected UniqueTransactionIdentifierRule uniqueTransactionIdentifierRule;
    @Inject
    protected UpiPostEnrichmentDataRule upiPostEnrichmentDataRule;
    @Inject
    protected UpiPreEnrichmentDataRule upiPreEnrichmentDataRule;
    @Inject
    protected ValuationAmountRule valuationAmountRule;
    @Inject
    protected ValuationCurrencyRule valuationCurrencyRule;
    @Inject
    protected ValuationMethodRule valuationMethodRule;
    @Inject
    protected ValuationTimestampRule valuationTimestampRule;
    @Inject
    protected VariationMarginCollateralPortfolioCodeDTCCRule variationMarginCollateralPortfolioCodeDTCCRule;

    public MASTransactionReport evaluate(TransactionReportInstruction input) {
        MASTransactionReport output;
        MASTransactionReport.MASTransactionReportBuilder outputBuilder = this.doEvaluate(input);
        if (outputBuilder == null) {
            output = null;
        } else {
            output = outputBuilder.build();
            this.objectValidator.validate(MASTransactionReport.class, (RosettaModelObject)output);
        }
        return output;
    }

    protected abstract MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction var1);

    public static class MASTradeReportFunctionDefault
    extends MASTradeReportFunction {
        @Override
        protected MASTransactionReport.MASTransactionReportBuilder doEvaluate(TransactionReportInstruction input) {
            MASTransactionReport.MASTransactionReportBuilder output = MASTransactionReport.builder();
            return this.assignOutput(output, input);
        }

        protected MASTransactionReport.MASTransactionReportBuilder assignOutput(MASTransactionReport.MASTransactionReportBuilder output, TransactionReportInstruction input) {
            output.setEffectiveDate(this.effectiveDateRule.evaluate(input));
            output.setReportingTimestamp(this.reportingTimestampRule.evaluate(input));
            output.setExecutionTimestamp(this.executionTimestampRule.evaluate(input));
            output.setExpirationDate(this.expirationDateRule.evaluate(input));
            output.setCounterparty1(this.counterparty1Rule.evaluate(input));
            output.setCounterparty2(this.counterparty2Rule.evaluate(input));
            output.setCounterparty2IdentifierTypeOverriddenAsBoolean(this.counterparty2IdentifierTypeRule.evaluate(input));
            output.setCleared(this.clearedRule.evaluate(input));
            output.setCentralCounterparty(this.centralCounterpartyRule.evaluate(input));
            output.setClearingMember(this.clearingMemberRule.evaluate(input));
            output.setConfirmed(this.confirmedRule.evaluate(input));
            output.setCallAmount(this.callAmountRule.evaluate(input));
            output.setPutAmount(this.putAmountRule.evaluate(input));
            output.setCallCurrency(this.callCurrencyRule.evaluate(input));
            output.setPutCurrency(this.putCurrencyRule.evaluate(input));
            output.setPriceSchedule((List)this.contractPriceScheduleRule.evaluate(input));
            output.setStrikePriceSchedule((List)this.strikePriceScheduleRule.evaluate(input));
            output.setPrice(this.priceRule.evaluate(input));
            output.setPriceNotation(this.priceNotationRule.evaluate(input));
            output.setPriceCurrency(this.priceCurrencyRule.evaluate(input));
            output.setPackageIdentifier(this.packageIdentifierRule.evaluate(input));
            output.setStrikePrice(this.strikePriceRule.evaluate(input));
            output.setStrikePriceNotation(this.strikePriceNotationRule.evaluate(input));
            output.setStrikePriceCurrency(this.strikePriceCurrencyCurrencyPairRule.evaluate(input));
            output.setPriceUnitOfMeasure(this.priceUnitOfMeasureRule.evaluate(input));
            output.setOptionPremiumAmount(this.optionPremiumAmountRule.evaluate(input));
            output.setOptionPremiumCurrency(this.optionPremiumCurrencyRule.evaluate(input));
            output.setExchangeRate(this.exchangeRateRule.evaluate(input));
            output.setExchangeRateBasis(this.exchangeRateBasisRule.evaluate(input));
            output.setCollateralPortfolioIndicator(this.collateralPortfolioIndicatorRule.evaluate(input));
            output.setFirstExerciseDate(this.firstExerciseDateRule.evaluate(input));
            output.setFinalContractualSettlementDate(this.finalContractualSettlementDateRule.evaluate(input));
            output.setPriorUTI(this.priorUTIRule.evaluate(input));
            output.setValuationAmount(this.valuationAmountRule.evaluate(input));
            output.setValuationCurrency(this.valuationCurrencyRule.evaluate(input));
            output.setValuationMethod(this.valuationMethodRule.evaluate(input));
            output.setValuationTimestamp(this.valuationTimestampRule.evaluate(input));
            output.setBasketConstituents((List)this.basketConstituentsRule.evaluate(input));
            output.setOtherPayment((List)this.otherPaymentRule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFixedRateDayCountConvention(this.fixedRateDayCountConventionLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRateDayCountConvention(this.floatingRateDayCountConventionLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFixedRatePaymentFrequencyPeriod(this.fixedRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRatePaymentFrequencyPeriod(this.floatingRatePaymentFrequencyPeriodLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFixedRatePaymentFrequencyPeriodMultiplier(this.fixedRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRatePaymentFrequencyPeriodMultiplier(this.floatingRatePaymentFrequencyPeriodMultiplierLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRateResetFrequencyPeriod(this.floatingRateResetFrequencyPeriodOfLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRateResetFrequencyMultiplier(this.floatingRateResetFrequencyMultiplierOfLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setFloatingRateIdentifier(this.floatingRateIdentifierLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().getOrCreatePeriodicPayment().setNameOfTheFloatingRate(this.nameOfTheFloatingRateLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setNotionalAmount(this.notionalAmountLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setNotionalAmountSchedule((List)this.notionalAmountScheduleLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setNotionalQuantitySchedule((List)this.notionalQuantityScheduleLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setNotionalCurrency(this.notionalCurrencyLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setTotalNotionalQuantity(this.totalNotionalQuantityLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setFixedRate(this.fixedRateLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setSettlementCurrency(this.settlementCurrencyLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setSpread(this.spreadLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setSpreadNotation(this.spreadNotationLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setSpreadCurrency(this.spreadCurrencyLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setQuantityUnitOfMeasure(this.quantityUnitOfMeasureLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setDirection2(this.direction2Leg1Rule.evaluate(input));
            output.getOrCreateLeg1().setNotionalQuantity(this.notionalQuantityLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setQuantityFrequency(this.quantityFrequencyPeriodLeg1Rule.evaluate(input));
            output.getOrCreateLeg1().setQuantityFrequencyMultiplier(this.quantityFrequencyPeriodMultiplierLeg1Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFixedRateDayCountConvention(this.fixedRateDayCountConventionLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRateDayCountConvention(this.floatingRateDayCountConventionLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFixedRatePaymentFrequencyPeriod(this.fixedRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRatePaymentFrequencyPeriod(this.floatingRatePaymentFrequencyPeriodLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFixedRatePaymentFrequencyPeriodMultiplier(this.fixedRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRatePaymentFrequencyPeriodMultiplier(this.floatingRatePaymentFrequencyPeriodMultiplierLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRateResetFrequencyPeriod(this.floatingRateResetFrequencyPeriodOfLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRateResetFrequencyMultiplier(this.floatingRateResetFrequencyMultiplierOfLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setFloatingRateIdentifier(this.floatingRateIdentifierLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().getOrCreatePeriodicPayment().setNameOfTheFloatingRate(this.nameOfTheFloatingRateLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setNotionalAmount(this.notionalAmountLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setNotionalAmountSchedule((List)this.notionalAmountScheduleLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setNotionalQuantitySchedule((List)this.notionalQuantityScheduleLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setNotionalCurrency(this.notionalCurrencyLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setTotalNotionalQuantity(this.totalNotionalQuantityLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setFixedRate(this.fixedRateLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setSettlementCurrency(this.settlementCurrencyLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setSpread(this.spreadLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setSpreadNotation(this.spreadNotationLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setSpreadCurrency(this.spreadCurrencyLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setQuantityUnitOfMeasure(this.quantityUnitOfMeasureLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setDirection2(this.direction2Leg2Rule.evaluate(input));
            output.getOrCreateLeg2().setNotionalQuantity(this.notionalQuantityLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setQuantityFrequency(this.quantityFrequencyPeriodLeg2Rule.evaluate(input));
            output.getOrCreateLeg2().setQuantityFrequencyMultiplier(this.quantityFrequencyPeriodMultiplierLeg2Rule.evaluate(input));
            output.setUnderlyingIdOther(this.underlyingIdOtherDTCCRule.evaluate(input));
            output.setUnderlyingIdOtherSource(this.underlyingIdOtherSourceDTCCRule.evaluate(input));
            output.setActionType(this.actionTypeRule.evaluate(input));
            output.setEventType(this.eventTypeRule.evaluate(input));
            output.setEventTimestampOverriddenAsZonedDateTime(this.eventTimestampRule.evaluate(input));
            output.setCounterparty2Name(this.counterparty2NameDTCCRule.evaluate(input));
            output.setExecutionAgentCounterparty1(this.executionAgentCounterparty1DTCCRule.evaluate(input));
            output.setExecutionAgentCounterparty2(this.executionAgentCounterparty2DTCCRule.evaluate(input));
            output.setReportSubmittingEntityID(this.dataSubmitterRule.evaluate(input));
            output.setUniqueTransactionIdentifier(this.uniqueTransactionIdentifierRule.evaluate(input));
            output.setUniqueTransactionIdentifierProprietary(this.uniqueTransactionIdentifierProprietaryRule.evaluate(input));
            output.setPriorUTIProprietary(this.priorUTIProprietaryRule.evaluate(input));
            output.setUniqueProductIdentifier(this.uniqueProductIdentifierRule.evaluate(input));
            output.setContractTypeOverriddenAsCommonContractType(this.contractTypeRule.evaluate(input));
            output.setAssetClassOverriddenAsCommonAssetClass(this.assetClassRule.evaluate(input));
            output.setClearingTimestamp(this.clearingTimestampRule.evaluate(input));
            output.setPlatformIdentifier(this.platformIdentifierRule.evaluate(input));
            output.setDirection1(this.directionRule.evaluate(input));
            output.setNameOfTheUnderlyingIndex(this.nameOfTheUnderlyingIndexDTCCRule.evaluate(input));
            output.setOptionType(this.optionTypeRule.evaluate(input));
            output.setOptionStyle(this.optionStyleRule.evaluate(input));
            output.setDeliveryType(this.deliveryTypeRule.evaluate(input));
            output.setBookingLocation(this.bookingLocationRule.evaluate(input));
            output.setTraderLocation(this.traderLocationRule.evaluate(input));
            output.setTradingCapacity(this.tradingCapacityOfSpecifiedPersonRule.evaluate(input));
            output.setTechnicalRecordIdOverriddenAsString(this.technicalRecordIdRule.evaluate(input));
            output.setInitialMarginCollateralPortfolioCode(this.initialMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
            output.setVariationMarginCollateralPortfolioCodeOverriddenAsString(this.variationMarginCollateralPortfolioCodeDTCCRule.evaluate(input));
            output.setConfirmationTimestamp(this.confirmationTimestampRule.evaluate(input));
            output.setSwapLinkID(this.swapLinkIDRule.evaluate(input));
            output.setUnderlyingIdentification(this.underlyingRule.evaluate(input));
            output.setUnderlyingIdentificationType(this.underlyingIdentificationTypeDTCCRule.evaluate(input));
            output.getOrCreateNonReportable().setEnrichment(this.enrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPreUpiData(this.upiPreEnrichmentDataRule.evaluate(input));
            output.getOrCreateNonReportable().setPostUpiData(this.upiPostEnrichmentDataRule.evaluate(input));
            output.setTradingCapacityOfSpecifiedPerson(this.tradingCapacityOfSpecifiedPersonRule.evaluate(input));
            output.setReportingSpecifiedPerson(this.reportingSpecifiedPersonRule.evaluate(input));
            return Optional.ofNullable(output).map(o -> o.prune()).orElse(null);
        }
    }
}

